/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle;

import boofcv.abst.geo.bundle.BundleAdjustmentSchur;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.geo.bundle.jacobians.JacobianSo3;
import boofcv.alg.geo.bundle.jacobians.JacobianSo3Rodrigues;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.ReshapeMatrix;
import org.ejml.dense.row.CommonOps_DDRM;

public abstract class BundleAdjustmentMetricSchurJacobian<M extends DMatrix>
implements BundleAdjustmentSchur.Jacobian<SceneStructureMetric, M> {
    private SceneStructureMetric structure;
    private SceneObservations observations;
    private int numViewsUnknown;
    private int numRigidUnknown;
    private int numParameters;
    private int lengthPoint;
    private JacobianSo3 jacSO3 = new JacobianSo3Rodrigues();
    private Se3_F64 worldToView = new Se3_F64();
    private JacobianSo3[] jacRigidS03;
    private Point3D_F64 worldPt3 = new Point3D_F64();
    private Point4D_F64 worldPt4 = new Point4D_F64();
    private Point3D_F64 rigidPt3 = new Point3D_F64();
    private Point4D_F64 rigidPt4 = new Point4D_F64();
    private Point3D_F64 cameraPt = new Point3D_F64();
    private int lengthSE3;
    private int indexFirstRigid;
    private int indexFirstView;
    private int indexLastView;
    private int[] rigidParameterIndexes;
    private int[] viewParameterIndexes;
    private int[] cameraParameterIndexes;
    private int jacRowX;
    private int jacRowY;
    private double[] pointGradX = new double[3];
    private double[] pointGradY = new double[3];
    private double[] calibGradX = null;
    private double[] calibGradY = null;
    DMatrixRMaj RR = new DMatrixRMaj(3, 3);

    @Override
    public void configure(SceneStructureMetric structure, SceneObservations observations) {
        int i;
        this.structure = structure;
        this.observations = observations;
        this.lengthPoint = !structure.isHomogenous() ? 3 : 4;
        this.lengthSE3 = 3 + this.jacSO3.getParameterLength();
        this.numRigidUnknown = structure.getUnknownRigidCount();
        this.numViewsUnknown = structure.getUnknownViewCount();
        int numCameraParameters = structure.getUnknownCameraParameterCount();
        this.indexFirstRigid = structure.points.size * this.lengthPoint;
        this.indexFirstView = this.indexFirstRigid + this.numRigidUnknown * this.lengthSE3;
        this.indexLastView = this.indexFirstView + this.numViewsUnknown * this.lengthSE3;
        this.numParameters = this.indexLastView + numCameraParameters;
        this.jacRigidS03 = new JacobianSo3[structure.rigids.size];
        this.rigidParameterIndexes = new int[this.jacRigidS03.length];
        int index = 0;
        for (i = 0; i < this.jacRigidS03.length; ++i) {
            this.rigidParameterIndexes[i] = index;
            this.jacRigidS03[i] = new JacobianSo3Rodrigues();
            if (((SceneStructureMetric.Rigid)structure.rigids.get((int)i)).known) continue;
            index += this.lengthSE3;
        }
        this.viewParameterIndexes = new int[structure.views.size];
        index = 0;
        for (i = 0; i < structure.views.size; ++i) {
            this.viewParameterIndexes[i] = index;
            if (((SceneStructureMetric.View[])structure.views.data)[i].known) continue;
            index += this.lengthSE3;
        }
        this.cameraParameterIndexes = new int[structure.cameras.size];
        int largestCameraSize = 0;
        int index2 = 0;
        for (int i2 = 0; i2 < structure.cameras.size; ++i2) {
            if (((SceneStructureCommon.Camera)structure.cameras.get((int)i2)).known) continue;
            this.cameraParameterIndexes[i2] = index2;
            int count = ((SceneStructureCommon.Camera[])structure.cameras.data)[i2].model.getIntrinsicCount();
            largestCameraSize = Math.max(largestCameraSize, count);
            index2 += count;
        }
        this.calibGradX = new double[largestCameraSize];
        this.calibGradY = new double[largestCameraSize];
    }

    public int getNumOfInputsN() {
        return this.numParameters;
    }

    public int getNumOfOutputsM() {
        return this.observations.getObservationCount() * 2;
    }

    private int computeGeneralPoints(DMatrix leftPoint, DMatrix rightView, double[] input, int observationIndex, int viewIndex, SceneStructureMetric.View view, SceneStructureCommon.Camera camera, int cameraParamStartIndex) {
        SceneObservations.View obsView = (SceneObservations.View)this.observations.views.get(viewIndex);
        for (int i = 0; i < obsView.size(); ++i) {
            int featureIndex = obsView.point.get(i);
            int columnOfPointInJac = featureIndex * this.lengthPoint;
            if (this.structure.isHomogenous()) {
                this.worldPt4.x = input[columnOfPointInJac];
                this.worldPt4.y = input[columnOfPointInJac + 1];
                this.worldPt4.z = input[columnOfPointInJac + 2];
                this.worldPt4.w = input[columnOfPointInJac + 3];
                SePointOps_F64.transform((Se3_F64)this.worldToView, (Point4D_F64)this.worldPt4, (Point3D_F64)this.cameraPt);
            } else {
                this.worldPt3.x = input[columnOfPointInJac];
                this.worldPt3.y = input[columnOfPointInJac + 1];
                this.worldPt3.z = input[columnOfPointInJac + 2];
                SePointOps_F64.transform((Se3_F64)this.worldToView, (Point3D_F64)this.worldPt3, (Point3D_F64)this.cameraPt);
            }
            this.jacRowX = observationIndex * 2;
            this.jacRowY = this.jacRowX + 1;
            if (!camera.known) {
                int N = camera.model.getIntrinsicCount();
                camera.model.jacobian(this.cameraPt.x, this.cameraPt.y, this.cameraPt.z, this.pointGradX, this.pointGradY, true, this.calibGradX, this.calibGradY);
                int location = this.indexLastView - this.indexFirstView + cameraParamStartIndex;
                for (int j = 0; j < N; ++j) {
                    this.set(rightView, this.jacRowX, location + j, this.calibGradX[j]);
                    this.set(rightView, this.jacRowY, location + j, this.calibGradY[j]);
                }
            } else {
                camera.model.jacobian(this.cameraPt.x, this.cameraPt.y, this.cameraPt.z, this.pointGradX, this.pointGradY, false, null, null);
            }
            if (this.structure.isHomogenous()) {
                this.partialPointH(leftPoint, rightView, viewIndex, view, columnOfPointInJac);
            } else {
                this.partialPoint3(leftPoint, rightView, viewIndex, view, columnOfPointInJac);
            }
            ++observationIndex;
        }
        return observationIndex;
    }

    public void internalProcess(double[] input, DMatrix leftPoint, DMatrix rightView) {
        int numRows = this.getNumOfOutputsM();
        int numPointParam = this.structure.points.size * this.lengthPoint + this.numRigidUnknown * this.lengthSE3;
        int numViewParam = this.numParameters - numPointParam;
        ((ReshapeMatrix)leftPoint).reshape(numRows, numPointParam);
        ((ReshapeMatrix)rightView).reshape(numRows, numViewParam);
        leftPoint.zero();
        rightView.zero();
        for (int rigidIndex = 0; rigidIndex < this.structure.rigids.size; ++rigidIndex) {
            if (((SceneStructureMetric.Rigid)this.structure.rigids.get((int)rigidIndex)).known) continue;
            this.jacRigidS03[rigidIndex].setParameters(input, this.indexFirstRigid + this.rigidParameterIndexes[rigidIndex]);
        }
        int observationIndex = 0;
        for (int viewIndex = 0; viewIndex < this.structure.views.size; ++viewIndex) {
            SceneStructureMetric.View view = ((SceneStructureMetric.View[])this.structure.views.data)[viewIndex];
            SceneStructureCommon.Camera camera = ((SceneStructureCommon.Camera[])this.structure.cameras.data)[view.camera];
            if (!view.known) {
                int paramIndex = this.viewParameterIndexes[viewIndex] + this.indexFirstView;
                this.jacSO3.setParameters(input, paramIndex);
                this.worldToView.T.x = input[paramIndex += this.jacSO3.getParameterLength()];
                this.worldToView.T.y = input[paramIndex + 1];
                this.worldToView.T.z = input[paramIndex + 2];
                this.worldToView.getR().set((DMatrixD1)this.jacSO3.getRotationMatrix());
            } else {
                this.worldToView.set(view.worldToView);
            }
            int cameraParamStartIndex = this.cameraParameterIndexes[view.camera];
            if (!camera.known) {
                camera.model.setIntrinsic(input, this.indexLastView + cameraParamStartIndex);
            }
            observationIndex = this.computeGeneralPoints(leftPoint, rightView, input, observationIndex, viewIndex, view, camera, cameraParamStartIndex);
            if (!this.observations.hasRigid()) continue;
            observationIndex = this.computeRigidPoints(leftPoint, rightView, observationIndex, viewIndex, view, camera, cameraParamStartIndex);
        }
    }

    private int computeRigidPoints(DMatrix leftPoint, DMatrix rightView, int observationIndex, int viewIndex, SceneStructureMetric.View view, SceneStructureCommon.Camera camera, int cameraParamStartIndex) {
        SceneObservations.View obsView = (SceneObservations.View)this.observations.viewsRigid.get(viewIndex);
        for (int i = 0; i < obsView.size(); ++i) {
            int featureIndex = obsView.point.get(i);
            int rigidIndex = this.structure.lookupRigid[featureIndex];
            SceneStructureMetric.Rigid rigid = (SceneStructureMetric.Rigid)this.structure.rigids.get(rigidIndex);
            int pointIndex = featureIndex - rigid.indexFirst;
            if (this.structure.isHomogenous()) {
                rigid.getPoint(pointIndex, this.rigidPt4);
                SePointOps_F64.transform((Se3_F64)rigid.objectToWorld, (Point4D_F64)this.rigidPt4, (Point3D_F64)this.worldPt3);
            } else {
                rigid.getPoint(pointIndex, this.rigidPt3);
                SePointOps_F64.transform((Se3_F64)rigid.objectToWorld, (Point3D_F64)this.rigidPt3, (Point3D_F64)this.worldPt3);
            }
            SePointOps_F64.transform((Se3_F64)this.worldToView, (Point3D_F64)this.worldPt3, (Point3D_F64)this.cameraPt);
            this.jacRowX = observationIndex * 2;
            this.jacRowY = this.jacRowX + 1;
            if (!camera.known) {
                int N = camera.model.getIntrinsicCount();
                camera.model.jacobian(this.cameraPt.x, this.cameraPt.y, this.cameraPt.z, this.pointGradX, this.pointGradY, true, this.calibGradX, this.calibGradY);
                int location = this.indexLastView - this.indexFirstView + cameraParamStartIndex;
                for (int j = 0; j < N; ++j) {
                    this.set(rightView, this.jacRowX, location + j, this.calibGradX[j]);
                    this.set(rightView, this.jacRowY, location + j, this.calibGradY[j]);
                }
            } else {
                camera.model.jacobian(this.cameraPt.x, this.cameraPt.y, this.cameraPt.z, this.pointGradX, this.pointGradY, false, null, null);
            }
            if (!view.known) {
                this.partialViewSE3(rightView, viewIndex, view, this.worldPt3.x, this.worldPt3.y, this.worldPt3.z, 1.0);
            }
            if (!rigid.known) {
                if (this.structure.isHomogenous()) {
                    this.partialRigidSE3(leftPoint, rigidIndex, this.rigidPt4.x, this.rigidPt4.y, this.rigidPt4.z, this.rigidPt4.w);
                } else {
                    this.partialRigidSE3(leftPoint, rigidIndex, this.rigidPt3.x, this.rigidPt3.y, this.rigidPt3.z, 1.0);
                }
            }
            ++observationIndex;
        }
        return observationIndex;
    }

    private void partialPoint3(DMatrix leftPoint, DMatrix rightView, int viewIndex, SceneStructureMetric.View view, int columnOfPointInJac) {
        this.addToJacobian(leftPoint, columnOfPointInJac, this.pointGradX, this.pointGradY, this.worldToView.R);
        this.partialViewSE3(rightView, viewIndex, view, this.worldPt3.x, this.worldPt3.y, this.worldPt3.z, 1.0);
    }

    private void partialPointH(DMatrix leftPoint, DMatrix rightView, int viewIndex, SceneStructureMetric.View view, int columnOfPointInJac) {
        this.addToJacobian(leftPoint, columnOfPointInJac, this.pointGradX, this.pointGradY, this.worldToView.R);
        this.addToJacobian(leftPoint, columnOfPointInJac + 3, this.pointGradX, this.pointGradY, this.worldToView.T);
        this.partialViewSE3(rightView, viewIndex, view, this.worldPt4.x, this.worldPt4.y, this.worldPt4.z, this.worldPt4.w);
    }

    private void partialViewSE3(DMatrix rightView, int viewIndex, SceneStructureMetric.View view, double X, double Y, double Z, double W) {
        if (!view.known) {
            int col = this.viewParameterIndexes[viewIndex];
            int N = this.jacSO3.getParameterLength();
            for (int i = 0; i < this.jacSO3.getParameterLength(); ++i) {
                this.addToJacobian(rightView, col + i, this.pointGradX, this.pointGradY, this.jacSO3.getPartial(i), X, Y, Z);
            }
            this.set(rightView, this.jacRowX, col + N, this.pointGradX[0] * W);
            this.set(rightView, this.jacRowY, col + N, this.pointGradY[0] * W);
            this.set(rightView, this.jacRowX, col + N + 1, this.pointGradX[1] * W);
            this.set(rightView, this.jacRowY, col + N + 1, this.pointGradY[1] * W);
            this.set(rightView, this.jacRowX, col + N + 2, this.pointGradX[2] * W);
            this.set(rightView, this.jacRowY, col + N + 2, this.pointGradY[2] * W);
        }
    }

    private void partialRigidSE3(DMatrix leftPoint, int rigidIndex, double X, double Y, double Z, double W) {
        int col = this.rigidParameterIndexes[rigidIndex] + this.indexFirstRigid;
        JacobianSo3 jac = this.jacRigidS03[rigidIndex];
        int N = jac.getParameterLength();
        for (int i = 0; i < N; ++i) {
            CommonOps_DDRM.mult((DMatrix1Row)this.worldToView.R, (DMatrix1Row)jac.getPartial(i), (DMatrix1Row)this.RR);
            this.addToJacobian(leftPoint, col + i, this.pointGradX, this.pointGradY, this.RR, X, Y, Z);
        }
        double RX0 = this.worldToView.R.data[0] * this.pointGradX[0] + this.worldToView.R.data[3] * this.pointGradX[1] + this.worldToView.R.data[6] * this.pointGradX[2];
        double RX1 = this.worldToView.R.data[1] * this.pointGradX[0] + this.worldToView.R.data[4] * this.pointGradX[1] + this.worldToView.R.data[7] * this.pointGradX[2];
        double RX2 = this.worldToView.R.data[2] * this.pointGradX[0] + this.worldToView.R.data[5] * this.pointGradX[1] + this.worldToView.R.data[8] * this.pointGradX[2];
        double RY0 = this.worldToView.R.data[0] * this.pointGradY[0] + this.worldToView.R.data[3] * this.pointGradY[1] + this.worldToView.R.data[6] * this.pointGradY[2];
        double RY1 = this.worldToView.R.data[1] * this.pointGradY[0] + this.worldToView.R.data[4] * this.pointGradY[1] + this.worldToView.R.data[7] * this.pointGradY[2];
        double RY2 = this.worldToView.R.data[2] * this.pointGradY[0] + this.worldToView.R.data[5] * this.pointGradY[1] + this.worldToView.R.data[8] * this.pointGradY[2];
        this.set(leftPoint, this.jacRowX, col + N, RX0 * W);
        this.set(leftPoint, this.jacRowY, col + N, RY0 * W);
        this.set(leftPoint, this.jacRowX, col + N + 1, RX1 * W);
        this.set(leftPoint, this.jacRowY, col + N + 1, RY1 * W);
        this.set(leftPoint, this.jacRowX, col + N + 2, RX2 * W);
        this.set(leftPoint, this.jacRowY, col + N + 2, RY2 * W);
    }

    private void addToJacobian(DMatrix tripplet, int col, double[] a, double[] b, DMatrixRMaj R) {
        this.set(tripplet, this.jacRowX, col + 0, a[0] * R.data[0] + a[1] * R.data[3] + a[2] * R.data[6]);
        this.set(tripplet, this.jacRowX, col + 1, a[0] * R.data[1] + a[1] * R.data[4] + a[2] * R.data[7]);
        this.set(tripplet, this.jacRowX, col + 2, a[0] * R.data[2] + a[1] * R.data[5] + a[2] * R.data[8]);
        this.set(tripplet, this.jacRowY, col + 0, b[0] * R.data[0] + b[1] * R.data[3] + b[2] * R.data[6]);
        this.set(tripplet, this.jacRowY, col + 1, b[0] * R.data[1] + b[1] * R.data[4] + b[2] * R.data[7]);
        this.set(tripplet, this.jacRowY, col + 2, b[0] * R.data[2] + b[1] * R.data[5] + b[2] * R.data[8]);
    }

    private void addToJacobian(DMatrix tripplet, int col, double[] a, double[] b, DMatrixRMaj R, double X, double Y, double Z) {
        double x = R.data[0] * X + R.data[1] * Y + R.data[2] * Z;
        double y = R.data[3] * X + R.data[4] * Y + R.data[5] * Z;
        double z = R.data[6] * X + R.data[7] * Y + R.data[8] * Z;
        this.set(tripplet, this.jacRowX, col, a[0] * x + a[1] * y + a[2] * z);
        this.set(tripplet, this.jacRowY, col, b[0] * x + b[1] * y + b[2] * z);
    }

    private void addToJacobian(DMatrix tripplet, int col, double[] a, double[] b, Vector3D_F64 X) {
        this.set(tripplet, this.jacRowX, col, a[0] * X.x + a[1] * X.y + a[2] * X.z);
        this.set(tripplet, this.jacRowY, col, b[0] * X.x + b[1] * X.y + b[2] * X.z);
    }

    protected abstract void set(DMatrix var1, int var2, int var3, double var4);
}

