/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.calib;

import boofcv.struct.calib.CameraPinholeBrown;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.EulerType;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import java.io.Serializable;
import org.ejml.data.DMatrixRMaj;

public class StereoParameters
implements Serializable {
    public static final long serialVersionUID = 1L;
    public CameraPinholeBrown left;
    public CameraPinholeBrown right;
    public Se3_F64 rightToLeft;

    public StereoParameters(StereoParameters param) {
        this(param.left, param.right, param.getRightToLeft());
    }

    public StereoParameters(CameraPinholeBrown left, CameraPinholeBrown right, Se3_F64 rightToLeft) {
        this.left = new CameraPinholeBrown(left);
        this.rightToLeft = rightToLeft.copy();
        this.right = new CameraPinholeBrown(right);
    }

    public StereoParameters() {
    }

    public CameraPinholeBrown getLeft() {
        return this.left;
    }

    public void setLeft(CameraPinholeBrown left) {
        this.left = left;
    }

    public Se3_F64 getRightToLeft() {
        return this.rightToLeft;
    }

    public void setRightToLeft(Se3_F64 rightToLeft) {
        this.rightToLeft = rightToLeft;
    }

    public CameraPinholeBrown getRight() {
        return this.right;
    }

    public void setRight(CameraPinholeBrown right) {
        this.right = right;
    }

    public double getBaseline() {
        return this.rightToLeft.getT().norm();
    }

    public boolean isRectified(double tol) {
        double angle;
        return !this.left.isDistorted() && !this.right.isDistorted() && Math.abs(angle = ConvertRotation3D_F64.matrixToRodrigues((DMatrixRMaj)this.rightToLeft.R, null).theta) < tol;
    }

    public void print() {
        double[] euler = ConvertRotation3D_F64.matrixToEuler((DMatrixRMaj)this.rightToLeft.getR(), (EulerType)EulerType.XYZ, (double[])null);
        Vector3D_F64 t = this.rightToLeft.getT();
        System.out.println();
        System.out.println("Left Camera");
        this.left.print();
        System.out.println();
        System.out.println("Right Camera");
        this.right.print();
        System.out.println("Right to Left");
        System.out.printf("  Euler XYZ   [ %8.3f , %8.3f , %8.3f ]\n", euler[0], euler[1], euler[2]);
        System.out.printf("  Translation [ %8.3f , %8.3f , %8.3f ]\n", t.x, t.y, t.z);
    }
}

