/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.geo;

import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;

public class AssociatedTriple {
    public Point2D_F64 p1;
    public Point2D_F64 p2;
    public Point2D_F64 p3;

    public AssociatedTriple(Point2D_F64 p1, Point2D_F64 p2, Point2D_F64 p3) {
        this(p1, p2, p3, true);
    }

    public AssociatedTriple(Point2D_F64 p1, Point2D_F64 p2, Point2D_F64 p3, boolean newInstance) {
        if (newInstance) {
            this.p1 = p1.copy();
            this.p2 = p2.copy();
            this.p3 = p3.copy();
        } else {
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
        }
    }

    public AssociatedTriple() {
        this.p1 = new Point2D_F64();
        this.p2 = new Point2D_F64();
        this.p3 = new Point2D_F64();
    }

    public void set(AssociatedTriple a) {
        this.p1.set(a.p1);
        this.p2.set(a.p2);
        this.p3.set(a.p3);
    }

    public void set(Point2D_F64 p1, Point2D_F64 p2, Point2D_F64 p3) {
        this.p1.set(p1);
        this.p2.set(p2);
        this.p3.set(p3);
    }

    public AssociatedTriple copy() {
        AssociatedTriple r = new AssociatedTriple();
        r.set(this);
        return r;
    }

    public Point2D_F64 get(int i) {
        switch (i) {
            case 0: {
                return this.p1;
            }
            case 1: {
                return this.p2;
            }
            case 2: {
                return this.p3;
            }
        }
        throw new IllegalArgumentException("index must be 0,1,2");
    }

    public void set(int i, double x, double y) {
        switch (i) {
            case 0: {
                this.p1.set(x, y);
                break;
            }
            case 1: {
                this.p2.set(x, y);
                break;
            }
            case 2: {
                this.p3.set(x, y);
                break;
            }
            default: {
                throw new IllegalArgumentException("index must be 0,1,2");
            }
        }
    }

    public boolean isIdentical(AssociatedTriple o, double tol) {
        if (tol < o.p1.distance((GeoTuple2D_F64)this.p1)) {
            return false;
        }
        if (tol < o.p2.distance((GeoTuple2D_F64)this.p2)) {
            return false;
        }
        return tol >= o.p3.distance((GeoTuple2D_F64)this.p3);
    }

    public void print() {
        System.out.println("AssociatedTriple( " + this.p1 + " , " + this.p2 + " , " + this.p3 + " )");
    }
}

