/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.cloud;

import boofcv.struct.Point3dRgbI_F32;
import boofcv.struct.Point3dRgbI_F64;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Point3D_F64;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_F32;
import org.ddogleg.struct.GrowQueue_I32;

public interface PointCloudWriter {
    public void init(int var1);

    public void add(double var1, double var3, double var5);

    public void add(double var1, double var3, double var5, int var7);

    public static PointCloudWriter wrapF32(final FastQueue<Point3D_F32> cloud) {
        return new PointCloudWriter(){

            @Override
            public void init(int estimatedSize) {
                cloud.growArray(estimatedSize);
                cloud.reset();
            }

            @Override
            public void add(double x, double y, double z) {
                ((Point3D_F32)cloud.grow()).set((float)x, (float)y, (float)z);
            }

            @Override
            public void add(double x, double y, double z, int rgb) {
                ((Point3D_F32)cloud.grow()).set((float)x, (float)y, (float)z);
            }
        };
    }

    public static PointCloudWriter wrapF64(final FastQueue<Point3D_F64> cloud) {
        return new PointCloudWriter(){

            @Override
            public void init(int estimatedSize) {
                cloud.growArray(estimatedSize);
                cloud.reset();
            }

            @Override
            public void add(double x, double y, double z) {
                ((Point3D_F64)cloud.grow()).set(x, y, z);
            }

            @Override
            public void add(double x, double y, double z, int rgb) {
                ((Point3D_F64)cloud.grow()).set(x, y, z);
            }
        };
    }

    public static PointCloudWriter wrapF32RGB(final FastQueue<Point3dRgbI_F32> cloud) {
        return new PointCloudWriter(){

            @Override
            public void init(int estimatedSize) {
                cloud.growArray(estimatedSize);
                cloud.reset();
            }

            @Override
            public void add(double x, double y, double z) {
                ((Point3dRgbI_F32)cloud.grow()).set((float)x, (float)y, (float)z);
            }

            @Override
            public void add(double x, double y, double z, int rgb) {
                ((Point3dRgbI_F32)cloud.grow()).set((float)x, (float)y, (float)z, rgb);
            }
        };
    }

    public static PointCloudWriter wrapF64RGB(final FastQueue<Point3dRgbI_F64> cloud) {
        return new PointCloudWriter(){

            @Override
            public void init(int estimatedSize) {
                cloud.growArray(estimatedSize);
                cloud.reset();
            }

            @Override
            public void add(double x, double y, double z) {
                ((Point3dRgbI_F64)cloud.grow()).set(x, y, z);
            }

            @Override
            public void add(double x, double y, double z, int rgb) {
                ((Point3dRgbI_F64)cloud.grow()).set(x, y, z, rgb);
            }
        };
    }

    public static class CloudArraysF32
    implements PointCloudWriter {
        public GrowQueue_F32 cloudXyz = new GrowQueue_F32();
        public GrowQueue_I32 cloudRgb = new GrowQueue_I32();

        @Override
        public void init(int estimatedSize) {
            this.cloudRgb.setMaxSize(estimatedSize);
            this.cloudXyz.setMaxSize(estimatedSize * 3);
            this.cloudRgb.reset();
            this.cloudXyz.reset();
        }

        @Override
        public void add(double x, double y, double z) {
            this.cloudXyz.add((float)x);
            this.cloudXyz.add((float)y);
            this.cloudXyz.add((float)z);
        }

        @Override
        public void add(double x, double y, double z, int rgb) {
            this.cloudXyz.add((float)x);
            this.cloudXyz.add((float)y);
            this.cloudXyz.add((float)z);
            this.cloudRgb.add(rgb);
        }
    }
}

