/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.cloud;

import boofcv.alg.cloud.PointCloudWriter;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.geometry.GeometryMath_F32;
import georegression.struct.GeoTuple3D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F32;
import georegression.struct.shapes.Rectangle2D_I32;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.FMatrixRMaj;
import org.ejml.ops.ConvertMatrixData;

public class DisparityToColorPointCloud {
    float baseline;
    DMatrixRMaj K;
    float focalLengthX;
    float focalLengthY;
    float centerX;
    float centerY;
    FMatrixRMaj rectifiedR = new FMatrixRMaj(3, 3);
    int disparityMin;
    int disparityRange;
    public double radius = 5.0;
    Point2Transform2_F64 rectifiedToColor;
    Point2D_F64 colorPt = new Point2D_F64();
    Point3D_F32 p = new Point3D_F32();
    Rectangle2D_I32 roi = new Rectangle2D_I32();

    public void configure(double baseline, DMatrixRMaj K, DMatrixRMaj rectifiedR, Point2Transform2_F64 rectifiedToColor, int disparityMin, int disparityRange) {
        this.K = K;
        ConvertMatrixData.convert((DMatrixRMaj)rectifiedR, (FMatrixRMaj)this.rectifiedR);
        this.rectifiedToColor = rectifiedToColor;
        this.baseline = (float)baseline;
        this.focalLengthX = (float)K.get(0, 0);
        this.focalLengthY = (float)K.get(1, 1);
        this.centerX = (float)K.get(0, 2);
        this.centerY = (float)K.get(1, 2);
        this.disparityMin = disparityMin;
        this.disparityRange = disparityRange;
        this.clearRegionOfInterest();
    }

    public void process(ImageGray<?> disparity, ColorImage color, PointCloudWriter output) {
        if (disparity instanceof GrayU8) {
            this.process((GrayU8)disparity, color, output);
        } else if (disparity instanceof GrayF32) {
            this.process((GrayF32)disparity, color, output);
        } else {
            throw new IllegalArgumentException("Unsupported image type " + disparity.getClass().getSimpleName());
        }
    }

    private void process(GrayU8 disparity, ColorImage color, PointCloudWriter output) {
        int x0 = Math.max(this.roi.x0, 0);
        int y0 = Math.max(this.roi.y0, 0);
        int x1 = Math.min(this.roi.x1, disparity.width);
        int y1 = Math.min(this.roi.y1, disparity.height);
        for (int pixelY = y0; pixelY < y1; ++pixelY) {
            int index = disparity.startIndex + disparity.stride * pixelY + x0;
            for (int pixelX = x0; pixelX < x1; ++pixelX) {
                int value;
                if ((value = disparity.data[index++] & 0xFF) >= this.disparityRange || (value += this.disparityMin) == 0) continue;
                this.p.z = this.baseline * this.focalLengthX / (float)value;
                this.p.x = this.p.z * ((float)pixelX - this.centerX) / this.focalLengthX;
                this.p.y = this.p.z * ((float)pixelY - this.centerY) / this.focalLengthY;
                GeometryMath_F32.multTran((FMatrixRMaj)this.rectifiedR, (GeoTuple3D_F32)this.p, (GeoTuple3D_F32)this.p);
                output.add(this.p.x, this.p.y, this.p.z, this.getColor(color, pixelX, pixelY));
            }
        }
    }

    private void process(GrayF32 disparity, ColorImage color, PointCloudWriter output) {
        int x0 = Math.max(this.roi.x0, 0);
        int y0 = Math.max(this.roi.y0, 0);
        int x1 = Math.min(this.roi.x1, disparity.width);
        int y1 = Math.min(this.roi.y1, disparity.height);
        for (int pixelY = y0; pixelY < y1; ++pixelY) {
            int index = disparity.startIndex + disparity.stride * pixelY + x0;
            for (int pixelX = x0; pixelX < x1; ++pixelX) {
                float value;
                if ((value = disparity.data[index++]) >= (float)this.disparityRange || (value += (float)this.disparityMin) == 0.0f) continue;
                this.p.z = this.baseline * this.focalLengthX / value;
                this.p.x = this.p.z * ((float)pixelX - this.centerX) / this.focalLengthX;
                this.p.y = this.p.z * ((float)pixelY - this.centerY) / this.focalLengthY;
                GeometryMath_F32.multTran((FMatrixRMaj)this.rectifiedR, (GeoTuple3D_F32)this.p, (GeoTuple3D_F32)this.p);
                output.add(this.p.x, this.p.y, this.p.z, this.getColor(color, pixelX, pixelY));
            }
        }
    }

    private int getColor(ColorImage color, int x, int y) {
        this.rectifiedToColor.compute((double)x, (double)y, this.colorPt);
        int xx = (int)this.colorPt.getX();
        int yy = (int)this.colorPt.getY();
        if (color.isInBounds(xx, yy)) {
            return color.getRGB(xx, yy);
        }
        return 0;
    }

    public void setRegionOfInterest(int x0, int y0, int x1, int y1) {
        this.roi.setTo(x0, y0, x1, y1);
    }

    public void clearRegionOfInterest() {
        this.roi.setTo(-1, -1, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public static interface ColorImage {
        public boolean isInBounds(int var1, int var2);

        public int getRGB(int var1, int var2);
    }
}

