/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.universal;

import boofcv.alg.distort.brown.RadialTangential_F32;
import boofcv.alg.distort.brown.RemoveBrownNtoN_F32;
import boofcv.struct.calib.CameraUniversalOmni;
import boofcv.struct.distort.Point2Transform3_F32;
import georegression.geometry.GeometryMath_F32;
import georegression.misc.GrlConstants;
import georegression.struct.GeoTuple2D_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point3D_F32;
import org.ejml.data.FMatrixD1;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.CommonOps_FDRM;

public class UniOmniPtoS_F32
implements Point2Transform3_F32 {
    float mirrorOffset;
    protected RadialTangential_F32 distortion = new RadialTangential_F32();
    private Point2D_F32 p2 = new Point2D_F32();
    private float tol = GrlConstants.FCONV_TOL_A;
    protected FMatrixRMaj K_inv = new FMatrixRMaj(3, 3);

    public UniOmniPtoS_F32(CameraUniversalOmni model) {
        this.setModel(model);
    }

    public UniOmniPtoS_F32() {
    }

    public float getTol() {
        return this.tol;
    }

    public void setTol(float tol) {
        this.tol = tol;
    }

    public void setModel(CameraUniversalOmni model) {
        this.mirrorOffset = (float)model.mirrorOffset;
        this.distortion.set(model.radial, model.t1, model.t2);
        this.K_inv.set(0, 0, (float)model.fx);
        this.K_inv.set(1, 1, (float)model.fy);
        this.K_inv.set(0, 1, (float)model.skew);
        this.K_inv.set(0, 2, (float)model.cx);
        this.K_inv.set(1, 2, (float)model.cy);
        this.K_inv.set(2, 2, 1.0f);
        CommonOps_FDRM.invert((FMatrixRMaj)this.K_inv);
    }

    public void compute(float x, float y, Point3D_F32 out) {
        this.p2.x = x;
        this.p2.y = y;
        GeometryMath_F32.mult((FMatrixRMaj)this.K_inv, (GeoTuple2D_F32)this.p2, (GeoTuple2D_F32)this.p2);
        RemoveBrownNtoN_F32.removeRadial(this.p2.x, this.p2.y, this.distortion.radial, this.distortion.t1, this.distortion.t2, this.p2, this.tol);
        float u = this.p2.x;
        float v = this.p2.y;
        float xi = this.mirrorOffset;
        float a = u * u + v * v + 1.0f;
        float b = -2.0f * xi;
        float c = xi * xi - 1.0f;
        float t = (-b + (float)Math.sqrt(b * b - 4.0f * a * c)) / (2.0f * a);
        out.x = u * t;
        out.y = v * t;
        out.z = t - xi;
    }

    public Point2Transform3_F32 copyConcurrent() {
        UniOmniPtoS_F32 c = new UniOmniPtoS_F32();
        c.distortion = new RadialTangential_F32(this.distortion);
        c.mirrorOffset = this.mirrorOffset;
        c.K_inv.setTo((FMatrixD1)this.K_inv);
        return c;
    }
}

