/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle.cameras;

import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import georegression.struct.point.Point2D_F64;
import org.ejml.FancyPrint;

public class BundlePinholeSimplified
implements BundleAdjustmentCamera {
    public double f;
    public double k1;
    public double k2;

    public BundlePinholeSimplified() {
    }

    public BundlePinholeSimplified(double f, double k1, double k2) {
        this.f = f;
        this.k1 = k1;
        this.k2 = k2;
    }

    @Override
    public void setIntrinsic(double[] parameters, int offset) {
        this.f = parameters[offset];
        this.k1 = parameters[offset + 1];
        this.k2 = parameters[offset + 2];
    }

    @Override
    public void getIntrinsic(double[] parameters, int offset) {
        parameters[offset] = this.f;
        parameters[offset + 1] = this.k1;
        parameters[offset + 2] = this.k2;
    }

    @Override
    public void project(double camX, double camY, double camZ, Point2D_F64 output) {
        double normX = camX / camZ;
        double normY = camY / camZ;
        double n2 = normX * normX + normY * normY;
        double r = 1.0 + (this.k1 + this.k2 * n2) * n2;
        output.x = this.f * r * normX;
        output.y = this.f * r * normY;
    }

    @Override
    public void jacobian(double X, double Y, double Z, double[] inputX, double[] inputY, boolean computeIntrinsic, double[] calibX, double[] calibY) {
        double normX = X / Z;
        double normY = Y / Z;
        double n2 = normX * normX + normY * normY;
        double n2_X = 2.0 * normX / Z;
        double n2_Y = 2.0 * normY / Z;
        double n2_Z = -2.0 * n2 / Z;
        double r = 1.0 + (this.k1 + this.k2 * n2) * n2;
        double kk = this.k1 + 2.0 * this.k2 * n2;
        double r_Z = n2_Z * kk;
        inputX[0] = this.f / Z * (r + 2.0 * normX * normX * kk);
        inputY[0] = this.f * normY * n2_X * kk;
        inputX[1] = this.f * normX * n2_Y * kk;
        inputY[1] = this.f / Z * (r + 2.0 * normY * normY * kk);
        inputX[2] = this.f * normX * (r_Z - r / Z);
        inputY[2] = this.f * normY * (r_Z - r / Z);
        if (!computeIntrinsic) {
            return;
        }
        calibX[0] = r * normX;
        calibY[0] = r * normY;
        calibX[1] = this.f * normX * n2;
        calibY[1] = this.f * normY * n2;
        calibX[2] = this.f * normX * n2 * n2;
        calibY[2] = this.f * normY * n2 * n2;
    }

    @Override
    public int getIntrinsicCount() {
        return 3;
    }

    public String toString() {
        FancyPrint fp = new FancyPrint();
        return "BundlePinholeSimplified{f=" + fp.s(this.f) + ", k1=" + fp.s(this.k1) + ", k2=" + fp.s(this.k2) + '}';
    }

    public void reset() {
        this.f = 0.0;
        this.k2 = 0.0;
        this.k1 = 0.0;
    }

    public void setTo(BundlePinholeSimplified c) {
        this.f = c.f;
        this.k1 = c.k1;
        this.k2 = c.k2;
    }

    public BundlePinholeSimplified copy() {
        return new BundlePinholeSimplified(this.f, this.k1, this.k2);
    }

    public boolean isIdentical(BundlePinholeSimplified c, double tol) {
        if (Math.abs(this.f - c.f) > tol) {
            return false;
        }
        if (Math.abs(this.k1 - c.k1) > tol) {
            return false;
        }
        return !(Math.abs(this.k2 - c.k2) > tol);
    }
}

