/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.calibration;

import boofcv.abst.geo.calibration.DetectMultiFiducialCalibration;
import boofcv.abst.geo.calibration.DetectSingleFiducialCalibration;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_F64;
import java.util.List;

public class MultiToSingleFiducialCalibration
implements DetectSingleFiducialCalibration {
    DetectMultiFiducialCalibration multi;
    int targetMarker = 0;
    private int detectedID;
    int width;
    int height;

    public MultiToSingleFiducialCalibration(DetectMultiFiducialCalibration alg) {
        this.multi = alg;
    }

    @Override
    public boolean process(GrayF32 input) {
        this.multi.process(input);
        this.width = input.width;
        this.height = input.height;
        this.detectedID = -1;
        for (int i = 0; i < this.multi.getDetectionCount(); ++i) {
            if (this.multi.getMarkerID(i) != this.targetMarker) continue;
            this.detectedID = i;
            break;
        }
        return this.detectedID != -1;
    }

    @Override
    public CalibrationObservation getDetectedPoints() {
        if (this.detectedID == -1) {
            return new CalibrationObservation(this.width, this.height);
        }
        return this.multi.getDetectedPoints(this.detectedID);
    }

    @Override
    public List<Point2D_F64> getLayout() {
        return this.multi.getLayout(this.targetMarker);
    }

    @Override
    public void setLensDistortion(LensDistortionNarrowFOV distortion, int width, int height) {
        this.multi.setLensDistortion(distortion, width, height);
    }

    public DetectMultiFiducialCalibration getMulti() {
        return this.multi;
    }

    public int getTargetMarker() {
        return this.targetMarker;
    }

    public void setTargetMarker(int targetMarker) {
        this.targetMarker = targetMarker;
    }
}

