/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import boofcv.abst.geo.TriangulateNViewsMetricH;
import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.distort.brown.RemoveBrownPtoN_F64;
import boofcv.alg.geo.DecomposeEssential;
import boofcv.alg.geo.DecomposeHomography;
import boofcv.alg.geo.DecomposeProjectiveToMetric;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.bundle.cameras.BundlePinhole;
import boofcv.alg.geo.bundle.cameras.BundlePinholeBrown;
import boofcv.alg.geo.bundle.cameras.BundlePinholeSimplified;
import boofcv.alg.geo.f.FundamentalExtractEpipoles;
import boofcv.alg.geo.f.FundamentalToProjective;
import boofcv.alg.geo.h.HomographyInducedStereo2Line;
import boofcv.alg.geo.h.HomographyInducedStereo3Pts;
import boofcv.alg.geo.h.HomographyInducedStereoLinePt;
import boofcv.alg.geo.impl.ProjectiveToIdentity;
import boofcv.alg.geo.structure.DecomposeAbsoluteDualQuadratic;
import boofcv.alg.geo.trifocal.TrifocalExtractGeometries;
import boofcv.alg.geo.trifocal.TrifocalTransfer;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.misc.BoofLambdas;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.AssociatedTriple;
import boofcv.struct.geo.AssociatedTuple;
import boofcv.struct.geo.PairLineNorm;
import boofcv.struct.geo.TrifocalTensor;
import georegression.geometry.GeometryMath_F64;
import georegression.geometry.UtilLine2D_F64;
import georegression.geometry.UtilPoint3D_F64;
import georegression.metric.Intersection2D_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.line.LineGeneral2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F64;
import org.ddogleg.struct.Tuple2;
import org.ddogleg.struct.Tuple3;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrix3;
import org.ejml.data.DMatrix3x3;
import org.ejml.data.DMatrix4x4;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.fixed.CommonOps_DDF4;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.NormOps_DDRM;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;
import org.jetbrains.annotations.Nullable;

public class MultiViewOps {
    public static TrifocalTensor createTrifocal(DMatrixRMaj P2, DMatrixRMaj P3, @Nullable TrifocalTensor ret) {
        if (ret == null) {
            ret = new TrifocalTensor();
        }
        for (int i = 0; i < 3; ++i) {
            DMatrixRMaj T = ret.getT(i);
            int index = 0;
            for (int j = 0; j < 3; ++j) {
                double a_left = P2.get(j, i);
                double a_right = P2.get(j, 3);
                for (int k = 0; k < 3; ++k) {
                    T.data[index++] = a_left * P3.get(k, 3) - a_right * P3.get(k, i);
                }
            }
        }
        return ret;
    }

    public static TrifocalTensor createTrifocal(DMatrixRMaj P1, DMatrixRMaj P2, DMatrixRMaj P3, @Nullable TrifocalTensor ret) {
        if (ret == null) {
            ret = new TrifocalTensor();
        }
        double scale = 1.0;
        scale = Math.max(scale, CommonOps_DDRM.elementMaxAbs((DMatrixD1)P1));
        scale = Math.max(scale, CommonOps_DDRM.elementMaxAbs((DMatrixD1)P2));
        scale = Math.max(scale, CommonOps_DDRM.elementMaxAbs((DMatrixD1)P3));
        DMatrixRMaj A = new DMatrixRMaj(4, 4);
        double sign = 1.0;
        for (int i = 0; i < 3; ++i) {
            DMatrixRMaj T = ret.getT(i);
            int cnt = 0;
            for (int row = 0; row < 3; ++row) {
                if (row == i) continue;
                CommonOps_DDRM.extract((DMatrix)P1, (int)row, (int)(row + 1), (int)0, (int)4, (DMatrix)A, (int)cnt, (int)0);
                for (int col = 0; col < 4; ++col) {
                    int n = cnt * 4 + col;
                    A.data[n] = A.data[n] / scale;
                }
                ++cnt;
            }
            for (int q = 0; q < 3; ++q) {
                CommonOps_DDRM.extract((DMatrix)P2, (int)q, (int)(q + 1), (int)0, (int)4, (DMatrix)A, (int)2, (int)0);
                for (int col = 0; col < 4; ++col) {
                    int n = 8 + col;
                    A.data[n] = A.data[n] / scale;
                }
                for (int r = 0; r < 3; ++r) {
                    CommonOps_DDRM.extract((DMatrix)P3, (int)r, (int)(r + 1), (int)0, (int)4, (DMatrix)A, (int)3, (int)0);
                    for (int col = 0; col < 4; ++col) {
                        int n = 12 + col;
                        A.data[n] = A.data[n] / scale;
                    }
                    double v = CommonOps_DDRM.det((DMatrixRMaj)A);
                    T.set(q, r, sign * v * scale);
                }
            }
            sign *= -1.0;
        }
        return ret;
    }

    public static TrifocalTensor createTrifocal(Se3_F64 P2, Se3_F64 P3, @Nullable TrifocalTensor ret) {
        if (ret == null) {
            ret = new TrifocalTensor();
        }
        DMatrixRMaj R2 = P2.getR();
        DMatrixRMaj R3 = P3.getR();
        Vector3D_F64 T2 = P2.getT();
        Vector3D_F64 T3 = P3.getT();
        for (int col = 0; col < 3; ++col) {
            DMatrixRMaj T = ret.getT(col);
            int index = 0;
            for (int i = 0; i < 3; ++i) {
                double a_left = R2.unsafe_get(i, col);
                double a_right = T2.getIdx(i);
                for (int j = 0; j < 3; ++j) {
                    T.data[index++] = a_left * T3.getIdx(j) - a_right * R3.unsafe_get(j, col);
                }
            }
        }
        return ret;
    }

    public static Vector3D_F64 constraint(TrifocalTensor tensor, Vector3D_F64 l1, Vector3D_F64 l2, Vector3D_F64 l3, @Nullable Vector3D_F64 ret) {
        if (ret == null) {
            ret = new Vector3D_F64();
        }
        double x = GeometryMath_F64.innerProd((GeoTuple3D_F64)l2, (DMatrixRMaj)tensor.T1, (GeoTuple3D_F64)l3);
        double y = GeometryMath_F64.innerProd((GeoTuple3D_F64)l2, (DMatrixRMaj)tensor.T2, (GeoTuple3D_F64)l3);
        double z = GeometryMath_F64.innerProd((GeoTuple3D_F64)l2, (DMatrixRMaj)tensor.T3, (GeoTuple3D_F64)l3);
        GeometryMath_F64.cross((GeoTuple3D_F64)new Vector3D_F64(x, y, z), (GeoTuple3D_F64)l1, (GeoTuple3D_F64)ret);
        return ret;
    }

    public static double constraint(TrifocalTensor tensor, Point2D_F64 p1, Vector3D_F64 l2, Vector3D_F64 l3) {
        DMatrixRMaj sum = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.add((double)p1.x, (DMatrixD1)tensor.T1, (DMatrixD1)sum, (DMatrixD1)sum);
        CommonOps_DDRM.add((double)p1.y, (DMatrixD1)tensor.T2, (DMatrixD1)sum, (DMatrixD1)sum);
        CommonOps_DDRM.add((DMatrixD1)tensor.T3, (DMatrixD1)sum, (DMatrixD1)sum);
        return GeometryMath_F64.innerProd((GeoTuple3D_F64)l2, (DMatrixRMaj)sum, (GeoTuple3D_F64)l3);
    }

    public static Vector3D_F64 constraint(TrifocalTensor tensor, Point2D_F64 p1, Vector3D_F64 l2, Point2D_F64 p3, Vector3D_F64 ret) {
        if (ret == null) {
            ret = new Vector3D_F64();
        }
        DMatrixRMaj sum = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.add((double)p1.x, (DMatrixD1)tensor.T1, (DMatrixD1)sum, (DMatrixD1)sum);
        CommonOps_DDRM.add((double)p1.y, (DMatrixD1)tensor.T2, (DMatrixD1)sum, (DMatrixD1)sum);
        CommonOps_DDRM.add((DMatrixD1)tensor.T3, (DMatrixD1)sum, (DMatrixD1)sum);
        Vector3D_F64 tempV = new Vector3D_F64();
        GeometryMath_F64.multTran((DMatrixRMaj)sum, (GeoTuple3D_F64)l2, (GeoTuple3D_F64)tempV);
        GeometryMath_F64.cross((GeoTuple3D_F64)tempV, (GeoTuple3D_F64)new Vector3D_F64(p3.x, p3.y, 1.0), (GeoTuple3D_F64)ret);
        return ret;
    }

    public static Vector3D_F64 constraint(TrifocalTensor tensor, Point2D_F64 p1, Point2D_F64 p2, Vector3D_F64 l3, Vector3D_F64 ret) {
        if (ret == null) {
            ret = new Vector3D_F64();
        }
        DMatrixRMaj sum = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.add((double)p1.x, (DMatrixD1)tensor.T1, (DMatrixD1)sum, (DMatrixD1)sum);
        CommonOps_DDRM.add((double)p1.y, (DMatrixD1)tensor.T2, (DMatrixD1)sum, (DMatrixD1)sum);
        CommonOps_DDRM.add((DMatrixD1)tensor.T3, (DMatrixD1)sum, (DMatrixD1)sum);
        DMatrixRMaj cross2 = GeometryMath_F64.crossMatrix((double)p2.x, (double)p2.y, (double)1.0, null);
        DMatrixRMaj temp = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.mult((DMatrix1Row)cross2, (DMatrix1Row)sum, (DMatrix1Row)temp);
        GeometryMath_F64.mult((DMatrixRMaj)temp, (GeoTuple3D_F64)l3, (GeoTuple3D_F64)ret);
        return ret;
    }

    public static DMatrixRMaj constraint(TrifocalTensor tensor, Point2D_F64 p1, Point2D_F64 p2, Point2D_F64 p3, DMatrixRMaj ret) {
        if (ret == null) {
            ret = new DMatrixRMaj(3, 3);
        }
        DMatrixRMaj sum = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.add((double)p1.x, (DMatrixD1)tensor.T1, (double)p1.y, (DMatrixD1)tensor.T2, (DMatrixD1)sum);
        CommonOps_DDRM.add((DMatrixD1)sum, (DMatrixD1)tensor.T3, (DMatrixD1)sum);
        DMatrixRMaj cross2 = GeometryMath_F64.crossMatrix((double)p2.x, (double)p2.y, (double)1.0, null);
        DMatrixRMaj cross3 = GeometryMath_F64.crossMatrix((double)p3.x, (double)p3.y, (double)1.0, null);
        DMatrixRMaj temp = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.mult((DMatrix1Row)cross2, (DMatrix1Row)sum, (DMatrix1Row)temp);
        CommonOps_DDRM.mult((DMatrix1Row)temp, (DMatrix1Row)cross3, (DMatrix1Row)ret);
        return ret;
    }

    public static double constraint(DMatrixRMaj F, Point2D_F64 p1, Point2D_F64 p2) {
        return GeometryMath_F64.innerProd((GeoTuple2D_F64)p2, (DMatrixRMaj)F, (GeoTuple2D_F64)p1);
    }

    public static Point2D_F64 constraintHomography(DMatrixRMaj H, Point2D_F64 p1, Point2D_F64 outputP2) {
        if (outputP2 == null) {
            outputP2 = new Point2D_F64();
        }
        GeometryMath_F64.mult((DMatrixRMaj)H, (GeoTuple2D_F64)p1, (GeoTuple2D_F64)outputP2);
        return outputP2;
    }

    public static DMatrixRMaj inducedHomography13(TrifocalTensor tensor, Vector3D_F64 line2, DMatrixRMaj output) {
        if (output == null) {
            output = new DMatrixRMaj(3, 3);
        }
        DMatrixRMaj T = tensor.T1;
        output.data[0] = T.data[0] * line2.x + T.data[3] * line2.y + T.data[6] * line2.z;
        output.data[3] = T.data[1] * line2.x + T.data[4] * line2.y + T.data[7] * line2.z;
        output.data[6] = T.data[2] * line2.x + T.data[5] * line2.y + T.data[8] * line2.z;
        T = tensor.T2;
        output.data[1] = T.data[0] * line2.x + T.data[3] * line2.y + T.data[6] * line2.z;
        output.data[4] = T.data[1] * line2.x + T.data[4] * line2.y + T.data[7] * line2.z;
        output.data[7] = T.data[2] * line2.x + T.data[5] * line2.y + T.data[8] * line2.z;
        T = tensor.T3;
        output.data[2] = T.data[0] * line2.x + T.data[3] * line2.y + T.data[6] * line2.z;
        output.data[5] = T.data[1] * line2.x + T.data[4] * line2.y + T.data[7] * line2.z;
        output.data[8] = T.data[2] * line2.x + T.data[5] * line2.y + T.data[8] * line2.z;
        return output;
    }

    public static DMatrixRMaj inducedHomography12(TrifocalTensor tensor, Vector3D_F64 line3, DMatrixRMaj output) {
        if (output == null) {
            output = new DMatrixRMaj(3, 3);
        }
        DMatrixRMaj T = tensor.T1;
        output.data[0] = T.data[0] * line3.x + T.data[1] * line3.y + T.data[2] * line3.z;
        output.data[3] = T.data[3] * line3.x + T.data[4] * line3.y + T.data[5] * line3.z;
        output.data[6] = T.data[6] * line3.x + T.data[7] * line3.y + T.data[8] * line3.z;
        T = tensor.T2;
        output.data[1] = T.data[0] * line3.x + T.data[1] * line3.y + T.data[2] * line3.z;
        output.data[4] = T.data[3] * line3.x + T.data[4] * line3.y + T.data[5] * line3.z;
        output.data[7] = T.data[6] * line3.x + T.data[7] * line3.y + T.data[8] * line3.z;
        T = tensor.T3;
        output.data[2] = T.data[0] * line3.x + T.data[1] * line3.y + T.data[2] * line3.z;
        output.data[5] = T.data[3] * line3.x + T.data[4] * line3.y + T.data[5] * line3.z;
        output.data[8] = T.data[6] * line3.x + T.data[7] * line3.y + T.data[8] * line3.z;
        return output;
    }

    public static DMatrixRMaj fundamentalToHomography3Pts(DMatrixRMaj F, AssociatedPair p1, AssociatedPair p2, AssociatedPair p3) {
        HomographyInducedStereo3Pts alg = new HomographyInducedStereo3Pts();
        alg.setFundamental(F, null);
        if (!alg.process(p1, p2, p3)) {
            return null;
        }
        return alg.getHomography();
    }

    public static DMatrixRMaj fundamentalToHomographyLinePt(DMatrixRMaj F, PairLineNorm line, AssociatedPair point) {
        HomographyInducedStereoLinePt alg = new HomographyInducedStereoLinePt();
        alg.setFundamental(F, null);
        alg.process(line, point);
        return alg.getHomography();
    }

    public static DMatrixRMaj fundamentalToHomography2Lines(DMatrixRMaj F, PairLineNorm line0, PairLineNorm line1) {
        HomographyInducedStereo2Line alg = new HomographyInducedStereo2Line();
        alg.setFundamental(F, null);
        if (!alg.process(line0, line1)) {
            return null;
        }
        return alg.getHomography();
    }

    public static void extractEpipoles(TrifocalTensor tensor, Point3D_F64 e2, Point3D_F64 e3) {
        TrifocalExtractGeometries e = new TrifocalExtractGeometries();
        e.setTensor(tensor);
        e.extractEpipoles(e2, e3);
    }

    public static void trifocalToFundamental(TrifocalTensor tensor, DMatrixRMaj F21, DMatrixRMaj F31) {
        TrifocalExtractGeometries e = new TrifocalExtractGeometries();
        e.setTensor(tensor);
        e.extractFundmental(F21, F31);
    }

    public static void trifocalToCameraMatrices(TrifocalTensor tensor, DMatrixRMaj P2, DMatrixRMaj P3) {
        TrifocalExtractGeometries e = new TrifocalExtractGeometries();
        e.setTensor(tensor);
        e.extractCamera(P2, P3);
    }

    public static DMatrixRMaj createEssential(DMatrixRMaj R, Vector3D_F64 T, @Nullable DMatrixRMaj E) {
        if (E == null) {
            E = new DMatrixRMaj(3, 3);
        }
        DMatrixRMaj T_hat = GeometryMath_F64.crossMatrix((GeoTuple3D_F64)T, null);
        CommonOps_DDRM.mult((DMatrix1Row)T_hat, (DMatrix1Row)R, (DMatrix1Row)E);
        return E;
    }

    public static DMatrixRMaj createFundamental(DMatrixRMaj E, DMatrixRMaj K) {
        DMatrixRMaj K_inv = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.invert((DMatrixRMaj)K, (DMatrixRMaj)K_inv);
        DMatrixRMaj F = new DMatrixRMaj(3, 3);
        PerspectiveOps.multTranA(K_inv, E, K_inv, F);
        return F;
    }

    public static DMatrixRMaj createFundamental(DMatrixRMaj E, CameraPinhole intrinsic) {
        DMatrixRMaj K = PerspectiveOps.pinholeToMatrix(intrinsic, (DMatrixRMaj)null);
        return MultiViewOps.createFundamental(E, K);
    }

    public static DMatrixRMaj createFundamental(DMatrixRMaj E, DMatrixRMaj K1, DMatrixRMaj K2) {
        DMatrixRMaj K1_inv = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.invert((DMatrixRMaj)K1, (DMatrixRMaj)K1_inv);
        DMatrixRMaj K2_inv = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.invert((DMatrixRMaj)K2, (DMatrixRMaj)K2_inv);
        DMatrixRMaj F = new DMatrixRMaj(3, 3);
        DMatrixRMaj temp = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.multTransA((DMatrix1Row)K2_inv, (DMatrix1Row)E, (DMatrix1Row)temp);
        CommonOps_DDRM.mult((DMatrix1Row)temp, (DMatrix1Row)K1_inv, (DMatrix1Row)F);
        return F;
    }

    public static DMatrixRMaj createFundamental(DMatrixRMaj R, Vector3D_F64 T, DMatrixRMaj K1, DMatrixRMaj K2, @Nullable DMatrixRMaj F) {
        if (F == null) {
            F = new DMatrixRMaj(3, 3);
        } else {
            F.reshape(3, 3);
        }
        MultiViewOps.createEssential(R, T, F);
        F.setTo((DMatrixD1)MultiViewOps.createFundamental(F, K1, K2));
        return F;
    }

    public static DMatrixRMaj createHomography(DMatrixRMaj R, Vector3D_F64 T, double d, Vector3D_F64 N) {
        DMatrixRMaj H = new DMatrixRMaj(3, 3);
        GeometryMath_F64.outerProd((GeoTuple3D_F64)T, (GeoTuple3D_F64)N, (DMatrixRMaj)H);
        CommonOps_DDRM.divide((DMatrixD1)H, (double)d);
        CommonOps_DDRM.addEquals((DMatrixD1)H, (DMatrixD1)R);
        return H;
    }

    public static DMatrixRMaj createHomography(DMatrixRMaj R, Vector3D_F64 T, double d, Vector3D_F64 N, DMatrixRMaj K) {
        DMatrixRMaj temp = new DMatrixRMaj(3, 3);
        DMatrixRMaj K_inv = new DMatrixRMaj(3, 3);
        DMatrixRMaj H = MultiViewOps.createHomography(R, T, d, N);
        CommonOps_DDRM.mult((DMatrix1Row)K, (DMatrix1Row)H, (DMatrix1Row)temp);
        CommonOps_DDRM.invert((DMatrixRMaj)K, (DMatrixRMaj)K_inv);
        CommonOps_DDRM.mult((DMatrix1Row)temp, (DMatrix1Row)K_inv, (DMatrix1Row)H);
        return H;
    }

    public static void extractEpipoles(DMatrixRMaj F, Point3D_F64 e1, Point3D_F64 e2) {
        FundamentalExtractEpipoles alg = new FundamentalExtractEpipoles();
        alg.process(F, e1, e2);
    }

    public static DMatrixRMaj fundamentalToProjective(DMatrixRMaj F, Point3D_F64 e2, Vector3D_F64 v, double lambda) {
        FundamentalToProjective f2p = new FundamentalToProjective();
        DMatrixRMaj P = new DMatrixRMaj(3, 4);
        f2p.twoView(F, e2, v, lambda, P);
        return P;
    }

    public static DMatrixRMaj projectiveToFundamental(DMatrixRMaj P1, DMatrixRMaj P2, @Nullable DMatrixRMaj F21) {
        ProjectiveToIdentity p2i;
        if (F21 == null) {
            F21 = new DMatrixRMaj(3, 3);
        }
        if (!(p2i = new ProjectiveToIdentity()).process(P1)) {
            throw new RuntimeException("Failed!");
        }
        DMatrixRMaj P1inv = p2i.getPseudoInvP();
        DMatrixRMaj U = p2i.getU();
        DMatrixRMaj e = new DMatrixRMaj(3, 1);
        CommonOps_DDRM.mult((DMatrix1Row)P2, (DMatrix1Row)U, (DMatrix1Row)e);
        DMatrixRMaj tmp = new DMatrixRMaj(3, 4);
        DMatrixRMaj e_skew = new DMatrixRMaj(3, 3);
        GeometryMath_F64.crossMatrix((double)e.data[0], (double)e.data[1], (double)e.data[2], (DMatrixRMaj)e_skew);
        CommonOps_DDRM.mult((DMatrix1Row)e_skew, (DMatrix1Row)P2, (DMatrix1Row)tmp);
        CommonOps_DDRM.mult((DMatrix1Row)tmp, (DMatrix1Row)P1inv, (DMatrix1Row)F21);
        return F21;
    }

    public static DMatrixRMaj projectiveToFundamental(DMatrixRMaj P2, @Nullable DMatrixRMaj F21) {
        if (F21 == null) {
            F21 = new DMatrixRMaj(3, 3);
        }
        double b1 = P2.unsafe_get(0, 3);
        double b2 = P2.unsafe_get(1, 3);
        double b3 = P2.unsafe_get(2, 3);
        double a11 = P2.data[0];
        double a12 = P2.data[1];
        double a13 = P2.data[2];
        double a21 = P2.data[4];
        double a22 = P2.data[5];
        double a23 = P2.data[6];
        double a31 = P2.data[8];
        double a32 = P2.data[9];
        double a33 = P2.data[10];
        F21.data[0] = -b3 * a21 + b2 * a31;
        F21.data[1] = -b3 * a22 + b2 * a32;
        F21.data[2] = -b3 * a23 + b2 * a33;
        F21.data[3] = b3 * a11 - b1 * a31;
        F21.data[4] = b3 * a12 - b1 * a32;
        F21.data[5] = b3 * a13 - b1 * a33;
        F21.data[6] = -b2 * a11 + b1 * a21;
        F21.data[7] = -b2 * a12 + b1 * a22;
        F21.data[8] = -b2 * a13 + b1 * a23;
        return F21;
    }

    public static DMatrixRMaj fundamentalToProjective(DMatrixRMaj F) {
        FundamentalToProjective f2p = new FundamentalToProjective();
        DMatrixRMaj P = new DMatrixRMaj(3, 4);
        f2p.twoView(F, P);
        return P;
    }

    public static DMatrixRMaj fundamentalToEssential(DMatrixRMaj F, DMatrixRMaj K, @Nullable DMatrixRMaj outputE) {
        return MultiViewOps.fundamentalToEssential(F, K, K, outputE);
    }

    public static DMatrixRMaj fundamentalToEssential(DMatrixRMaj F, DMatrixRMaj K1, DMatrixRMaj K2, @Nullable DMatrixRMaj outputE) {
        if (outputE == null) {
            outputE = new DMatrixRMaj(3, 3);
        }
        PerspectiveOps.multTranA(K2, F, K1, outputE);
        SingularValueDecomposition_F64 svd = DecompositionFactory_DDRM.svd((boolean)true, (boolean)true, (boolean)false);
        svd.decompose((Matrix)outputE);
        DMatrixRMaj U = (DMatrixRMaj)svd.getU(null, false);
        DMatrixRMaj W = (DMatrixRMaj)svd.getW(null);
        DMatrixRMaj V = (DMatrixRMaj)svd.getV(null, false);
        SingularOps_DDRM.descendingOrder((DMatrixRMaj)U, (boolean)false, (DMatrixRMaj)W, (DMatrixRMaj)V, (boolean)false);
        W.set(0, 0, 1.0);
        W.set(1, 1, 1.0);
        W.set(2, 2, 0.0);
        PerspectiveOps.multTranC(U, W, V, outputE);
        return outputE;
    }

    public static void fundamentalToProjective(DMatrixRMaj F21, DMatrixRMaj F31, DMatrixRMaj F32, DMatrixRMaj P2, DMatrixRMaj P3) {
        FundamentalToProjective alg = new FundamentalToProjective();
        alg.threeView(F21, F31, F32, P2, P3);
    }

    public static DMatrixRMaj projectiveToIdentityH(DMatrixRMaj P, @Nullable DMatrixRMaj H) {
        ProjectiveToIdentity alg;
        if (H == null) {
            H = new DMatrixRMaj(4, 4);
        }
        if (!(alg = new ProjectiveToIdentity()).process(P)) {
            throw new RuntimeException("WTF this failed?? Probably NaN in P");
        }
        alg.computeH(H);
        return H;
    }

    public static void projectiveMakeFirstIdentity(List<DMatrixRMaj> cameraMatrices, @Nullable DMatrixRMaj H) {
        BoofMiscOps.checkTrue((cameraMatrices.size() >= 1 ? 1 : 0) != 0);
        H = MultiViewOps.projectiveToIdentityH(cameraMatrices.get(0), H);
        DMatrixRMaj tmp = new DMatrixRMaj(3, 4);
        for (int i = 0; i < cameraMatrices.size(); ++i) {
            DMatrixRMaj P = cameraMatrices.get(i);
            CommonOps_DDRM.mult((DMatrix1Row)P, (DMatrix1Row)H, (DMatrix1Row)tmp);
            P.setTo((DMatrixD1)tmp);
        }
    }

    public static boolean fundamentalCompatible3(DMatrixRMaj F21, DMatrixRMaj F31, DMatrixRMaj F32, double tol) {
        FundamentalExtractEpipoles extractEpi = new FundamentalExtractEpipoles();
        Point3D_F64 e21 = new Point3D_F64();
        Point3D_F64 e12 = new Point3D_F64();
        Point3D_F64 e31 = new Point3D_F64();
        Point3D_F64 e13 = new Point3D_F64();
        Point3D_F64 e32 = new Point3D_F64();
        Point3D_F64 e23 = new Point3D_F64();
        extractEpi.process(F21, e21, e12);
        extractEpi.process(F31, e31, e13);
        extractEpi.process(F32, e32, e23);
        double score = 0.0;
        score += Math.abs(GeometryMath_F64.innerProd((GeoTuple3D_F64)e23, (DMatrixRMaj)F21, (GeoTuple3D_F64)e13));
        score += Math.abs(GeometryMath_F64.innerProd((GeoTuple3D_F64)e31, (DMatrixRMaj)F31, (GeoTuple3D_F64)e21));
        score += Math.abs(GeometryMath_F64.innerProd((GeoTuple3D_F64)e32, (DMatrixRMaj)F32, (GeoTuple3D_F64)e12));
        return (score /= 3.0) <= tol;
    }

    public static boolean decomposeMetricCamera(DMatrixRMaj cameraMatrix, DMatrixRMaj K, Se3_F64 worldToView) {
        return new DecomposeProjectiveToMetric().decomposeMetricCamera(cameraMatrix, K, worldToView);
    }

    public static List<Se3_F64> decomposeEssential(DMatrixRMaj E21) {
        DecomposeEssential d = new DecomposeEssential();
        d.decompose(E21);
        return d.getSolutions();
    }

    public static List<Tuple2<Se3_F64, Vector3D_F64>> decomposeHomography(DMatrixRMaj H) {
        DecomposeHomography d = new DecomposeHomography();
        d.decompose(H);
        List<Vector3D_F64> solutionsN = d.getSolutionsN();
        List<Se3_F64> solutionsSe = d.getSolutionsSE();
        ArrayList<Tuple2<Se3_F64, Vector3D_F64>> ret = new ArrayList<Tuple2<Se3_F64, Vector3D_F64>>();
        for (int i = 0; i < 4; ++i) {
            ret.add((Tuple2<Se3_F64, Vector3D_F64>)new Tuple2((Object)solutionsSe.get(i), (Object)solutionsN.get(i)));
        }
        return ret;
    }

    public static void errorsHomographySymm(List<AssociatedPair> observations, DMatrixRMaj H, @Nullable DMatrixRMaj H_inv, DogArray_F64 storage) {
        storage.reset();
        if (H_inv == null) {
            H_inv = new DMatrixRMaj(3, 3);
        }
        CommonOps_DDRM.invert((DMatrixRMaj)H, (DMatrixRMaj)H_inv);
        Point3D_F64 tmp = new Point3D_F64();
        for (int i = 0; i < observations.size(); ++i) {
            AssociatedPair p = observations.get(i);
            double error = 0.0;
            GeometryMath_F64.mult((DMatrixRMaj)H, (GeoTuple2D_F64)p.p1, (GeoTuple3D_F64)tmp);
            if (Math.abs(tmp.z) <= UtilEjml.EPS) continue;
            double dx = p.p2.x - tmp.x / tmp.z;
            double dy = p.p2.y - tmp.y / tmp.z;
            error += dx * dx + dy * dy;
            GeometryMath_F64.mult((DMatrixRMaj)H_inv, (GeoTuple2D_F64)p.p2, (GeoTuple3D_F64)tmp);
            if (Math.abs(tmp.z) <= UtilEjml.EPS) continue;
            dx = p.p1.x - tmp.x / tmp.z;
            dy = p.p1.y - tmp.y / tmp.z;
            storage.add(error += dx * dx + dy * dy);
        }
    }

    public static Point3D_F64 transfer_1_to_3(TrifocalTensor T, Point2D_F64 x1, Vector3D_F64 l2, @Nullable Point3D_F64 x3) {
        if (x3 == null) {
            x3 = new Point3D_F64();
        }
        GeometryMath_F64.multTran((DMatrixRMaj)T.T1, (GeoTuple3D_F64)l2, (GeoTuple3D_F64)x3);
        double xx = x3.x * x1.x;
        double yy = x3.y * x1.x;
        double zz = x3.z * x1.x;
        GeometryMath_F64.multTran((DMatrixRMaj)T.T2, (GeoTuple3D_F64)l2, (GeoTuple3D_F64)x3);
        GeometryMath_F64.multTran((DMatrixRMaj)T.T3, (GeoTuple3D_F64)l2, (GeoTuple3D_F64)x3);
        x3.x = (xx += x3.x * x1.y) + x3.x;
        x3.y = (yy += x3.y * x1.y) + x3.y;
        x3.z = (zz += x3.z * x1.y) + x3.z;
        return x3;
    }

    public static Point3D_F64 transfer_1_to_3(TrifocalTensor T, Point2D_F64 x1, Point2D_F64 x2, @Nullable Point3D_F64 x3) {
        if (x3 == null) {
            x3 = new Point3D_F64();
        }
        TrifocalTransfer transfer = new TrifocalTransfer();
        transfer.setTrifocal(T);
        transfer.transfer_1_to_3(x1.x, x1.y, x2.x, x2.y, x3);
        return x3;
    }

    public static Point3D_F64 transfer_1_to_2(TrifocalTensor T, Point2D_F64 x1, Vector3D_F64 l3, @Nullable Point3D_F64 x2) {
        if (x2 == null) {
            x2 = new Point3D_F64();
        }
        GeometryMath_F64.mult((DMatrixRMaj)T.T1, (GeoTuple3D_F64)l3, (GeoTuple3D_F64)x2);
        double xx = x2.x * x1.x;
        double yy = x2.y * x1.x;
        double zz = x2.z * x1.x;
        GeometryMath_F64.mult((DMatrixRMaj)T.T2, (GeoTuple3D_F64)l3, (GeoTuple3D_F64)x2);
        GeometryMath_F64.mult((DMatrixRMaj)T.T3, (GeoTuple3D_F64)l3, (GeoTuple3D_F64)x2);
        x2.x = (xx += x2.x * x1.y) + x2.x;
        x2.y = (yy += x2.y * x1.y) + x2.y;
        x2.z = (zz += x2.z * x1.y) + x2.z;
        return x2;
    }

    public static Point3D_F64 transfer_1_to_2(TrifocalTensor T, Point2D_F64 x1, Point2D_F64 x3, @Nullable Point3D_F64 x2) {
        if (x2 == null) {
            x2 = new Point3D_F64();
        }
        TrifocalTransfer transfer = new TrifocalTransfer();
        transfer.setTrifocal(T);
        transfer.transfer_1_to_2(x1.x, x1.y, x3.x, x3.y, x2);
        return x2;
    }

    public static boolean projectiveToMetric(DMatrixRMaj cameraMatrix, DMatrixRMaj H, Se3_F64 worldToView, DMatrixRMaj K) {
        return new DecomposeProjectiveToMetric().projectiveToMetric(cameraMatrix, H, worldToView, K);
    }

    public static boolean projectiveToMetricKnownK(DMatrixRMaj cameraMatrix, DMatrixRMaj H, DMatrixRMaj K, Se3_F64 worldToView) {
        return new DecomposeProjectiveToMetric().projectiveToMetricKnownK(cameraMatrix, H, K, worldToView);
    }

    public static boolean enforceAbsoluteQuadraticConstraints(DMatrix4x4 Q, boolean zeroCenter, boolean zeroSkew) {
        return MultiViewOps.enforceAbsoluteQuadraticConstraints(Q, zeroCenter, zeroSkew, null);
    }

    public static boolean enforceAbsoluteQuadraticConstraints(DMatrix4x4 Q, boolean zeroCenter, boolean zeroSkew, @Nullable DecomposeAbsoluteDualQuadratic alg) {
        if (alg == null) {
            alg = new DecomposeAbsoluteDualQuadratic();
        }
        if (Q.a33 < 0.0) {
            CommonOps_DDF4.scale((double)-1.0, (DMatrix4x4)Q);
        }
        if (!alg.decompose(Q)) {
            return false;
        }
        DMatrix3x3 k = alg.getK();
        if (zeroCenter) {
            k.a23 = 0.0;
            k.a13 = 0.0;
        }
        if (zeroSkew) {
            k.a12 = 0.0;
        }
        alg.recomputeQ(Q);
        return true;
    }

    public static boolean absoluteQuadraticToH(DMatrix4x4 Q, DMatrixRMaj H) {
        DecomposeAbsoluteDualQuadratic alg = new DecomposeAbsoluteDualQuadratic();
        if (!alg.decompose(Q)) {
            return false;
        }
        return alg.computeRectifyingHomography(H);
    }

    public static void rectifyHToAbsoluteQuadratic(DMatrixRMaj H, DMatrixRMaj Q) {
        int indexQ = 0;
        for (int rowA = 0; rowA < 4; ++rowA) {
            for (int colB = 0; colB < 4; ++colB) {
                int indexA = rowA * 4;
                int indexB = colB * 4;
                double sum = 0.0;
                for (int i = 0; i < 3; ++i) {
                    sum += H.data[indexA++] * H.data[indexB++];
                }
                Q.data[indexQ++] = sum;
            }
        }
    }

    public static void canonicalRectifyingHomographyFromKPinf(DMatrixRMaj K, Point3D_F64 planeAtInfinity, DMatrixRMaj H) {
        H.reshape(4, 4);
        CommonOps_DDRM.insert((DMatrix)K, (DMatrix)H, (int)0, (int)0);
        double v1 = -(planeAtInfinity.x * K.data[0] + planeAtInfinity.y * K.data[3] + planeAtInfinity.z * K.data[6]);
        double v2 = -(planeAtInfinity.x * K.data[1] + planeAtInfinity.y * K.data[4] + planeAtInfinity.z * K.data[7]);
        double v3 = -(planeAtInfinity.x * K.data[2] + planeAtInfinity.y * K.data[5] + planeAtInfinity.z * K.data[8]);
        H.unsafe_set(3, 0, v1);
        H.unsafe_set(3, 1, v2);
        H.unsafe_set(3, 2, v3);
        H.unsafe_set(3, 3, 1.0);
        H.unsafe_set(0, 3, 0.0);
        H.unsafe_set(1, 3, 0.0);
        H.unsafe_set(2, 3, 0.0);
    }

    public static void intrinsicFromAbsoluteQuadratic(DMatrixRMaj Q, DMatrixRMaj P, CameraPinhole intrinsic) {
        DMatrixRMaj tmp = new DMatrixRMaj(3, 4);
        DMatrixRMaj tmp2 = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.mult((DMatrix1Row)P, (DMatrix1Row)Q, (DMatrix1Row)tmp);
        CommonOps_DDRM.multTransB((DMatrix1Row)tmp, (DMatrix1Row)P, (DMatrix1Row)tmp2);
        MultiViewOps.decomposeDiac(tmp2, intrinsic);
    }

    public static void decomposeDiac(double w11, double w12, double w13, double w22, double w23, double w33, CameraPinhole intrinsic) {
        double cx = w13 / w33;
        double cy = w23 / w33;
        double fy = Math.sqrt(Math.abs(w22 / w33 - cy * cy));
        double skew = (w12 / w33 - cx * cy) / fy;
        double fx = Math.sqrt(Math.abs(w11 / w33 - skew * skew - cx * cx));
        intrinsic.cx = cx;
        intrinsic.cy = cy;
        intrinsic.fx = fx;
        intrinsic.fy = fy;
        intrinsic.skew = skew;
    }

    public static void decomposeDiac(DMatrixRMaj w, CameraPinhole intrinsic) {
        MultiViewOps.decomposeDiac(w.data[0], w.data[1], w.data[2], w.data[4], w.data[5], w.data[8], intrinsic);
    }

    public static DMatrixRMaj createProjectiveToMetric(DMatrixRMaj K, double v1, double v2, double v3, double lambda, @Nullable DMatrixRMaj H) {
        if (H == null) {
            H = new DMatrixRMaj(4, 4);
        } else {
            H.reshape(4, 4);
        }
        CommonOps_DDRM.insert((DMatrix)K, (DMatrix)H, (int)0, (int)0);
        H.set(0, 3, 0.0);
        H.set(1, 3, 0.0);
        H.set(2, 3, 0.0);
        H.set(3, 0, v1);
        H.set(3, 1, v2);
        H.set(3, 2, v3);
        H.set(3, 3, lambda);
        return H;
    }

    public static boolean decomposeAbsDualQuadratic(DMatrix4x4 Q, DMatrix3x3 w, DMatrix3 p) {
        DecomposeAbsoluteDualQuadratic alg = new DecomposeAbsoluteDualQuadratic();
        if (!alg.decompose(Q)) {
            return false;
        }
        w.setTo((Matrix)alg.getW());
        p.setTo((Matrix)alg.getP());
        return true;
    }

    public static Tuple2<List<Point2D_F64>, List<Point2D_F64>> split2(List<AssociatedPair> input) {
        ArrayList<Point2D_F64> list1 = new ArrayList<Point2D_F64>();
        ArrayList<Point2D_F64> list2 = new ArrayList<Point2D_F64>();
        for (int i = 0; i < input.size(); ++i) {
            list1.add(input.get((int)i).p1);
            list2.add(input.get((int)i).p2);
        }
        return new Tuple2(list1, list2);
    }

    public static Tuple3<List<Point2D_F64>, List<Point2D_F64>, List<Point2D_F64>> split3(List<AssociatedTriple> input) {
        ArrayList<Point2D_F64> list1 = new ArrayList<Point2D_F64>();
        ArrayList<Point2D_F64> list2 = new ArrayList<Point2D_F64>();
        ArrayList<Point2D_F64> list3 = new ArrayList<Point2D_F64>();
        for (int i = 0; i < input.size(); ++i) {
            list1.add(input.get((int)i).p1);
            list2.add(input.get((int)i).p2);
            list3.add(input.get((int)i).p3);
        }
        return new Tuple3(list1, list2, list3);
    }

    public static void triangulatePoints(SceneStructureMetric structure, SceneObservations observations) {
        TriangulateNViewsMetricH triangulator = FactoryMultiView.triangulateNViewMetricH(ConfigTriangulation.GEOMETRIC());
        ArrayList<RemoveBrownPtoN_F64> list_p_to_n = new ArrayList<RemoveBrownPtoN_F64>();
        for (int i = 0; i < structure.cameras.size; ++i) {
            BundleAdjustmentCamera cam;
            RemoveBrownPtoN_F64 p2n = new RemoveBrownPtoN_F64();
            BundleAdjustmentCamera baseModel = Objects.requireNonNull(((SceneStructureCommon.Camera[])structure.cameras.data)[i].model);
            if (baseModel instanceof BundlePinholeSimplified) {
                cam = (BundlePinholeSimplified)baseModel;
                p2n.setK(cam.f, cam.f, 0.0, 0.0, 0.0).setDistortion(new double[]{cam.k1, cam.k2}, 0.0, 0.0);
            } else if (baseModel instanceof BundlePinhole) {
                cam = (BundlePinhole)baseModel;
                p2n.setK(((BundlePinhole)cam).fx, ((BundlePinhole)cam).fy, ((BundlePinhole)cam).skew, ((BundlePinhole)cam).cx, ((BundlePinhole)cam).cy).setDistortion(new double[]{0.0, 0.0}, 0.0, 0.0);
            } else if (baseModel instanceof BundlePinholeBrown) {
                cam = (BundlePinholeBrown)baseModel;
                p2n.setK(((BundlePinholeBrown)cam).fx, ((BundlePinholeBrown)cam).fy, ((BundlePinholeBrown)cam).skew, ((BundlePinholeBrown)cam).cx, ((BundlePinholeBrown)cam).cy).setDistortion(((BundlePinholeBrown)cam).radial, ((BundlePinholeBrown)cam).t1, ((BundlePinholeBrown)cam).t2);
            } else {
                throw new RuntimeException("Unknown camera model!");
            }
            list_p_to_n.add(p2n);
        }
        DogArray normObs = new DogArray(Point2D_F64::new);
        normObs.resize(3);
        boolean homogenous = structure.isHomogenous();
        Point4D_F64 X = new Point4D_F64();
        ArrayList<Se3_F64> worldToViews = new ArrayList<Se3_F64>();
        for (int i = 0; i < structure.points.size; ++i) {
            normObs.reset();
            worldToViews.clear();
            SceneStructureCommon.Point sp = (SceneStructureCommon.Point)structure.points.get(i);
            for (int j = 0; j < sp.views.size; ++j) {
                int viewIdx = sp.views.get(j);
                SceneStructureMetric.View v = ((SceneStructureMetric.View[])structure.views.data)[viewIdx];
                worldToViews.add(structure.getParentToView(v));
                Point2D_F64 n = (Point2D_F64)normObs.grow();
                int pointidx = ((SceneObservations.View)observations.views.get((int)viewIdx)).point.indexOf(i);
                ((SceneObservations.View)observations.views.get(viewIdx)).getPixel(pointidx, n);
                ((RemoveBrownPtoN_F64)list_p_to_n.get(v.camera)).compute(n.x, n.y, n);
            }
            if (!triangulator.triangulate(normObs.toList(), worldToViews, X)) {
                throw new RuntimeException("Triangulation failed. Bad input?");
            }
            if (homogenous) {
                sp.set(X.x, X.y, X.z, X.w);
                continue;
            }
            sp.set(X.x / X.w, X.y / X.w, X.z / X.w);
        }
    }

    public static double findScale(DMatrixRMaj a, DMatrixRMaj b) {
        BoofMiscOps.checkTrue((a.numRows == b.numRows ? 1 : 0) != 0);
        BoofMiscOps.checkTrue((a.numCols == b.numCols ? 1 : 0) != 0);
        int N = a.getNumElements();
        double sum = 0.0;
        double weights = 0.0;
        for (int i = 0; i < N; ++i) {
            double valA = a.data[i];
            double valB = b.data[i];
            if (valA == 0.0) continue;
            double weight = Math.abs(valB);
            sum += weight * (valB / valA);
            weights += weight;
        }
        return sum / weights;
    }

    public static double findScale(GeoTuple3D_F64<?> a, GeoTuple3D_F64<?> b) {
        int which = UtilPoint3D_F64.axisLargestAbs(a);
        double bottom = a.getIdx(which);
        if (bottom == 0.0) {
            return 0.0;
        }
        return b.getIdx(which) / bottom;
    }

    public static List<List<Point2D_F64>> splits3Lists(List<AssociatedTriple> src, @Nullable List<List<Point2D_F64>> dst) {
        int i;
        if (dst == null) {
            dst = new ArrayList<List<Point2D_F64>>();
        }
        if (dst.size() != 3) {
            dst.clear();
            for (i = 0; i < 3; ++i) {
                dst.add(new ArrayList());
            }
        } else {
            for (i = 0; i < 3; ++i) {
                dst.get(i).clear();
            }
        }
        for (i = 0; i < src.size(); ++i) {
            AssociatedTriple a = src.get(i);
            dst.get(0).add(a.p1);
            dst.get(1).add(a.p2);
            dst.get(2).add(a.p3);
        }
        return dst;
    }

    public static void convertTr(List<AssociatedTriple> src, DogArray<AssociatedTuple> dst) {
        dst.resize(src.size());
        if (src.size() == 0) {
            return;
        }
        BoofMiscOps.checkTrue((((AssociatedTuple)dst.get(0)).size() == 3 ? 1 : 0) != 0);
        for (int i = 0; i < src.size(); ++i) {
            AssociatedTriple a = src.get(i);
            AssociatedTuple b = (AssociatedTuple)dst.get(i);
            b.set(0, a.p1);
            b.set(1, a.p2);
            b.set(2, a.p3);
        }
    }

    public static void convertTr(List<AssociatedTriple> src, int idx0, int idx1, DogArray<AssociatedPair> dst) {
        dst.resize(src.size());
        if (src.size() == 0) {
            return;
        }
        for (int i = 0; i < src.size(); ++i) {
            AssociatedTriple a = src.get(i);
            ((AssociatedPair)dst.get(i)).setTo(a.get(idx0), a.get(idx1));
        }
    }

    public static void convertTu(List<AssociatedTuple> src, int idx0, int idx1, DogArray<AssociatedPair> dst) {
        dst.resize(src.size());
        if (src.size() == 0) {
            return;
        }
        BoofMiscOps.checkTrue((src.get(0).size() == 3 ? 1 : 0) != 0);
        for (int i = 0; i < src.size(); ++i) {
            AssociatedTuple a = src.get(i);
            ((AssociatedPair)dst.get(i)).setTo(a.get(idx0), a.get(idx1));
        }
    }

    public static double disparityToRange(double disparity, double focalLength, double baseline) {
        if (disparity == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (disparity < 0.0) {
            throw new IllegalArgumentException("Disparity can't be less than zero");
        }
        return focalLength * baseline / disparity;
    }

    public static void scenePointsToPixels(SceneStructureMetric scene, int viewIdx, BoofLambdas.ProcessIndex2<Point3D_F64, Point2D_F64> function) {
        Se3_F64 world_to_view = new Se3_F64();
        SceneStructureMetric.View view = (SceneStructureMetric.View)scene.views.get(viewIdx);
        scene.getWorldToView(view, world_to_view, null);
        BundleAdjustmentCamera camera = Objects.requireNonNull(scene.getViewCamera((SceneStructureMetric.View)view).model);
        Point3D_F64 camPoint = new Point3D_F64();
        Point2D_F64 pixel = new Point2D_F64();
        for (int pointIdx = 0; pointIdx < scene.points.size; ++pointIdx) {
            SceneStructureCommon.Point point = (SceneStructureCommon.Point)scene.points.get(pointIdx);
            double x = point.coordinate[0];
            double y = point.coordinate[1];
            double z = point.coordinate[2];
            double w = scene.isHomogenous() ? point.coordinate[3] : 1.0;
            SePointOps_F64.transformV((Se3_F64)world_to_view, (double)x, (double)y, (double)z, (double)w, (Point3D_F64)camPoint);
            camera.project(camPoint.x, camPoint.y, camPoint.z, pixel);
            function.process(pointIdx, (Object)camPoint, (Object)pixel);
        }
    }

    public static void sceneToCloud3(SceneStructureMetric scene, double tol, BoofLambdas.ProcessIndex<Point3D_F64> func) {
        Point3D_F64 out = new Point3D_F64();
        boolean homogenous = scene.isHomogenous();
        for (int pointIdx = 0; pointIdx < scene.points.size; ++pointIdx) {
            SceneStructureCommon.Point point = (SceneStructureCommon.Point)scene.points.get(pointIdx);
            double x = point.coordinate[0];
            double y = point.coordinate[1];
            double z = point.coordinate[2];
            if (homogenous) {
                double w;
                double r = Math.sqrt(x * x + y * y + z * z);
                if (r * tol > Math.abs(w = point.coordinate[3])) continue;
                x /= w;
                y /= w;
                z /= w;
            }
            out.setTo(x, y, z);
            func.process(pointIdx, (Object)out);
        }
    }

    public static void sceneToCloudH(SceneStructureMetric scene, BoofLambdas.ProcessIndex<Point4D_F64> func) {
        Point4D_F64 out = new Point4D_F64();
        boolean homogenous = scene.isHomogenous();
        for (int pointIdx = 0; pointIdx < scene.points.size; ++pointIdx) {
            SceneStructureCommon.Point point = (SceneStructureCommon.Point)scene.points.get(pointIdx);
            double x = point.coordinate[0];
            double y = point.coordinate[1];
            double z = point.coordinate[2];
            double w = homogenous ? point.coordinate[3] : 1.0;
            out.setTo(x, y, z, w);
            func.process(pointIdx, (Object)out);
        }
    }

    public static double compatibleHomography(DMatrixRMaj F, DMatrixRMaj H) {
        DMatrixRMaj tmp0 = new DMatrixRMaj(3, 3);
        DMatrixRMaj tmp1 = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.multTransA((DMatrix1Row)H, (DMatrix1Row)F, (DMatrix1Row)tmp0);
        CommonOps_DDRM.multTransA((DMatrix1Row)F, (DMatrix1Row)H, (DMatrix1Row)tmp1);
        CommonOps_DDRM.add((DMatrixD1)tmp0, (DMatrixD1)tmp1, (DMatrixD1)tmp1);
        return NormOps_DDRM.normF((DMatrixD1)tmp1);
    }

    public static boolean homographyToFundamental(DMatrixRMaj H21, List<AssociatedPair> pairs, DMatrixRMaj F21) {
        ArrayList<LineGeneral2D_F64> epipolarLines = new ArrayList<LineGeneral2D_F64>();
        Point2D_F64 h2 = new Point2D_F64();
        for (int i = 0; i < pairs.size(); ++i) {
            AssociatedPair p = pairs.get(i);
            GeometryMath_F64.mult((DMatrixRMaj)H21, (GeoTuple2D_F64)p.p1, (GeoTuple2D_F64)h2);
            epipolarLines.add(UtilLine2D_F64.convert((Point2D_F64)p.p2, (Point2D_F64)h2, (LineGeneral2D_F64)null));
        }
        Point3D_F64 epipole = Intersection2D_F64.intersection(epipolarLines, null);
        GeometryMath_F64.multCrossA((GeoTuple3D_F64)epipole, (DMatrixRMaj)H21, (DMatrixRMaj)F21);
        return true;
    }

    public static DMatrixRMaj homographyToCalibrated(DMatrixRMaj H21, DMatrixRMaj K1, DMatrixRMaj K2) {
        return null;
    }

    public static DMatrixRMaj homographyFromRotation(DMatrixRMaj R21, DMatrixRMaj K1, DMatrixRMaj K2, @Nullable DMatrixRMaj H21) {
        if (H21 == null) {
            H21 = new DMatrixRMaj(3, 3);
        }
        DMatrixRMaj K1_inv = new DMatrixRMaj(3, 3);
        DMatrixRMaj KR = new DMatrixRMaj(3, 3);
        PerspectiveOps.invertCalibrationMatrix(K1, K1_inv);
        CommonOps_DDRM.mult((DMatrix1Row)K2, (DMatrix1Row)R21, (DMatrix1Row)KR);
        CommonOps_DDRM.mult((DMatrix1Row)KR, (DMatrix1Row)K1_inv, (DMatrix1Row)H21);
        return H21;
    }
}

