/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle.cameras;

import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import georegression.struct.point.Point2D_F64;

public class BundlePinhole
implements BundleAdjustmentCamera {
    public boolean zeroSkew = true;
    public double fx;
    public double fy;
    public double skew;
    public double cx;
    public double cy;

    public BundlePinhole(boolean zeroSkew) {
        this.zeroSkew = zeroSkew;
    }

    public BundlePinhole() {
    }

    public BundlePinhole setK(double fx, double fy, double skew, double cx, double cy) {
        this.fx = fx;
        this.fy = fy;
        this.skew = skew;
        this.cx = cx;
        this.cy = cy;
        this.zeroSkew = skew == 0.0;
        return this;
    }

    @Override
    public void setIntrinsic(double[] parameters, int offset) {
        this.fx = parameters[offset];
        this.fy = parameters[offset + 1];
        this.cx = parameters[offset + 2];
        this.cy = parameters[offset + 3];
        this.skew = !this.zeroSkew ? parameters[offset + 4] : 0.0;
    }

    @Override
    public void getIntrinsic(double[] parameters, int offset) {
        parameters[offset] = this.fx;
        parameters[offset + 1] = this.fy;
        parameters[offset + 2] = this.cx;
        parameters[offset + 3] = this.cy;
        if (!this.zeroSkew) {
            parameters[offset + 4] = this.skew;
        }
    }

    @Override
    public void project(double camX, double camY, double camZ, Point2D_F64 output) {
        double nx = camX / camZ;
        double ny = camY / camZ;
        output.x = this.fx * nx + this.skew * ny + this.cx;
        output.y = this.fy * ny + this.cy;
    }

    @Override
    public void jacobian(double camX, double camY, double camZ, double[] inputX, double[] inputY, boolean computeIntrinsic, double[] calibX, double[] calibY) {
        double nx = camX / camZ;
        double ny = camY / camZ;
        inputX[0] = this.fx / camZ;
        inputY[0] = 0.0;
        inputX[1] = this.skew / camZ;
        inputY[1] = this.fy / camZ;
        inputX[2] = -(this.fx * camX + this.skew * camY) / (camZ * camZ);
        inputY[2] = -this.fy * camY / (camZ * camZ);
        if (!computeIntrinsic) {
            return;
        }
        calibX[0] = nx;
        calibY[0] = 0.0;
        calibX[1] = 0.0;
        calibY[1] = ny;
        calibX[2] = 1.0;
        calibY[2] = 0.0;
        calibX[3] = 0.0;
        calibY[3] = 1.0;
        if (!this.zeroSkew) {
            calibX[4] = ny;
            calibY[4] = 0.0;
        }
    }

    @Override
    public int getIntrinsicCount() {
        return this.zeroSkew ? 4 : 5;
    }

    public String toString() {
        return "BundlePinhole{fx=" + this.fx + ", fy=" + this.fy + ", skew=" + this.skew + ", cx=" + this.cx + ", cy=" + this.cy + "}";
    }
}

