/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import georegression.geometry.ConvertRotation3D_F64;
import georegression.geometry.UtilVector3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.NormOps_DDRM;
import org.ejml.dense.row.SpecializedOps_DDRM;

public class Zhang99DecomposeHomography {
    DMatrixRMaj r1 = new DMatrixRMaj(3, 1);
    DMatrixRMaj r2 = new DMatrixRMaj(3, 1);
    DMatrixRMaj t = new DMatrixRMaj(3, 1);
    DMatrixRMaj temp = new DMatrixRMaj(3, 1);
    DMatrixRMaj R = new DMatrixRMaj(3, 3);
    DMatrixRMaj K;
    DMatrixRMaj K_inv = new DMatrixRMaj(3, 3);

    public void setCalibrationMatrix(DMatrixRMaj K) {
        this.K = K;
        CommonOps_DDRM.invert((DMatrixRMaj)K, (DMatrixRMaj)this.K_inv);
    }

    public Se3_F64 decompose(DMatrixRMaj H) {
        DMatrixRMaj[] h = SpecializedOps_DDRM.splitIntoVectors((DMatrix1Row)H, (boolean)true);
        CommonOps_DDRM.mult((DMatrix1Row)this.K_inv, (DMatrix1Row)h[0], (DMatrix1Row)this.temp);
        double lambda = NormOps_DDRM.normF((DMatrixD1)this.temp);
        CommonOps_DDRM.mult((DMatrix1Row)this.K_inv, (DMatrix1Row)h[1], (DMatrix1Row)this.temp);
        lambda += NormOps_DDRM.normF((DMatrixD1)this.temp);
        lambda = 2.0 / lambda;
        CommonOps_DDRM.mult((double)lambda, (DMatrix1Row)this.K_inv, (DMatrix1Row)h[0], (DMatrix1Row)this.r1);
        CommonOps_DDRM.mult((double)lambda, (DMatrix1Row)this.K_inv, (DMatrix1Row)h[1], (DMatrix1Row)this.r2);
        CommonOps_DDRM.mult((double)lambda, (DMatrix1Row)this.K_inv, (DMatrix1Row)h[2], (DMatrix1Row)this.t);
        Vector3D_F64 v1 = UtilVector3D_F64.convert((DMatrixRMaj)this.r1);
        Vector3D_F64 v2 = UtilVector3D_F64.convert((DMatrixRMaj)this.r2);
        Vector3D_F64 v3 = v1.crossWith(v2);
        UtilVector3D_F64.createMatrix((DMatrixRMaj)this.R, (Vector3D_F64[])new Vector3D_F64[]{v1, v2, v3});
        Se3_F64 ret = new Se3_F64();
        ConvertRotation3D_F64.approximateRotationMatrix((DMatrixRMaj)this.R, (DMatrixRMaj)ret.getR());
        ret.getT().setTo(this.t.data[0], this.t.data[1], this.t.data[2]);
        return ret;
    }
}

