/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.f;

import boofcv.alg.geo.f.HelperNister5;
import boofcv.struct.geo.AssociatedPair;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ddogleg.solver.Polynomial;
import org.ddogleg.solver.PolynomialRoots;
import org.ddogleg.solver.impl.FindRealRootsSturm;
import org.ddogleg.solver.impl.WrapRealRootsSturm;
import org.ddogleg.struct.DogArray;
import org.ejml.data.Complex_F64;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.dense.row.linsol.qr.SolveNullSpaceQRP_DDRM;
import org.ejml.interfaces.SolveNullSpace;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class EssentialNister5 {
    private final DMatrixRMaj Q = new DMatrixRMaj(5, 9);
    private final DMatrixRMaj nullspace = new DMatrixRMaj(9, 9);
    private final SolveNullSpace<DMatrixRMaj> solverNull = new SolveNullSpaceQRP_DDRM();
    private final HelperNister5 helper = new HelperNister5();
    private final double[] X = new double[9];
    private final double[] Y = new double[9];
    private final double[] Z = new double[9];
    private final double[] W = new double[9];
    private double x;
    private double y;
    private double z;
    LinearSolverDense<DMatrixRMaj> solver = LinearSolverFactory_DDRM.linear((int)10);
    private final DMatrixRMaj A1 = new DMatrixRMaj(10, 10);
    private final DMatrixRMaj A2 = new DMatrixRMaj(10, 10);
    private final DMatrixRMaj C = new DMatrixRMaj(10, 10);
    private final FindRealRootsSturm sturm = new FindRealRootsSturm(11, -1.0, 1.0E-10, 20, 20);
    private final PolynomialRoots rootFinder = new WrapRealRootsSturm(this.sturm);
    private final Polynomial poly = new Polynomial(11);
    DMatrixRMaj tmpA = new DMatrixRMaj(3, 2);
    DMatrixRMaj tmpY = new DMatrixRMaj(3, 1);
    DMatrixRMaj tmpX = new DMatrixRMaj(2, 1);

    public boolean process(List<AssociatedPair> points, DogArray<DMatrixRMaj> solutions) {
        if (points.size() != 5) {
            throw new IllegalArgumentException("Exactly 5 points are required, not " + points.size());
        }
        solutions.reset();
        this.computeSpan(points);
        this.helper.setNullSpace(this.X, this.Y, this.Z, this.W);
        this.helper.setupA1(this.A1);
        this.helper.setupA2(this.A2);
        if (!this.solver.setA((Matrix)this.A1)) {
            return false;
        }
        this.solver.solve((Matrix)this.A2, (Matrix)this.C);
        this.helper.setDeterminantVectors(this.C);
        this.helper.extractPolynomial(this.poly.getCoefficients());
        if (!this.rootFinder.process(this.poly)) {
            return false;
        }
        List zeros = this.rootFinder.getRoots();
        for (int rootIdx = 0; rootIdx < zeros.size(); ++rootIdx) {
            Complex_F64 c = (Complex_F64)zeros.get(rootIdx);
            if (!c.isReal()) continue;
            this.solveForXandY(c.real);
            DMatrixRMaj E = (DMatrixRMaj)solutions.grow();
            for (int i = 0; i < 9; ++i) {
                E.data[i] = this.x * this.X[i] + this.y * this.Y[i] + this.z * this.Z[i] + this.W[i];
            }
        }
        return true;
    }

    private void computeSpan(List<AssociatedPair> points) {
        int i;
        this.Q.reshape(points.size(), 9);
        int index = 0;
        for (i = 0; i < points.size(); ++i) {
            AssociatedPair p = points.get(i);
            Point2D_F64 a = p.p2;
            Point2D_F64 b = p.p1;
            this.Q.data[index++] = a.x * b.x;
            this.Q.data[index++] = a.x * b.y;
            this.Q.data[index++] = a.x;
            this.Q.data[index++] = a.y * b.x;
            this.Q.data[index++] = a.y * b.y;
            this.Q.data[index++] = a.y;
            this.Q.data[index++] = b.x;
            this.Q.data[index++] = b.y;
            this.Q.data[index++] = 1.0;
        }
        if (!this.solverNull.process((Matrix)this.Q, 4, (Matrix)this.nullspace)) {
            throw new RuntimeException("Nullspace solver should never fail, probably bad input");
        }
        for (i = 0; i < 9; ++i) {
            this.X[i] = this.nullspace.unsafe_get(i, 0);
            this.Y[i] = this.nullspace.unsafe_get(i, 1);
            this.Z[i] = this.nullspace.unsafe_get(i, 2);
            this.W[i] = this.nullspace.unsafe_get(i, 3);
        }
    }

    private void solveForXandY(double z) {
        this.z = z;
        this.tmpA.data[0] = ((this.helper.K00 * z + this.helper.K01) * z + this.helper.K02) * z + this.helper.K03;
        this.tmpA.data[1] = ((this.helper.K04 * z + this.helper.K05) * z + this.helper.K06) * z + this.helper.K07;
        this.tmpY.data[0] = (((this.helper.K08 * z + this.helper.K09) * z + this.helper.K10) * z + this.helper.K11) * z + this.helper.K12;
        this.tmpA.data[2] = ((this.helper.L00 * z + this.helper.L01) * z + this.helper.L02) * z + this.helper.L03;
        this.tmpA.data[3] = ((this.helper.L04 * z + this.helper.L05) * z + this.helper.L06) * z + this.helper.L07;
        this.tmpY.data[1] = (((this.helper.L08 * z + this.helper.L09) * z + this.helper.L10) * z + this.helper.L11) * z + this.helper.L12;
        this.tmpA.data[4] = ((this.helper.M00 * z + this.helper.M01) * z + this.helper.M02) * z + this.helper.M03;
        this.tmpA.data[5] = ((this.helper.M04 * z + this.helper.M05) * z + this.helper.M06) * z + this.helper.M07;
        this.tmpY.data[2] = (((this.helper.M08 * z + this.helper.M09) * z + this.helper.M10) * z + this.helper.M11) * z + this.helper.M12;
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.tmpY);
        CommonOps_DDRM.solve((DMatrixRMaj)this.tmpA, (DMatrixRMaj)this.tmpY, (DMatrixRMaj)this.tmpX);
        this.x = this.tmpX.get(0, 0);
        this.y = this.tmpX.get(1, 0);
    }
}

