/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle.cameras;

import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import georegression.struct.point.Point2D_F64;
import org.ejml.data.DMatrixRMaj;

public class BundlePinholeBrown
implements BundleAdjustmentCamera {
    public boolean zeroSkew = true;
    public boolean tangential = true;
    public double fx;
    public double fy;
    public double skew;
    public double cx;
    public double cy;
    public double[] radial;
    public double t1;
    public double t2;

    public BundlePinholeBrown(boolean zeroSkew, boolean tangential) {
        this.zeroSkew = zeroSkew;
        this.tangential = tangential;
        this.radial = new double[2];
    }

    public BundlePinholeBrown() {
    }

    public BundlePinholeBrown setK(double fx, double fy, double skew, double cx, double cy) {
        this.fx = fx;
        this.fy = fy;
        this.skew = skew;
        this.cx = cx;
        this.cy = cy;
        this.zeroSkew = skew == 0.0;
        return this;
    }

    public BundlePinholeBrown setK(DMatrixRMaj K) {
        this.fx = K.get(0, 0);
        this.fy = K.get(1, 1);
        this.cx = K.get(0, 2);
        this.cy = K.get(1, 2);
        this.skew = this.zeroSkew ? 0.0 : K.get(0, 1);
        return this;
    }

    public BundlePinholeBrown setRadial(double ... radial) {
        this.radial = (double[])radial.clone();
        return this;
    }

    public BundlePinholeBrown setTangential(double t1, double t2) {
        this.t1 = t1;
        this.t2 = t2;
        this.tangential = t1 != 0.0 || t2 != 0.0;
        return this;
    }

    @Override
    public void setIntrinsic(double[] parameters, int offset) {
        this.fx = parameters[offset++];
        this.fy = parameters[offset++];
        this.cx = parameters[offset++];
        this.cy = parameters[offset++];
        for (int i = 0; i < this.radial.length; ++i) {
            this.radial[i] = parameters[offset++];
        }
        if (this.tangential) {
            this.t1 = parameters[offset++];
            this.t2 = parameters[offset++];
        }
        this.skew = !this.zeroSkew ? parameters[offset] : 0.0;
    }

    @Override
    public void getIntrinsic(double[] parameters, int offset) {
        parameters[offset++] = this.fx;
        parameters[offset++] = this.fy;
        parameters[offset++] = this.cx;
        parameters[offset++] = this.cy;
        for (int i = 0; i < this.radial.length; ++i) {
            parameters[offset++] = this.radial[i];
        }
        if (this.tangential) {
            parameters[offset++] = this.t1;
            parameters[offset++] = this.t2;
        }
        if (!this.zeroSkew) {
            parameters[offset] = this.skew;
        }
    }

    @Override
    public void project(double camX, double camY, double camZ, Point2D_F64 output) {
        double y;
        double x;
        double r2;
        double nx = camX / camZ;
        double ny = camY / camZ;
        double a = 0.0;
        double r2i = r2 = nx * nx + ny * ny;
        for (int i = 0; i < this.radial.length; ++i) {
            a += this.radial[i] * r2i;
            r2i *= r2;
        }
        if (this.tangential) {
            x = nx * (1.0 + a) + 2.0 * this.t1 * nx * ny + this.t2 * (r2 + 2.0 * nx * nx);
            y = ny * (1.0 + a) + this.t1 * (r2 + 2.0 * ny * ny) + 2.0 * this.t2 * nx * ny;
        } else {
            x = nx * (1.0 + a);
            y = ny * (1.0 + a);
        }
        output.x = this.fx * x + this.skew * y + this.cx;
        output.y = this.fy * y + this.cy;
    }

    @Override
    public void jacobian(double camX, double camY, double camZ, double[] inputX, double[] inputY, boolean computeIntrinsic, double[] calibX, double[] calibY) {
        double r2;
        double nx = camX / camZ;
        double ny = camY / camZ;
        double Z = camZ;
        double sum = 0.0;
        double sumdot = 0.0;
        double r2i = r2 = nx * nx + ny * ny;
        double rdev = 1.0;
        for (int i = 0; i < this.radial.length; ++i) {
            sum += this.radial[i] * r2i;
            sumdot += this.radial[i] * (double)(i + 1) * rdev;
            r2i *= r2;
            rdev *= r2;
        }
        double xdot = sumdot * 2.0 * nx * nx / Z + (1.0 + sum) / Z;
        double ydot = sumdot * 2.0 * nx * ny / Z;
        if (this.tangential) {
            xdot += (2.0 * this.t1 * ny + this.t2 * 6.0 * nx) / Z;
            ydot += (2.0 * this.t1 * nx + 2.0 * ny * this.t2) / Z;
        }
        inputX[0] = this.fx * xdot + this.skew * ydot;
        inputY[0] = this.fy * ydot;
        xdot = sumdot * 2.0 * ny * nx / Z;
        ydot = sumdot * 2.0 * ny * ny / Z + (1.0 + sum) / Z;
        if (this.tangential) {
            xdot += (2.0 * this.t1 * nx + this.t2 * 2.0 * ny) / Z;
            ydot += (6.0 * this.t1 * ny + 2.0 * nx * this.t2) / Z;
        }
        inputX[1] = this.fx * xdot + this.skew * ydot;
        inputY[1] = this.fy * ydot;
        xdot = -sumdot * 2.0 * r2 * nx / Z;
        ydot = -sumdot * 2.0 * r2 * ny / Z;
        xdot += -(1.0 + sum) * nx / Z;
        ydot += -(1.0 + sum) * ny / Z;
        if (this.tangential) {
            xdot += -(4.0 * this.t1 * nx * ny + 6.0 * this.t2 * nx * nx + 2.0 * this.t2 * ny * ny) / Z;
            ydot += -(2.0 * this.t1 * nx * nx + 6.0 * this.t1 * ny * ny + 4.0 * nx * ny * this.t2) / Z;
        }
        inputX[2] = this.fx * xdot + this.skew * ydot;
        inputY[2] = this.fy * ydot;
        if (!computeIntrinsic) {
            return;
        }
        double x = nx + nx * sum + (this.tangential ? 2.0 * this.t1 * nx * ny + this.t2 * (r2 + 2.0 * nx * nx) : 0.0);
        double y = ny + ny * sum + (this.tangential ? this.t1 * (r2 + 2.0 * ny * ny) + 2.0 * this.t2 * ny * ny : 0.0);
        this.jacobianIntrinsic(calibX, calibY, nx, ny, x, y);
    }

    private void jacobianIntrinsic(double[] calibX, double[] calibY, double nx, double ny, double dnx, double dny) {
        double r2;
        int index = 0;
        calibX[index] = dnx;
        calibY[index++] = 0.0;
        calibX[index] = 0.0;
        calibY[index++] = dny;
        calibX[index] = 1.0;
        calibY[index++] = 0.0;
        calibX[index] = 0.0;
        calibY[index++] = 1.0;
        double r2i = r2 = nx * nx + ny * ny;
        for (int i = 0; i < this.radial.length; ++i) {
            double xdot = nx * r2i;
            double ydot = ny * r2i;
            calibX[index] = this.fx * xdot + this.skew * ydot;
            calibY[index++] = this.fy * ydot;
            r2i *= r2;
        }
        if (this.tangential) {
            double xy2 = 2.0 * nx * ny;
            double r2yy = r2 + 2.0 * ny * ny;
            double r2xx = r2 + 2.0 * nx * nx;
            calibX[index] = this.fx * xy2 + this.skew * r2yy;
            calibY[index++] = this.fy * r2yy;
            calibX[index] = this.fx * r2xx + this.skew * xy2;
            calibY[index++] = this.fy * xy2;
        }
        if (!this.zeroSkew) {
            calibX[index] = dny;
            calibY[index] = 0.0;
        }
    }

    @Override
    public int getIntrinsicCount() {
        return 4 + this.radial.length + (this.tangential ? 2 : 0) + (this.zeroSkew ? 0 : 1);
    }
}

