/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.rectify;

import boofcv.alg.geo.MultiViewOps;
import boofcv.struct.geo.AssociatedPair;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import java.util.List;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;

public class RectifyFundamental {
    final DMatrixRMaj rect1 = new DMatrixRMaj(3, 3);
    final DMatrixRMaj rect2 = new DMatrixRMaj(3, 3);
    private final Point3D_F64 epipole1 = new Point3D_F64();
    private final Point3D_F64 epipole2 = new Point3D_F64();

    public void process(DMatrixRMaj F, List<AssociatedPair> observations, int width, int height) {
        int centerX = width / 2;
        int centerY = height / 2;
        MultiViewOps.extractEpipoles(F, this.epipole1, this.epipole2);
        this.checkEpipoleInside(width, height);
        SimpleMatrix R = RectifyFundamental.rotateEpipole(this.epipole2, centerX, centerY);
        SimpleMatrix T = this.translateToOrigin(centerX, centerY);
        SimpleMatrix G = this.computeG(this.epipole2, centerX, centerY);
        SimpleMatrix H = (SimpleMatrix)((SimpleMatrix)G.mult((SimpleBase)R)).mult((SimpleBase)T);
        SimpleMatrix Hzero = this.computeHZero(F, this.epipole2, H);
        SimpleMatrix Ha = this.computeAffineH(observations, H.getDDRM(), Hzero.getDDRM());
        this.rect1.setTo((DMatrixD1)((SimpleMatrix)Ha.mult((SimpleBase)Hzero)).getDDRM());
        this.rect2.setTo((DMatrixD1)H.getDDRM());
    }

    private void checkEpipoleInside(int width, int height) {
        double x1 = this.epipole1.x / this.epipole1.z;
        double y1 = this.epipole1.y / this.epipole1.z;
        double x2 = this.epipole2.x / this.epipole2.z;
        double y2 = this.epipole2.y / this.epipole2.z;
        if (x1 >= 0.0 && x1 < (double)width && y1 >= 0.0 && y1 < (double)height) {
            throw new IllegalArgumentException("First epipole is inside the image");
        }
        if (x2 >= 0.0 && x2 < (double)width && y2 >= 0.0 && y2 < (double)height) {
            throw new IllegalArgumentException("Second epipole is inside the image");
        }
    }

    private SimpleMatrix translateToOrigin(int x0, int y0) {
        SimpleMatrix T = SimpleMatrix.identity((int)3);
        T.set(0, 2, (double)(-x0));
        T.set(1, 2, (double)(-y0));
        return T;
    }

    static SimpleMatrix rotateEpipole(Point3D_F64 epipole, int x0, int y0) {
        double x = epipole.x / epipole.z - (double)x0;
        double y = epipole.y / epipole.z - (double)y0;
        double theta = Math.atan2(-y, x);
        double c = Math.cos(theta);
        double s = Math.sin(theta);
        SimpleMatrix R = new SimpleMatrix(3, 3);
        R.setRow(0, 0, new double[]{c, -s});
        R.setRow(1, 0, new double[]{s, c});
        R.set(2, 2, 1.0);
        return R;
    }

    private SimpleMatrix computeG(Point3D_F64 epipole, int x0, int y0) {
        double x = epipole.x / epipole.z - (double)x0;
        double y = epipole.y / epipole.z - (double)y0;
        double f = Math.sqrt(x * x + y * y);
        SimpleMatrix G = SimpleMatrix.identity((int)3);
        G.set(2, 0, -1.0 / f);
        return G;
    }

    private SimpleMatrix computeAffineH(List<AssociatedPair> observations, DMatrixRMaj H, DMatrixRMaj Hzero) {
        SimpleMatrix A = new SimpleMatrix(observations.size(), 3);
        SimpleMatrix b = new SimpleMatrix(A.numRows(), 1);
        Point2D_F64 c = new Point2D_F64();
        Point2D_F64 k = new Point2D_F64();
        for (int i = 0; i < observations.size(); ++i) {
            AssociatedPair a = observations.get(i);
            GeometryMath_F64.mult((DMatrixRMaj)Hzero, (GeoTuple2D_F64)a.p1, (GeoTuple2D_F64)k);
            GeometryMath_F64.mult((DMatrixRMaj)H, (GeoTuple2D_F64)a.p2, (GeoTuple2D_F64)c);
            A.setRow(i, 0, new double[]{k.x, k.y, 1.0});
            b.set(i, 0, c.x);
        }
        SimpleMatrix x = (SimpleMatrix)A.solve((SimpleBase)b);
        SimpleMatrix Ha = SimpleMatrix.identity((int)3);
        Ha.setRow(0, 0, x.getDDRM().data);
        return Ha;
    }

    private SimpleMatrix computeHZero(DMatrixRMaj F, Point3D_F64 e2, SimpleMatrix H) {
        Vector3D_F64 v = new Vector3D_F64(0.1, 0.5, 0.2);
        SimpleMatrix P = SimpleMatrix.wrap((Matrix)MultiViewOps.fundamentalToProjective(F, e2, v, 1.0));
        SimpleMatrix M = (SimpleMatrix)P.extractMatrix(0, 3, 0, 3);
        return (SimpleMatrix)H.mult((SimpleBase)M);
    }

    public DMatrixRMaj getRect1() {
        return this.rect1;
    }

    public DMatrixRMaj getRect2() {
        return this.rect2;
    }
}

