/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.robust;

import boofcv.abst.geo.Estimate1ofEpipolar;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.geo.AssociatedPair;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.homography.UtilHomography_F64;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelFitter;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ejml.data.DMatrixRMaj;

public class GenerateHomographyLinear
implements ModelGenerator<Homography2D_F64, AssociatedPair>,
ModelFitter<Homography2D_F64, AssociatedPair> {
    Estimate1ofEpipolar alg;
    DMatrixRMaj H = new DMatrixRMaj(3, 3);

    public GenerateHomographyLinear(boolean normalizeInput) {
        this.alg = FactoryMultiView.homographyDLT(normalizeInput);
    }

    public boolean fitModel(List<AssociatedPair> dataSet, Homography2D_F64 initial, Homography2D_F64 found) {
        if (!this.alg.process(dataSet, this.H)) {
            return false;
        }
        UtilHomography_F64.convert((DMatrixRMaj)this.H, (Homography2D_F64)found);
        return true;
    }

    public boolean generate(List<AssociatedPair> dataSet, Homography2D_F64 model) {
        if (!this.alg.process(dataSet, this.H)) {
            return false;
        }
        UtilHomography_F64.convert((DMatrixRMaj)this.H, (Homography2D_F64)model);
        return true;
    }

    public int getMinimumPoints() {
        return 4;
    }

    public double getFitScore() {
        return 0.0;
    }
}

