/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.calib;

import boofcv.struct.calib.CameraModel;
import org.ejml.data.DMatrixRMaj;

public class CameraPinhole
extends CameraModel {
    public double fx;
    public double fy;
    public double skew;
    public double cx;
    public double cy;

    public CameraPinhole() {
    }

    public CameraPinhole(CameraPinhole param) {
        this.setTo(param);
    }

    public CameraPinhole(double fx, double fy, double skew, double cx, double cy, int width, int height) {
        this.fsetK(fx, fy, skew, cx, cy, width, height);
    }

    public void reset() {
        this.cy = 0.0;
        this.cx = 0.0;
        this.skew = 0.0;
        this.fy = 0.0;
        this.fx = 0.0;
        this.height = 0;
        this.width = 0;
    }

    public CameraPinhole fsetK(double fx, double fy, double skew, double cx, double cy) {
        this.fx = fx;
        this.fy = fy;
        this.skew = skew;
        this.cx = cx;
        this.cy = cy;
        return this;
    }

    public CameraPinhole fsetK(DMatrixRMaj K) {
        this.fx = K.unsafe_get(0, 0);
        this.fy = K.unsafe_get(1, 1);
        this.skew = K.unsafe_get(0, 1);
        this.cx = K.unsafe_get(0, 2);
        this.cy = K.unsafe_get(1, 2);
        return this;
    }

    public CameraPinhole fsetK(double fx, double fy, double skew, double cx, double cy, int width, int height) {
        this.fx = fx;
        this.fy = fy;
        this.skew = skew;
        this.cx = cx;
        this.cy = cy;
        this.width = width;
        this.height = height;
        return this;
    }

    public CameraPinhole fsetShape(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public void setTo(CameraPinhole param) {
        this.fx = param.fx;
        this.fy = param.fy;
        this.skew = param.skew;
        this.cx = param.cx;
        this.cy = param.cy;
        this.width = param.width;
        this.height = param.height;
    }

    public boolean isInside(double x, double y) {
        return x >= 0.0 && y >= 0.0 && x < (double)this.width && y < (double)this.height;
    }

    public boolean isInside(int x, int y) {
        return x >= 0 && y >= 0 && x < this.width && y < this.height;
    }

    @Override
    public void print() {
        System.out.println("Shape " + this.width + " " + this.height);
        System.out.printf("center %7.2f %7.2f\n", this.cx, this.cy);
        System.out.println("fx = " + this.fx);
        System.out.println("fy = " + this.fy);
        System.out.println("skew = " + this.skew);
    }

    @Override
    public <T extends CameraModel> T createLike() {
        return (T)new CameraPinhole();
    }

    public String toString() {
        return "CameraPinhole{fx=" + this.fx + ", fy=" + this.fy + ", skew=" + this.skew + ", cx=" + this.cx + ", cy=" + this.cy + ", width=" + this.width + ", height=" + this.height + '}';
    }

    public boolean isEquals(CameraPinhole param, double tol) {
        if (Math.abs(this.fx - param.fx) > tol) {
            return false;
        }
        if (Math.abs(this.fy - param.fy) > tol) {
            return false;
        }
        if (Math.abs(this.skew - param.skew) > tol) {
            return false;
        }
        if (Math.abs(this.cx - param.cx) > tol) {
            return false;
        }
        if (Math.abs(this.cy - param.cy) > tol) {
            return false;
        }
        if (this.width != param.width) {
            return false;
        }
        return this.height == param.height;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CameraPinhole)) {
            return false;
        }
        CameraPinhole other = (CameraPinhole)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getFx(), other.getFx()) != 0) {
            return false;
        }
        if (Double.compare(this.getFy(), other.getFy()) != 0) {
            return false;
        }
        if (Double.compare(this.getSkew(), other.getSkew()) != 0) {
            return false;
        }
        if (Double.compare(this.getCx(), other.getCx()) != 0) {
            return false;
        }
        return Double.compare(this.getCy(), other.getCy()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof CameraPinhole;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $fx = Double.doubleToLongBits(this.getFx());
        result = result * 59 + (int)($fx >>> 32 ^ $fx);
        long $fy = Double.doubleToLongBits(this.getFy());
        result = result * 59 + (int)($fy >>> 32 ^ $fy);
        long $skew = Double.doubleToLongBits(this.getSkew());
        result = result * 59 + (int)($skew >>> 32 ^ $skew);
        long $cx = Double.doubleToLongBits(this.getCx());
        result = result * 59 + (int)($cx >>> 32 ^ $cx);
        long $cy = Double.doubleToLongBits(this.getCy());
        result = result * 59 + (int)($cy >>> 32 ^ $cy);
        return result;
    }

    public double getFx() {
        return this.fx;
    }

    public double getFy() {
        return this.fy;
    }

    public void setFx(double fx) {
        this.fx = fx;
    }

    public void setFy(double fy) {
        this.fy = fy;
    }

    public double getSkew() {
        return this.skew;
    }

    public void setSkew(double skew) {
        this.skew = skew;
    }

    public double getCx() {
        return this.cx;
    }

    public double getCy() {
        return this.cy;
    }

    public void setCx(double cx) {
        this.cx = cx;
    }

    public void setCy(double cy) {
        this.cy = cy;
    }
}

