/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.geo;

import boofcv.abst.geo.Estimate1ofEpipolar;
import boofcv.abst.geo.Estimate1ofPnP;
import boofcv.abst.geo.Triangulate2ViewsMetricH;
import boofcv.abst.geo.fitting.DistanceFromModelResidual;
import boofcv.abst.geo.fitting.GenerateEpipolarMatrix;
import boofcv.abst.geo.fitting.ModelManagerEpipolarMatrix;
import boofcv.alg.geo.f.FundamentalResidualSampson;
import boofcv.alg.geo.pose.PnPDistanceReprojectionSq;
import boofcv.alg.geo.robust.DistanceFromModelIntoViews;
import boofcv.alg.geo.robust.DistanceFundamentalGeometric;
import boofcv.alg.geo.robust.DistanceHomographyCalibratedSq;
import boofcv.alg.geo.robust.DistanceHomographySq;
import boofcv.alg.geo.robust.DistanceMultiView_EssentialSampson;
import boofcv.alg.geo.robust.DistanceSe3SymmetricSq;
import boofcv.alg.geo.robust.DistanceTrifocalReprojectionSq;
import boofcv.alg.geo.robust.DistanceTrifocalTransferSq;
import boofcv.alg.geo.robust.GenerateHomographyLinear;
import boofcv.alg.geo.robust.GenerateTrifocalTensor;
import boofcv.alg.geo.robust.LeastMedianOfSquaresCalibrated;
import boofcv.alg.geo.robust.LeastMedianOfSquaresProjective;
import boofcv.alg.geo.robust.ManagerTrifocalTensor;
import boofcv.alg.geo.robust.MmmvSe3ToEssential;
import boofcv.alg.geo.robust.ModelGeneratorViews;
import boofcv.alg.geo.robust.ModelMatcherMultiview;
import boofcv.alg.geo.robust.RansacCalibrated;
import boofcv.alg.geo.robust.RansacProjective;
import boofcv.alg.geo.robust.Se3FromEssentialGenerator;
import boofcv.alg.geo.selfcalib.DistanceMetricTripleReprojection23;
import boofcv.alg.geo.selfcalib.MetricCameraTriple;
import boofcv.alg.geo.selfcalib.ModelManagerMetricCameraTriple;
import boofcv.concurrency.BoofConcurrency;
import boofcv.factory.geo.ConfigEssential;
import boofcv.factory.geo.ConfigFundamental;
import boofcv.factory.geo.ConfigHomography;
import boofcv.factory.geo.ConfigLMedS;
import boofcv.factory.geo.ConfigPixelsToMetric;
import boofcv.factory.geo.ConfigPnP;
import boofcv.factory.geo.ConfigRansac;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.ConfigTrifocal;
import boofcv.factory.geo.ConfigTrifocalError;
import boofcv.factory.geo.EstimatorToGenerator;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.calib.ElevateViewInfo;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.AssociatedTriple;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.geo.TrifocalTensor;
import georegression.fitting.homography.ModelManagerHomography2D_F64;
import georegression.fitting.se.ModelManagerSe3_F64;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.se.Se3_F64;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.fitting.modelset.lmeds.LeastMedianOfSquares;
import org.ddogleg.fitting.modelset.lmeds.LeastMedianOfSquares_MT;
import org.ddogleg.fitting.modelset.ransac.Ransac;
import org.ddogleg.fitting.modelset.ransac.Ransac_MT;
import org.ddogleg.struct.Factory;
import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class FactoryMultiViewRobust {
    public static ModelMatcherMultiview<Se3_F64, Point2D3D> pnpLMedS(@Nullable ConfigPnP configPnP, ConfigLMedS configLMedS) {
        if (configPnP == null) {
            configPnP = new ConfigPnP();
        }
        configPnP.checkValidity();
        configLMedS.checkValidity();
        ModelManagerSe3_F64 manager = new ModelManagerSe3_F64();
        LeastMedianOfSquaresCalibrated<Se3_F64, Point2D3D> lmeds = new LeastMedianOfSquaresCalibrated<Se3_F64, Point2D3D>(FactoryMultiViewRobust.createLMEDS(configLMedS, manager, Point2D3D.class));
        lmeds.getFitter().setErrorFraction(configLMedS.errorFraction);
        ConfigPnP _configPnP = configPnP;
        lmeds.setModel(() -> {
            Estimate1ofPnP estimatorPnP = FactoryMultiView.pnp_1(_configPnP.which, _configPnP.epnpIterations, _configPnP.numResolve);
            return new EstimatorToGenerator<Se3_F64, Point2D3D>(estimatorPnP);
        }, PnPDistanceReprojectionSq::new);
        return lmeds;
    }

    public static RansacCalibrated<Se3_F64, Point2D3D> pnpRansac(@Nullable ConfigPnP configPnP, ConfigRansac configRansac) {
        if (configPnP == null) {
            configPnP = new ConfigPnP();
        }
        configPnP.checkValidity();
        configRansac.checkValidity();
        double threshold = configRansac.inlierThreshold * configRansac.inlierThreshold;
        RansacCalibrated<Se3_F64, Point2D3D> ransac = new RansacCalibrated<Se3_F64, Point2D3D>(FactoryMultiViewRobust.createRansac(configRansac, threshold, new ModelManagerSe3_F64(), Point2D3D.class));
        ConfigPnP _configPnP = configPnP;
        ransac.setModel(() -> {
            Estimate1ofPnP estimatorPnP = FactoryMultiView.pnp_1(_configPnP.which, _configPnP.epnpIterations, _configPnP.numResolve);
            return new EstimatorToGenerator<Se3_F64, Point2D3D>(estimatorPnP);
        }, PnPDistanceReprojectionSq::new);
        return ransac;
    }

    public static ModelMatcherMultiview<Se3_F64, AssociatedPair> baselineLMedS(@Nullable ConfigEssential configEssential, ConfigLMedS configLMedS) {
        if (configEssential == null) {
            configEssential = new ConfigEssential();
        }
        configEssential.checkValidity();
        configLMedS.checkValidity();
        ModelManagerSe3_F64 manager = new ModelManagerSe3_F64();
        LeastMedianOfSquaresCalibrated<Se3_F64, AssociatedPair> lmeds = new LeastMedianOfSquaresCalibrated<Se3_F64, AssociatedPair>(FactoryMultiViewRobust.createLMEDS(configLMedS, manager, AssociatedPair.class));
        lmeds.getFitter().setErrorFraction(configLMedS.errorFraction);
        ConfigEssential _configEssential = configEssential;
        lmeds.setModel(() -> {
            Estimate1ofEpipolar epipolar = FactoryMultiView.essential_1(_configEssential.which, _configEssential.numResolve);
            Triangulate2ViewsMetricH triangulate = FactoryMultiView.triangulate2ViewMetricH(new ConfigTriangulation(ConfigTriangulation.Type.GEOMETRIC));
            return new Se3FromEssentialGenerator(epipolar, triangulate);
        }, () -> {
            Triangulate2ViewsMetricH triangulate = FactoryMultiView.triangulate2ViewMetricH(new ConfigTriangulation(ConfigTriangulation.Type.GEOMETRIC));
            return new DistanceSe3SymmetricSq(triangulate);
        });
        return lmeds;
    }

    public static ModelMatcher<DMatrixRMaj, AssociatedPair> fundamentalLMedS(@Nullable ConfigFundamental configFundamental, ConfigLMedS configLMedS) {
        if (configFundamental == null) {
            configFundamental = new ConfigFundamental();
        }
        configFundamental.checkValidity();
        configLMedS.checkValidity();
        ConfigFundamental _configFundamental = configFundamental;
        ModelManagerEpipolarMatrix manager = new ModelManagerEpipolarMatrix();
        LeastMedianOfSquares<DMatrixRMaj, AssociatedPair> alg = FactoryMultiViewRobust.createLMEDS(configLMedS, manager, AssociatedPair.class);
        alg.setModel(() -> {
            Estimate1ofEpipolar estimateF = FactoryMultiView.fundamental_1(_configFundamental.which, _configFundamental.numResolve);
            return new GenerateEpipolarMatrix(estimateF);
        }, () -> {
            Object object;
            switch (_configFundamental.errorModel) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case SAMPSON: {
                    object = new DistanceFromModelResidual<DMatrixRMaj, AssociatedPair>(new FundamentalResidualSampson());
                    break;
                }
                case GEOMETRIC: {
                    object = new DistanceFundamentalGeometric();
                }
            }
            return object;
        });
        return alg;
    }

    public static RansacCalibrated<Se3_F64, AssociatedPair> baselineRansac(@Nullable ConfigEssential configEssential, ConfigRansac configRansac) {
        if (configEssential == null) {
            configEssential = new ConfigEssential();
        }
        configEssential.checkValidity();
        configRansac.checkValidity();
        if (configEssential.errorModel != ConfigEssential.ErrorModel.GEOMETRIC) {
            throw new RuntimeException("Error model has to be Euclidean");
        }
        ConfigEssential _configEssential = configEssential;
        double ransacTOL = configRansac.inlierThreshold * configRansac.inlierThreshold * 2.0;
        RansacCalibrated<Se3_F64, AssociatedPair> ransac = new RansacCalibrated<Se3_F64, AssociatedPair>(FactoryMultiViewRobust.createRansac(configRansac, ransacTOL, new ModelManagerSe3_F64(), AssociatedPair.class));
        ransac.setModel(() -> {
            Estimate1ofEpipolar epipolar = FactoryMultiView.essential_1(_configEssential.which, _configEssential.numResolve);
            Triangulate2ViewsMetricH triangulate = FactoryMultiView.triangulate2ViewMetricH(new ConfigTriangulation(ConfigTriangulation.Type.GEOMETRIC));
            return new Se3FromEssentialGenerator(epipolar, triangulate);
        }, () -> {
            Triangulate2ViewsMetricH triangulate = FactoryMultiView.triangulate2ViewMetricH(new ConfigTriangulation(ConfigTriangulation.Type.GEOMETRIC));
            return new DistanceSe3SymmetricSq(triangulate);
        });
        return ransac;
    }

    public static ModelMatcherMultiview<DMatrixRMaj, AssociatedPair> essentialRansac(@Nullable ConfigEssential configEssential, ConfigRansac configRansac) {
        if (configEssential == null) {
            configEssential = new ConfigEssential();
        }
        configEssential.checkValidity();
        configRansac.checkValidity();
        if (configEssential.errorModel == ConfigEssential.ErrorModel.GEOMETRIC) {
            return new MmmvSe3ToEssential((ModelMatcherMultiview<Se3_F64, AssociatedPair>)FactoryMultiViewRobust.baselineRansac(configEssential, configRansac));
        }
        double ransacTOL = configRansac.inlierThreshold * configRansac.inlierThreshold;
        RansacCalibrated<DMatrixRMaj, AssociatedPair> ransac = new RansacCalibrated<DMatrixRMaj, AssociatedPair>(FactoryMultiViewRobust.createRansac(configRansac, ransacTOL, new ModelManagerEpipolarMatrix(), AssociatedPair.class));
        ConfigEssential _configEssential = configEssential;
        ransac.setModel((Factory<ModelGenerator<DMatrixRMaj, AssociatedPair>>)((Factory)() -> {
            Estimate1ofEpipolar estimateF = FactoryMultiView.essential_1(_configEssential.which, _configEssential.numResolve);
            return new GenerateEpipolarMatrix(estimateF);
        }), (Factory<DistanceFromModel<DMatrixRMaj, AssociatedPair>>)((Factory)DistanceMultiView_EssentialSampson::new));
        return ransac;
    }

    public static ModelMatcher<DMatrixRMaj, AssociatedPair> fundamentalRansac(ConfigFundamental configFundamental, ConfigRansac configRansac) {
        configFundamental.checkValidity();
        configRansac.checkValidity();
        ModelManagerEpipolarMatrix manager = new ModelManagerEpipolarMatrix();
        double ransacTol = configRansac.inlierThreshold * configRansac.inlierThreshold;
        Ransac<DMatrixRMaj, AssociatedPair> ransac = FactoryMultiViewRobust.createRansac(configRansac, ransacTol, manager, AssociatedPair.class);
        ransac.setModel(() -> {
            Estimate1ofEpipolar estimateF = FactoryMultiView.fundamental_1(configFundamental.which, configFundamental.numResolve);
            return new GenerateEpipolarMatrix(estimateF);
        }, () -> {
            Object object;
            switch (configFundamental.errorModel) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case SAMPSON: {
                    object = new DistanceFromModelResidual<DMatrixRMaj, AssociatedPair>(new FundamentalResidualSampson());
                    break;
                }
                case GEOMETRIC: {
                    object = new DistanceFundamentalGeometric();
                }
            }
            return object;
        });
        return ransac;
    }

    public static LeastMedianOfSquares<Homography2D_F64, AssociatedPair> homographyLMedS(@Nullable ConfigHomography configHomography, ConfigLMedS configLMedS) {
        if (configHomography == null) {
            configHomography = new ConfigHomography();
        }
        configHomography.checkValidity();
        configLMedS.checkValidity();
        ConfigHomography _configHomography = configHomography;
        ModelManagerHomography2D_F64 manager = new ModelManagerHomography2D_F64();
        LeastMedianOfSquares lmeds = FactoryMultiViewRobust.createLMEDS(configLMedS, manager, AssociatedPair.class);
        lmeds.setModel(() -> new GenerateHomographyLinear(_configHomography.normalize), DistanceHomographySq::new);
        return lmeds;
    }

    public static Ransac<Homography2D_F64, AssociatedPair> homographyRansac(@Nullable ConfigHomography configHomography, ConfigRansac configRansac) {
        if (configHomography == null) {
            configHomography = new ConfigHomography();
        }
        configHomography.checkValidity();
        configRansac.checkValidity();
        ConfigHomography _configHomography = configHomography;
        ModelManagerHomography2D_F64 manager = new ModelManagerHomography2D_F64();
        double ransacTol = configRansac.inlierThreshold * configRansac.inlierThreshold;
        Ransac ransac = FactoryMultiViewRobust.createRansac(configRansac, ransacTol, manager, AssociatedPair.class);
        ransac.setModel(() -> new GenerateHomographyLinear(_configHomography.normalize), DistanceHomographySq::new);
        return ransac;
    }

    public static RansacCalibrated<Homography2D_F64, AssociatedPair> homographyCalibratedRansac(ConfigRansac configRansac) {
        configRansac.checkValidity();
        double ransacTol = configRansac.inlierThreshold * configRansac.inlierThreshold;
        RansacCalibrated<Homography2D_F64, AssociatedPair> ransac = new RansacCalibrated<Homography2D_F64, AssociatedPair>(FactoryMultiViewRobust.createRansac(configRansac, ransacTol, new ModelManagerHomography2D_F64(), AssociatedPair.class));
        ransac.setModel(() -> new GenerateHomographyLinear(false), DistanceHomographyCalibratedSq::new);
        return ransac;
    }

    public static Ransac<TrifocalTensor, AssociatedTriple> trifocalRansac(@Nullable ConfigTrifocal configTrifocal, @Nullable ConfigTrifocalError configError, ConfigRansac configRansac) {
        Factory distance;
        double ransacTol;
        if (configTrifocal == null) {
            configTrifocal = new ConfigTrifocal();
        }
        if (configError == null) {
            configError = new ConfigTrifocalError();
        }
        configTrifocal.checkValidity();
        configError.checkValidity();
        configRansac.checkValidity();
        ConfigTrifocal _configTrifocal = configTrifocal;
        ConfigTrifocalError _configError = configError;
        switch (configError.model) {
            case REPROJECTION: {
                ransacTol = 3.0 * configRansac.inlierThreshold * configRansac.inlierThreshold;
                distance = DistanceTrifocalReprojectionSq::new;
                break;
            }
            case REPROJECTION_REFINE: {
                ransacTol = 3.0 * configRansac.inlierThreshold * configRansac.inlierThreshold;
                distance = () -> new DistanceTrifocalReprojectionSq(_configError.converge.gtol, _configError.converge.maxIterations);
                break;
            }
            case POINT_TRANSFER: {
                ransacTol = 2.0 * configRansac.inlierThreshold * configRansac.inlierThreshold;
                distance = DistanceTrifocalTransferSq::new;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown error model " + configError.model);
            }
        }
        ManagerTrifocalTensor manager = new ManagerTrifocalTensor();
        Ransac<TrifocalTensor, AssociatedTriple> ransac = FactoryMultiViewRobust.createRansac(configRansac, ransacTol, manager, AssociatedTriple.class);
        ransac.setModel(() -> new GenerateTrifocalTensor(FactoryMultiView.trifocal_1(_configTrifocal)), distance);
        return ransac;
    }

    public static RansacProjective<MetricCameraTriple, AssociatedTriple> metricThreeViewRansac(@Nullable ConfigPixelsToMetric configSelfcalib, ConfigRansac configRansac) {
        configRansac.checkValidity();
        double ransacTol = configRansac.inlierThreshold * configRansac.inlierThreshold * 2.0;
        ModelGeneratorViews<MetricCameraTriple, AssociatedTriple, ElevateViewInfo> generator = FactoryMultiView.selfCalibThree(configSelfcalib);
        ModelManagerMetricCameraTriple manager = new ModelManagerMetricCameraTriple();
        DistanceFromModelIntoViews distance = new DistanceFromModelIntoViews(new DistanceMetricTripleReprojection23(), 3);
        return new RansacProjective<MetricCameraTriple, AssociatedTriple>(configRansac.randSeed, manager, generator, distance, configRansac.iterations, ransacTol);
    }

    public static LeastMedianOfSquaresProjective<MetricCameraTriple, AssociatedTriple> metricThreeViewLmeds(@Nullable ConfigPixelsToMetric configSelfcalib, ConfigLMedS configLMedS) {
        configLMedS.checkValidity();
        ModelGeneratorViews<MetricCameraTriple, AssociatedTriple, ElevateViewInfo> generator = FactoryMultiView.selfCalibThree(configSelfcalib);
        ModelManagerMetricCameraTriple manager = new ModelManagerMetricCameraTriple();
        DistanceFromModelIntoViews distance = new DistanceFromModelIntoViews(new DistanceMetricTripleReprojection23(), 3);
        return new LeastMedianOfSquaresProjective<MetricCameraTriple, AssociatedTriple>(configLMedS.randSeed, configLMedS.totalCycles, Double.MAX_VALUE, configLMedS.errorFraction, manager, generator, distance);
    }

    public static <Model, Point> LeastMedianOfSquares<Model, Point> createLMEDS(ConfigLMedS configLMedS, ModelManager<Model> manager, Class<Point> pointType) {
        LeastMedianOfSquares_MT alg = BoofConcurrency.isUseConcurrent() ? new LeastMedianOfSquares_MT(configLMedS.randSeed, configLMedS.totalCycles, manager, pointType) : new LeastMedianOfSquares(configLMedS.randSeed, configLMedS.totalCycles, manager, pointType);
        alg.setErrorFraction(configLMedS.errorFraction);
        return alg;
    }

    public static <Model, Point> Ransac<Model, Point> createRansac(ConfigRansac configRansac, double ransacTol, ModelManager<Model> manager, Class<Point> pointType) {
        return BoofConcurrency.isUseConcurrent() ? new Ransac_MT(configRansac.randSeed, configRansac.iterations, ransacTol, manager, pointType) : new Ransac(configRansac.randSeed, configRansac.iterations, ransacTol, manager, pointType);
    }
}

