/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.bundle;

import boofcv.struct.geo.PointIndex2D_F64;
import georegression.struct.point.Point2D_F64;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F32;
import org.ddogleg.struct.DogArray_I32;

public class SceneObservations {
    public final DogArray<View> views = new DogArray(View::new, View::reset);
    public final DogArray<View> viewsRigid = new DogArray(View::new, View::reset);

    public void initialize(int numViews) {
        this.initialize(numViews, false);
    }

    public void initialize(int numViews, boolean rigidObjects) {
        this.views.reset().resize(numViews);
        if (rigidObjects) {
            this.viewsRigid.reset().resize(numViews);
        }
    }

    public int getObservationCount() {
        return this.countObservations(this.viewsRigid) + this.countObservations(this.views);
    }

    private int countObservations(DogArray<View> views) {
        if (views == null) {
            return 0;
        }
        int total = 0;
        for (int i = 0; i < views.size; ++i) {
            total += ((View[])views.data)[i].point.size;
        }
        return total;
    }

    public boolean hasRigid() {
        return this.views.size != 0 && this.views.size == this.viewsRigid.size;
    }

    public View getView(int which) {
        return ((View[])this.views.data)[which];
    }

    public View getViewRigid(int which) {
        return ((View[])this.viewsRigid.data)[which];
    }

    public void checkOneObservationPerView() {
        for (int viewIdx = 0; viewIdx < this.views.size; ++viewIdx) {
            View v = ((View[])this.views.data)[viewIdx];
            for (int obsIdx = 0; obsIdx < v.size(); ++obsIdx) {
                int a = v.point.get(obsIdx);
                for (int i = obsIdx + 1; i < v.size(); ++i) {
                    if (a != v.point.get(i)) continue;
                    throw new RuntimeException("Same point is viewed more than once in the same view");
                }
            }
        }
    }

    public boolean isIdentical(SceneObservations other) {
        int i;
        if (this.views.size != other.views.size) {
            return false;
        }
        if (this.viewsRigid.size != other.viewsRigid.size) {
            return false;
        }
        for (i = 0; i < this.views.size; ++i) {
            if (((View)this.views.get(i)).isIdentical((View)other.views.get(i))) continue;
            return false;
        }
        for (i = 0; i < this.viewsRigid.size; ++i) {
            if (((View)this.viewsRigid.get(i)).isIdentical((View)other.viewsRigid.get(i))) continue;
            return false;
        }
        return true;
    }

    public static class View {
        public DogArray_I32 point = new DogArray_I32();
        public DogArray_F32 observations = new DogArray_F32();

        public int size() {
            return this.point.size;
        }

        public void remove(int index) {
            this.point.remove(index);
            this.observations.remove(index *= 2, index + 1);
        }

        public void safeAssignToFeature(int index, int featureIdx) {
            if (this.point.contains(featureIdx)) {
                throw new IllegalArgumentException("Feature has already been assigned to an observation");
            }
            if (-1 != this.point.get(index)) {
                throw new IllegalArgumentException("Observation is already assigned a feature");
            }
            this.point.set(index, featureIdx);
        }

        public void set(int index, int featureIdx, float x, float y) {
            this.point.set(index, featureIdx);
            this.observations.data[index *= 2] = x;
            this.observations.data[index + 1] = y;
        }

        public void setPixel(int index, float x, float y) {
            this.observations.data[index *= 2] = x;
            this.observations.data[index + 1] = y;
        }

        public int getPointId(int index) {
            return this.point.get(index);
        }

        public void getPixel(int index, Point2D_F64 p) {
            if (index >= this.point.size) {
                throw new IndexOutOfBoundsException(index + " >= " + this.point.size);
            }
            p.x = this.observations.data[index *= 2];
            p.y = this.observations.data[index + 1];
        }

        public void getPixel(int index, PointIndex2D_F64 observation) {
            if (index >= this.point.size) {
                throw new IndexOutOfBoundsException(index + " >= " + this.point.size);
            }
            observation.index = this.point.data[index];
            ((Point2D_F64)observation.p).setTo((double)this.observations.data[index *= 2], (double)this.observations.data[index + 1]);
        }

        public void add(int featureIndex, float x, float y) {
            this.point.add(featureIndex);
            this.observations.add(x);
            this.observations.add(y);
        }

        public void checkDuplicatePoints() {
            for (int i = 0; i < this.point.size; ++i) {
                int pa = this.point.get(i);
                for (int j = i + 1; j < this.point.size; ++j) {
                    if (pa != this.point.get(j)) continue;
                    throw new RuntimeException("Duplicates");
                }
            }
        }

        public void reset() {
            this.point.reset();
            this.observations.reset();
        }

        public void resize(int numPoints) {
            this.point.reset().resize(numPoints, -1);
            this.observations.reset().resize(numPoints * 2, -1.0f);
        }

        public boolean isIdentical(View other) {
            if (!this.point.isEquals(other.point)) {
                return false;
            }
            return this.observations.isEquals(other.observations);
        }
    }
}

