/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import boofcv.struct.geo.PointIndex2D_F64;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CalibrationObservation {
    public int target;
    public List<PointIndex2D_F64> points = new ArrayList<PointIndex2D_F64>();

    public void setTo(CalibrationObservation obs) {
        this.reset();
        this.target = obs.target;
        for (int i = 0; i < obs.size(); ++i) {
            PointIndex2D_F64 p = obs.points.get(i);
            this.points.add(p.copy());
        }
    }

    public PointIndex2D_F64 get(int index) {
        return this.points.get(index);
    }

    public void add(int which, Point2D_F64 observation) {
        this.points.add(new PointIndex2D_F64(observation.x, observation.y, which));
    }

    public void add(int which, double x, double y) {
        this.points.add(new PointIndex2D_F64(x, y, which));
    }

    public void reset() {
        this.target = 0;
        this.points.clear();
    }

    public void sort() {
        boolean ordered = true;
        for (int i = 1; i < this.points.size(); ++i) {
            if (this.points.get((int)(i - 1)).index < this.points.get((int)i).index) continue;
            ordered = false;
            break;
        }
        if (ordered) {
            return;
        }
        Collections.sort(this.points, Comparator.comparingInt(o -> o.index));
    }

    public int size() {
        return this.points.size();
    }

    public CalibrationObservation copy() {
        CalibrationObservation c = new CalibrationObservation();
        c.setTo(this);
        return c;
    }

    public int getTarget() {
        return this.target;
    }

    public List<PointIndex2D_F64> getPoints() {
        return this.points;
    }
}

