/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.triangulate;

import boofcv.alg.geo.GeometricResult;
import boofcv.alg.geo.LowLevelMultiViewOps;
import boofcv.alg.geo.NormalizationPoint2D;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point4D_F64;
import java.util.Arrays;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.linsol.svd.SolveNullSpaceSvd_DDRM;

public class TriangulateProjectiveLinearDLT {
    private final SolveNullSpaceSvd_DDRM solverNull = new SolveNullSpaceSvd_DDRM();
    private final DMatrixRMaj nullspace = new DMatrixRMaj(4, 1);
    private final DMatrixRMaj A = new DMatrixRMaj(4, 4);
    public double singularThreshold = 1.0;
    final NormalizationPoint2D stats = new NormalizationPoint2D();

    public GeometricResult triangulate(List<Point2D_F64> observations, List<DMatrixRMaj> cameraMatrices, Point4D_F64 found) {
        if (observations.size() != cameraMatrices.size()) {
            throw new IllegalArgumentException("Number of observations must match the number of motions");
        }
        LowLevelMultiViewOps.computeNormalization(observations, this.stats);
        int N = cameraMatrices.size();
        this.A.reshape(2 * N, 4);
        int index = 0;
        for (int i = 0; i < N; ++i) {
            index = this.addView(cameraMatrices.get(i), observations.get(i), index);
        }
        if (!this.solverNull.process(this.A, 1, this.nullspace)) {
            return GeometricResult.SOLVE_FAILED;
        }
        double[] sv = this.solverNull.getSingularValues();
        Arrays.sort(sv);
        if (sv[1] * this.singularThreshold <= sv[0]) {
            return GeometricResult.GEOMETRY_POOR;
        }
        double[] ns = this.nullspace.data;
        found.x = ns[0];
        found.y = ns[1];
        found.z = ns[2];
        found.w = ns[3];
        return GeometricResult.SUCCESS;
    }

    private int addView(DMatrixRMaj P, Point2D_F64 a, int index) {
        double sx = this.stats.stdX;
        double sy = this.stats.stdY;
        double r11 = P.data[0];
        double r12 = P.data[1];
        double r13 = P.data[2];
        double r14 = P.data[3];
        double r21 = P.data[4];
        double r22 = P.data[5];
        double r23 = P.data[6];
        double r24 = P.data[7];
        double r31 = P.data[8];
        double r32 = P.data[9];
        double r33 = P.data[10];
        double r34 = P.data[11];
        this.A.data[index++] = (a.x * r31 - r11) / sx;
        this.A.data[index++] = (a.x * r32 - r12) / sx;
        this.A.data[index++] = (a.x * r33 - r13) / sx;
        this.A.data[index++] = (a.x * r34 - r14) / sx;
        this.A.data[index++] = (a.y * r31 - r21) / sy;
        this.A.data[index++] = (a.y * r32 - r22) / sy;
        this.A.data[index++] = (a.y * r33 - r23) / sy;
        this.A.data[index++] = (a.y * r34 - r24) / sy;
        return index;
    }

    public double getSingularThreshold() {
        return this.singularThreshold;
    }

    public void setSingularThreshold(double singularThreshold) {
        this.singularThreshold = singularThreshold;
    }
}

