/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.bundle;

import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.abst.geo.bundle.SceneStructureProjective;
import boofcv.alg.geo.NormalizationPoint2D;
import boofcv.alg.geo.PerspectiveOps;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import org.ddogleg.sorting.QuickSelect;
import org.ddogleg.struct.DogArray;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class ScaleSceneStructure {
    double desiredDistancePoint = 100.0;
    Point3D_F64 medianPoint = new Point3D_F64();
    double medianDistancePoint;
    boolean scalePixelsUsingStats = true;
    public DogArray<NormalizationPoint2D> pixelScaling = new DogArray(NormalizationPoint2D::new);

    public ScaleSceneStructure(double desiredDistancePoint) {
        this.desiredDistancePoint = desiredDistancePoint;
    }

    public ScaleSceneStructure() {
    }

    public void applyScale(SceneStructureMetric structure, SceneObservations observations) {
        if (structure.homogenous) {
            this.applyScaleToPointsHomogenous(structure);
        } else {
            this.computePointStatistics((DogArray<SceneStructureCommon.Point>)structure.points);
            this.applyScaleToPoints3D(structure);
            this.applyScaleTranslation3D(structure);
        }
    }

    public void applyScale(SceneStructureProjective structure, SceneObservations observations) {
        if (structure.homogenous) {
            this.applyScaleToPointsHomogenous(structure);
        } else {
            this.computePointStatistics((DogArray<SceneStructureCommon.Point>)structure.points);
            this.applyScaleToPoints3D(structure);
            this.applyScaleTranslation3D(structure);
        }
        this.computePixelScaling(structure, observations);
        this.applyScaleToPixelsAndCameraMatrix(structure, observations);
    }

    void computePixelScaling(SceneStructureProjective structure, SceneObservations observations) {
        this.pixelScaling.reset();
        if (this.scalePixelsUsingStats) {
            for (int viewIdx = 0; viewIdx < structure.views.size; ++viewIdx) {
                SceneObservations.View so = (SceneObservations.View)observations.views.get(viewIdx);
                int N = so.size();
                double meanX = 0.0;
                double meanY = 0.0;
                int idx = 0;
                for (int i = 0; i < N; ++i) {
                    meanX += (double)so.observations.data[idx++];
                    meanY += (double)so.observations.data[idx++];
                }
                meanX /= (double)N;
                meanY /= (double)N;
                double stdX = 0.0;
                double stdY = 0.0;
                int idx2 = 0;
                for (int i = 0; i < N; ++i) {
                    double dx = meanX - (double)so.observations.data[idx2++];
                    double dy = meanY - (double)so.observations.data[idx2++];
                    stdX += dx * dx;
                    stdY += dy * dy;
                }
                stdX = Math.sqrt(stdX / (double)N);
                stdY = Math.sqrt(stdY / (double)N);
                ((NormalizationPoint2D)this.pixelScaling.grow()).set(meanX, stdX, meanY, stdY);
            }
        } else {
            for (int viewIdx = 0; viewIdx < structure.views.size; ++viewIdx) {
                SceneStructureProjective.View sv = ((SceneStructureProjective.View[])structure.views.data)[viewIdx];
                if (sv.width <= 0 || sv.height <= 0) {
                    throw new IllegalArgumentException("View width and height is unknown. Scale with statistics instead");
                }
                ((NormalizationPoint2D)this.pixelScaling.grow()).set(sv.width / 2, sv.width / 2, sv.height / 2, sv.height / 2);
            }
        }
    }

    public void applyScaleToPixelsAndCameraMatrix(SceneStructureProjective structure, SceneObservations observations) {
        for (int viewIdx = 0; viewIdx < structure.views.size; ++viewIdx) {
            NormalizationPoint2D n = (NormalizationPoint2D)this.pixelScaling.get(viewIdx);
            float cx = (float)n.meanX;
            float cy = (float)n.meanY;
            float stdX = (float)n.stdX;
            float stdY = (float)n.stdY;
            SceneStructureProjective.View v = ((SceneStructureProjective.View[])structure.views.data)[viewIdx];
            SceneObservations.View ov = (SceneObservations.View)observations.views.get(viewIdx);
            for (int pixelIdx = 0; pixelIdx < ov.size(); ++pixelIdx) {
                int i = pixelIdx * 2;
                float x = ov.observations.data[i];
                float y = ov.observations.data[i + 1];
                ov.observations.data[i] = (x - cx) / stdX;
                ov.observations.data[i + 1] = (y - cy) / stdY;
            }
            n.apply(v.worldToView, v.worldToView);
        }
    }

    public void undoScaleToPixelsAndCameraMatrix(SceneStructureProjective structure, SceneObservations observations) {
        for (int viewIdx = 0; viewIdx < structure.views.size; ++viewIdx) {
            NormalizationPoint2D n = (NormalizationPoint2D)this.pixelScaling.get(viewIdx);
            float cx = (float)n.meanX;
            float cy = (float)n.meanY;
            float stdX = (float)n.stdX;
            float stdY = (float)n.stdY;
            SceneStructureProjective.View v = ((SceneStructureProjective.View[])structure.views.data)[viewIdx];
            SceneObservations.View ov = (SceneObservations.View)observations.views.get(viewIdx);
            for (int pixelIdx = 0; pixelIdx < ov.size(); ++pixelIdx) {
                int i = pixelIdx * 2;
                float x = ov.observations.data[i];
                float y = ov.observations.data[i + 1];
                ov.observations.data[i] = x * stdX + cx;
                ov.observations.data[i + 1] = y * stdY + cy;
            }
            n.remove(v.worldToView, v.worldToView);
        }
    }

    void computePointStatistics(DogArray<SceneStructureCommon.Point> points) {
        int length = points.size;
        double[] v = new double[length];
        block5: for (int axis = 0; axis < 3; ++axis) {
            double maxAbs = 0.0;
            for (int i = 0; i < length; ++i) {
                v[i] = ((SceneStructureCommon.Point)points.get((int)i)).coordinate[axis];
                maxAbs = Math.max(maxAbs, Math.abs(v[i]));
            }
            double median = QuickSelect.select((double[])v, (int)(length / 2), (int)length);
            switch (axis) {
                case 0: {
                    this.medianPoint.x = median;
                    continue block5;
                }
                case 1: {
                    this.medianPoint.y = median;
                    continue block5;
                }
                case 2: {
                    this.medianPoint.z = median;
                }
            }
        }
        for (int i = 0; i < length; ++i) {
            v[i] = ((SceneStructureCommon.Point)points.get(i)).distanceSq(this.medianPoint);
        }
        this.medianDistancePoint = Math.sqrt(QuickSelect.select((double[])v, (int)(length / 2), (int)length));
    }

    private void applyScaleTranslation3D(SceneStructureProjective structure) {
        double scale = this.desiredDistancePoint / this.medianDistancePoint;
        DMatrixRMaj A = new DMatrixRMaj(3, 3);
        DMatrixRMaj A_inv = new DMatrixRMaj(3, 3);
        Point3D_F64 a = new Point3D_F64();
        Point3D_F64 c = new Point3D_F64();
        for (int i = 0; i < structure.views.size; ++i) {
            SceneStructureProjective.View view = ((SceneStructureProjective.View[])structure.views.data)[i];
            CommonOps_DDRM.extract((DMatrix)view.worldToView, (int)0, (int)0, (DMatrix)A);
            PerspectiveOps.extractColumn(view.worldToView, 3, a);
            CommonOps_DDRM.invert((DMatrixRMaj)A, (DMatrixRMaj)A_inv);
            GeometryMath_F64.mult((DMatrixRMaj)A_inv, (GeoTuple3D_F64)a, (GeoTuple3D_F64)c);
            c.x = -scale * (c.x + this.medianPoint.x);
            c.y = -scale * (c.y + this.medianPoint.y);
            c.z = -scale * (c.z + this.medianPoint.z);
            GeometryMath_F64.mult((DMatrixRMaj)A, (GeoTuple3D_F64)c, (GeoTuple3D_F64)a);
            a.scale(-1.0);
            PerspectiveOps.insertColumn(view.worldToView, 3, a);
        }
    }

    public void undoScale(SceneStructureMetric structure, SceneObservations observations) {
        if (structure.homogenous) {
            return;
        }
        double scale = this.desiredDistancePoint / this.medianDistancePoint;
        this.undoNormPoints3D(structure, scale);
        Point3D_F64 c = new Point3D_F64();
        for (int i = 0; i < structure.motions.size; ++i) {
            SceneStructureMetric.Motion motion = ((SceneStructureMetric.Motion[])structure.motions.data)[i];
            GeometryMath_F64.multTran((DMatrixRMaj)motion.parent_to_view.R, (GeoTuple3D_F64)motion.parent_to_view.T, (GeoTuple3D_F64)c);
            c.x = -c.x / scale + this.medianPoint.x;
            c.y = -c.y / scale + this.medianPoint.y;
            c.z = -c.z / scale + this.medianPoint.z;
            GeometryMath_F64.mult((DMatrixRMaj)motion.parent_to_view.R, (GeoTuple3D_F64)c, (GeoTuple3D_F64)motion.parent_to_view.T);
            motion.parent_to_view.T.scale(-1.0);
        }
    }

    public void undoScale(SceneStructureProjective structure, SceneObservations observations) {
        if (!structure.homogenous) {
            double scale = this.desiredDistancePoint / this.medianDistancePoint;
            this.undoNormPoints3D(structure, scale);
            DMatrixRMaj A = new DMatrixRMaj(3, 3);
            DMatrixRMaj A_inv = new DMatrixRMaj(3, 3);
            Point3D_F64 a = new Point3D_F64();
            Point3D_F64 c = new Point3D_F64();
            for (int i = 0; i < structure.views.size; ++i) {
                SceneStructureProjective.View view = ((SceneStructureProjective.View[])structure.views.data)[i];
                CommonOps_DDRM.extract((DMatrix)view.worldToView, (int)0, (int)0, (DMatrix)A);
                PerspectiveOps.extractColumn(view.worldToView, 3, a);
                CommonOps_DDRM.invert((DMatrixRMaj)A, (DMatrixRMaj)A_inv);
                GeometryMath_F64.mult((DMatrixRMaj)A_inv, (GeoTuple3D_F64)a, (GeoTuple3D_F64)c);
                c.x = -c.x / scale + this.medianPoint.x;
                c.y = -c.y / scale + this.medianPoint.y;
                c.z = -c.z / scale + this.medianPoint.z;
                GeometryMath_F64.mult((DMatrixRMaj)A, (GeoTuple3D_F64)c, (GeoTuple3D_F64)a);
                a.scale(-1.0);
                PerspectiveOps.insertColumn(view.worldToView, 3, a);
            }
        }
        this.undoScaleToPixelsAndCameraMatrix(structure, observations);
    }

    private void undoNormPoints3D(SceneStructureCommon structure, double scale) {
        for (int i = 0; i < structure.points.size; ++i) {
            SceneStructureCommon.Point p = ((SceneStructureCommon.Point[])structure.points.data)[i];
            p.coordinate[0] = p.coordinate[0] / scale + this.medianPoint.x;
            p.coordinate[1] = p.coordinate[1] / scale + this.medianPoint.y;
            p.coordinate[2] = p.coordinate[2] / scale + this.medianPoint.z;
        }
    }

    private void applyScaleTranslation3D(SceneStructureMetric structure) {
        double scale = this.desiredDistancePoint / this.medianDistancePoint;
        Point3D_F64 c = new Point3D_F64();
        for (int i = 0; i < structure.motions.size; ++i) {
            SceneStructureMetric.Motion motion = ((SceneStructureMetric.Motion[])structure.motions.data)[i];
            GeometryMath_F64.multTran((DMatrixRMaj)motion.parent_to_view.R, (GeoTuple3D_F64)motion.parent_to_view.T, (GeoTuple3D_F64)c);
            c.x = -scale * (c.x + this.medianPoint.x);
            c.y = -scale * (c.y + this.medianPoint.y);
            c.z = -scale * (c.z + this.medianPoint.z);
            GeometryMath_F64.mult((DMatrixRMaj)motion.parent_to_view.R, (GeoTuple3D_F64)c, (GeoTuple3D_F64)motion.parent_to_view.T);
            motion.parent_to_view.T.scale(-1.0);
        }
    }

    void applyScaleToPoints3D(SceneStructureCommon structure) {
        double scale = this.desiredDistancePoint / this.medianDistancePoint;
        for (int i = 0; i < structure.points.size; ++i) {
            SceneStructureCommon.Point p = ((SceneStructureCommon.Point[])structure.points.data)[i];
            p.coordinate[0] = scale * (p.coordinate[0] - this.medianPoint.x);
            p.coordinate[1] = scale * (p.coordinate[1] - this.medianPoint.y);
            p.coordinate[2] = scale * (p.coordinate[2] - this.medianPoint.z);
        }
    }

    void applyScaleToPointsHomogenous(SceneStructureCommon structure) {
        Point4D_F64 p = new Point4D_F64();
        for (int i = 0; i < structure.points.size; ++i) {
            ((SceneStructureCommon.Point[])structure.points.data)[i].get(p);
            p.normalize();
            ((SceneStructureCommon.Point[])structure.points.data)[i].set(p.x, p.y, p.z, p.w);
        }
    }

    public boolean isScalePixelsUsingStats() {
        return this.scalePixelsUsingStats;
    }

    public void setScalePixelsUsingStats(boolean scalePixelsUsingStats) {
        this.scalePixelsUsingStats = scalePixelsUsingStats;
    }
}

