/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.triangulate;

import boofcv.abst.geo.TriangulateNViewsMetric;
import boofcv.alg.geo.GeometricResult;
import boofcv.alg.geo.triangulate.TriangulateMetricLinearDLT;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import java.util.List;

public class WrapNViewsTriangulateMetricDLT
implements TriangulateNViewsMetric {
    final TriangulateMetricLinearDLT algorithm = new TriangulateMetricLinearDLT();
    final Point4D_F64 pointH = new Point4D_F64();

    @Override
    public boolean triangulate(List<Point2D_F64> observations, List<Se3_F64> listWorldToView, Point3D_F64 location) {
        if (GeometricResult.SUCCESS == this.algorithm.triangulate(observations, listWorldToView, this.pointH)) {
            if (this.pointH.w == 0.0) {
                return false;
            }
            location.x = this.pointH.x / this.pointH.w;
            location.y = this.pointH.y / this.pointH.w;
            location.z = this.pointH.z / this.pointH.w;
            return true;
        }
        return false;
    }

    public TriangulateMetricLinearDLT getAlgorithm() {
        return this.algorithm;
    }

    public Point4D_F64 getPointH() {
        return this.pointH;
    }
}

