/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle.jacobians;

import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import org.ddogleg.optimization.derivative.NumericalJacobianForward_DDRM;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;

public class BundleCameraNumericJacobian {
    BundleAdjustmentCamera model;
    private final double[] X = new double[3];
    double[] intrinsic = new double[0];
    int numIntrinsic;
    private FunctionNtoMxN<DMatrixRMaj> numericalPoint;
    private FunctionNtoMxN<DMatrixRMaj> numericalIntrinsic;
    private final FunctionOfPoint funcPoint = new FunctionOfPoint();
    private final FunctionOfIntrinsic funcIntrinsic = new FunctionOfIntrinsic();
    private final DMatrixRMaj jacobian = new DMatrixRMaj(1, 1);
    private final Point2D_F64 p = new Point2D_F64();

    public void setModel(BundleAdjustmentCamera model) {
        this.model = model;
        this.numIntrinsic = model.getIntrinsicCount();
        if (this.numIntrinsic > this.intrinsic.length) {
            this.intrinsic = new double[this.numIntrinsic];
        }
        model.getIntrinsic(this.intrinsic, 0);
        this.numericalPoint = this.createNumericalAlgorithm(this.funcPoint);
        this.numericalIntrinsic = this.createNumericalAlgorithm(this.funcIntrinsic);
    }

    protected FunctionNtoMxN<DMatrixRMaj> createNumericalAlgorithm(FunctionNtoM function) {
        return new NumericalJacobianForward_DDRM(function);
    }

    public void jacobianPoint(double camX, double camY, double camZ, double[] pointX, double[] pointY) {
        this.funcPoint.setParameters(this.intrinsic);
        this.X[0] = camX;
        this.X[1] = camY;
        this.X[2] = camZ;
        this.jacobian.reshape(2, 3);
        this.numericalPoint.process(this.X, (DMatrix)this.jacobian);
        for (int i = 0; i < 3; ++i) {
            pointX[i] = this.jacobian.data[i];
            pointY[i] = this.jacobian.data[i + 3];
        }
    }

    public void jacobianIntrinsics(double camX, double camY, double camZ, double[] calibX, double[] calibY) {
        this.funcIntrinsic.X.setTo(camX, camY, camZ);
        this.jacobian.reshape(2, this.numIntrinsic);
        this.numericalIntrinsic.process(this.intrinsic, (DMatrix)this.jacobian);
        for (int i = 0; i < this.numIntrinsic; ++i) {
            calibX[i] = this.jacobian.data[i];
            calibY[i] = this.jacobian.data[i + this.numIntrinsic];
        }
        this.model.setIntrinsic(this.intrinsic, 0);
    }

    private class FunctionOfPoint
    implements FunctionNtoM {
        private FunctionOfPoint() {
        }

        public void setParameters(double[] parameters) {
            BundleCameraNumericJacobian.this.model.setIntrinsic(parameters, 0);
        }

        public void process(double[] input, double[] output) {
            BundleCameraNumericJacobian.this.model.project(input[0], input[1], input[2], BundleCameraNumericJacobian.this.p);
            output[0] = BundleCameraNumericJacobian.this.p.x;
            output[1] = BundleCameraNumericJacobian.this.p.y;
        }

        public int getNumOfInputsN() {
            return 3;
        }

        public int getNumOfOutputsM() {
            return 2;
        }
    }

    private class FunctionOfIntrinsic
    implements FunctionNtoM {
        Point3D_F64 X = new Point3D_F64();

        private FunctionOfIntrinsic() {
        }

        public void process(double[] input, double[] output) {
            BundleCameraNumericJacobian.this.model.setIntrinsic(input, 0);
            BundleCameraNumericJacobian.this.model.project(this.X.x, this.X.y, this.X.z, BundleCameraNumericJacobian.this.p);
            output[0] = BundleCameraNumericJacobian.this.p.x;
            output[1] = BundleCameraNumericJacobian.this.p.y;
        }

        public int getNumOfInputsN() {
            return BundleCameraNumericJacobian.this.model.getIntrinsicCount();
        }

        public int getNumOfOutputsM() {
            return 2;
        }
    }
}

