/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ConfigLength;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Rectangle2D_I32;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_B;

public class ScoreCalibrationFill {
    public final ConfigLength borderExtent = ConfigLength.relative((double)0.04, (double)5.0);
    public int regionsBorder = 15;
    public int regionsInner = 10;
    double scoreBorder;
    double scoreInner;
    final DogArray_B occupiedBorder = new DogArray_B();
    final DogArray_B occupiedInner = new DogArray_B();
    public int actualBorderPx;
    public final DogArray<RegionInfo> unoccupiedRegions = new DogArray(RegionInfo::new, RegionInfo::reset);
    protected int imageWidth;
    protected int imageHeight;
    protected int innerWidth;
    protected int innerHeight;

    public void initialize(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Image width or height can't be zero or less. " + width + "x" + height);
        }
        this.imageWidth = width;
        this.imageHeight = height;
        this.scoreBorder = 0.0;
        this.scoreInner = 0.0;
        this.actualBorderPx = BoofMiscOps.thresholdByImageSizeI((ConfigLength)this.borderExtent, (int)width, (int)height);
        this.occupiedBorder.reset().resize(this.regionsBorder * 4, false);
        this.occupiedInner.reset().resize(this.regionsInner * this.regionsInner, false);
        this.innerWidth = this.imageWidth - this.actualBorderPx * 2;
        this.innerHeight = this.imageHeight - this.actualBorderPx * 2;
    }

    public void addObservation(CalibrationObservation obs) {
        if (this.imageWidth <= 0) {
            throw new IllegalArgumentException("You must call initialize first.");
        }
        for (int obsIdx = 0; obsIdx < obs.size(); ++obsIdx) {
            Point2D_F64 o = (Point2D_F64)obs.get((int)obsIdx).p;
            if (this.isNearBorder(o.x, o.y, this.imageWidth, this.imageHeight)) {
                int index;
                if (o.y <= (double)this.actualBorderPx) {
                    index = (int)((double)this.regionsBorder * o.x / (double)this.imageWidth);
                } else if (o.y >= (double)(this.imageHeight - this.actualBorderPx)) {
                    index = (int)((double)this.regionsBorder * o.x / (double)this.imageWidth) + this.regionsBorder * 2;
                } else {
                    double adjY = o.y - (double)this.actualBorderPx;
                    index = (int)((double)this.regionsBorder * adjY / (double)this.innerHeight);
                    index = o.x >= (double)(this.imageWidth - this.actualBorderPx) ? (index += this.regionsBorder) : (index += this.regionsBorder * 3);
                }
                this.occupiedBorder.set(index, true);
                continue;
            }
            int row = (int)((double)this.regionsInner * (o.y - (double)this.actualBorderPx) / (double)this.innerHeight);
            int col = (int)((double)this.regionsInner * (o.x - (double)this.actualBorderPx) / (double)this.innerWidth);
            int index = row * this.regionsInner + col;
            this.occupiedInner.set(index, true);
        }
        this.scoreBorder = (double)this.occupiedBorder.count(true) / (double)this.occupiedBorder.size;
        this.scoreInner = (double)this.occupiedInner.count(true) / (double)this.occupiedInner.size;
    }

    public void updateUnoccupied() {
        this.unoccupiedRegions.reset();
        this.findUnoccupiedTop();
        this.findUnoccupiedRight();
        this.findUnoccupiedBottom();
        this.findUnoccupiedLeft();
        this.findUnoccupiedInner();
    }

    private void findUnoccupiedTop() {
        for (int i = 0; i < this.regionsBorder; ++i) {
            if (this.occupiedBorder.get(i)) continue;
            RegionInfo r = (RegionInfo)this.unoccupiedRegions.grow();
            r.inner = false;
            r.region.x0 = i * this.imageWidth / this.regionsBorder;
            r.region.x1 = (i + 1) * this.imageWidth / this.regionsBorder;
            r.region.y0 = 0;
            r.region.y1 = this.actualBorderPx;
        }
    }

    private void findUnoccupiedRight() {
        for (int i = this.regionsBorder; i < 2 * this.regionsBorder; ++i) {
            if (this.occupiedBorder.get(i)) continue;
            RegionInfo r = (RegionInfo)this.unoccupiedRegions.grow();
            r.inner = false;
            int loc = i - this.regionsBorder;
            r.region.x0 = this.imageWidth - this.actualBorderPx;
            r.region.x1 = this.imageWidth;
            r.region.y0 = this.actualBorderPx + loc * this.innerHeight / this.regionsBorder;
            r.region.y1 = this.actualBorderPx + (loc + 1) * this.innerHeight / this.regionsBorder;
        }
    }

    private void findUnoccupiedBottom() {
        for (int i = 2 * this.regionsBorder; i < 3 * this.regionsBorder; ++i) {
            if (this.occupiedBorder.get(i)) continue;
            RegionInfo r = (RegionInfo)this.unoccupiedRegions.grow();
            r.inner = false;
            int loc = i - 2 * this.regionsBorder;
            r.region.x0 = loc * this.imageWidth / this.regionsBorder;
            r.region.x1 = (loc + 1) * this.imageWidth / this.regionsBorder;
            r.region.y0 = this.imageHeight - this.actualBorderPx;
            r.region.y1 = this.imageHeight;
        }
    }

    private void findUnoccupiedLeft() {
        for (int i = 3 * this.regionsBorder; i < 4 * this.regionsBorder; ++i) {
            if (this.occupiedBorder.get(i)) continue;
            RegionInfo r = (RegionInfo)this.unoccupiedRegions.grow();
            r.inner = false;
            int loc = i - this.regionsBorder * 3;
            r.region.x0 = 0;
            r.region.x1 = this.actualBorderPx;
            r.region.y0 = this.actualBorderPx + loc * this.innerHeight / this.regionsBorder;
            r.region.y1 = this.actualBorderPx + (loc + 1) * this.innerHeight / this.regionsBorder;
        }
    }

    private void findUnoccupiedInner() {
        for (int i = 0; i < this.occupiedInner.size; ++i) {
            if (this.occupiedInner.get(i)) continue;
            int row = i / this.regionsInner;
            int col = i % this.regionsInner;
            RegionInfo r = (RegionInfo)this.unoccupiedRegions.grow();
            r.inner = true;
            r.region.x0 = this.actualBorderPx + col * this.innerWidth / this.regionsInner;
            r.region.x1 = this.actualBorderPx + (col + 1) * this.innerWidth / this.regionsInner;
            r.region.y0 = this.actualBorderPx + row * this.innerHeight / this.regionsInner;
            r.region.y1 = this.actualBorderPx + (row + 1) * this.innerHeight / this.regionsInner;
        }
    }

    boolean isNearBorder(double x, double y, int width, int height) {
        if (x <= (double)this.actualBorderPx || (double)width - x <= (double)this.actualBorderPx) {
            return true;
        }
        return y <= (double)this.actualBorderPx || (double)height - y <= (double)this.actualBorderPx;
    }

    public ConfigLength getBorderExtent() {
        return this.borderExtent;
    }

    public int getRegionsBorder() {
        return this.regionsBorder;
    }

    public void setRegionsBorder(int regionsBorder) {
        this.regionsBorder = regionsBorder;
    }

    public int getRegionsInner() {
        return this.regionsInner;
    }

    public void setRegionsInner(int regionsInner) {
        this.regionsInner = regionsInner;
    }

    public double getScoreBorder() {
        return this.scoreBorder;
    }

    public double getScoreInner() {
        return this.scoreInner;
    }

    public DogArray<RegionInfo> getUnoccupiedRegions() {
        return this.unoccupiedRegions;
    }

    public static class RegionInfo {
        public boolean inner;
        public Rectangle2D_I32 region = new Rectangle2D_I32();

        public void reset() {
            this.inner = false;
            this.region.zero();
        }

        public RegionInfo setTo(RegionInfo src) {
            this.inner = src.inner;
            this.region.setTo(src.region);
            return this;
        }
    }
}

