/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.bundle;

import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.abst.geo.bundle.BundleCameraState;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.misc.BoofMiscOps;
import georegression.struct.GeoTuple_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.Objects;
import org.ddogleg.struct.DogArray;
import org.jetbrains.annotations.Nullable;

public class SceneStructureMetric
extends SceneStructureCommon {
    public final DogArray<View> views = new DogArray(View::new, View::reset);
    public final DogArray<Motion> motions = new DogArray(Motion::new, Motion::reset);
    public final DogArray<Rigid> rigids = new DogArray(Rigid::new);
    public int[] lookupRigid = new int[0];

    public SceneStructureMetric(boolean homogenous) {
        super(homogenous);
    }

    public void initialize(int totalCameras, int totalViews, int totalPoints) {
        this.initialize(totalCameras, totalViews, totalViews, totalPoints, 0);
    }

    public void initialize(int totalCameras, int totalViews, int totalMotions, int totalPoints, int totalRigid) {
        this.motions.resize(totalMotions).reset();
        this.cameras.reset().resize(totalCameras);
        this.views.reset().resize(totalViews);
        this.points.reset().resize(totalPoints);
        this.rigids.reset().resize(totalRigid);
        this.lookupRigid = new int[0];
    }

    public void assignIDsToRigidPoints() {
        if (this.lookupRigid.length != 0) {
            return;
        }
        this.lookupRigid = new int[this.getTotalRigidPoints()];
        int pointID = 0;
        for (int i = 0; i < this.rigids.size; ++i) {
            Rigid r = ((Rigid[])this.rigids.data)[i];
            r.indexFirst = pointID;
            int j = 0;
            while (j < r.points.length) {
                this.lookupRigid[pointID] = i;
                ++j;
                ++pointID;
            }
        }
    }

    public Se3_F64 getParentToView(View view) {
        return ((Motion)this.motions.get((int)view.parent_to_view)).parent_to_view;
    }

    public Se3_F64 getParentToView(int viewIdx) {
        View v = (View)this.views.get(viewIdx);
        return ((Motion)this.motions.get((int)v.parent_to_view)).parent_to_view;
    }

    public Se3_F64 getWorldToView(View view, @Nullable Se3_F64 world_to_view, @Nullable Se3_F64 tmp) {
        if (world_to_view == null) {
            world_to_view = new Se3_F64();
        }
        if (tmp == null) {
            tmp = new Se3_F64();
        }
        world_to_view.setTo(this.getParentToView(view));
        while (view.parent != null) {
            view = view.parent;
            Se3_F64 parent_to_view = this.getParentToView(view);
            parent_to_view.concat(world_to_view, tmp);
            world_to_view.setTo(tmp);
        }
        return world_to_view;
    }

    public Se3_F64 getViewToView(View view1, View view2) {
        Se3_F64 world_to_view1 = new Se3_F64();
        Se3_F64 world_to_view2 = new Se3_F64();
        Se3_F64 tmp = new Se3_F64();
        this.getWorldToView(view1, world_to_view1, tmp);
        this.getWorldToView(view2, world_to_view2, tmp);
        world_to_view1.invertConcat(world_to_view2, tmp);
        return tmp;
    }

    public Se3_F64 getViewToView(int view1, int view2) {
        return this.getViewToView((View)this.views.get(view1), (View)this.views.get(view2));
    }

    public boolean hasRigid() {
        return this.rigids.size > 0;
    }

    public void setView(int viewIndex, int cameraIndex, boolean known, Se3_F64 world_to_view) {
        ((View)this.views.get((int)viewIndex)).camera = cameraIndex;
        ((View)this.views.get((int)viewIndex)).parent_to_view = this.addMotion(known, world_to_view);
        ((View)this.views.get((int)viewIndex)).parent = null;
    }

    public void setView(int viewIndex, int cameraIndex, boolean known, Se3_F64 parent_to_view, int parent) {
        BoofMiscOps.checkTrue((parent < viewIndex ? 1 : 0) != 0, (String)"Parent must be less than viewIndex");
        ((View)this.views.get((int)viewIndex)).camera = cameraIndex;
        ((View)this.views.get((int)viewIndex)).parent_to_view = this.addMotion(known, parent_to_view);
        ((View)this.views.get((int)viewIndex)).parent = parent >= 0 ? (View)this.views.get(parent) : null;
    }

    public void setView(int viewIndex, int cameraIndex, int motionIndex, int parent) {
        BoofMiscOps.checkTrue((parent < viewIndex ? 1 : 0) != 0, (String)"Parent must be less than viewIndex");
        ((View)this.views.get((int)viewIndex)).camera = cameraIndex;
        ((View)this.views.get((int)viewIndex)).parent_to_view = motionIndex;
        ((View)this.views.get((int)viewIndex)).parent = parent >= 0 ? (View)this.views.get(parent) : null;
    }

    public int addMotion(boolean known, Se3_F64 parentToView) {
        int index = this.motions.size;
        Motion m = (Motion)this.motions.grow();
        m.known = known;
        m.parent_to_view.setTo(parentToView);
        return index;
    }

    public void setRigid(int which, boolean known, Se3_F64 worldToObject, int totalPoints) {
        Rigid r = ((Rigid[])this.rigids.data)[which];
        r.init(totalPoints, this.pointSize);
        r.known = known;
        r.object_to_world.setTo(worldToObject);
    }

    public void connectViewToCamera(int viewIndex, int cameraIndex) {
        if (((View)this.views.get((int)viewIndex)).camera != -1) {
            throw new RuntimeException("View has already been assigned a camera");
        }
        ((View)this.views.get((int)viewIndex)).camera = cameraIndex;
    }

    public int getUnknownCameraCount() {
        int total = 0;
        for (int i = 0; i < this.cameras.size; ++i) {
            if (((SceneStructureCommon.Camera[])this.cameras.data)[i].known) continue;
            ++total;
        }
        return total;
    }

    public int getUnknownMotionCount() {
        int total = 0;
        for (int i = 0; i < this.motions.size; ++i) {
            if (((Motion)this.motions.get((int)i)).known) continue;
            ++total;
        }
        return total;
    }

    public int getUnknownRigidCount() {
        int total = 0;
        for (int i = 0; i < this.rigids.size; ++i) {
            if (((Rigid[])this.rigids.data)[i].known) continue;
            ++total;
        }
        return total;
    }

    public int getTotalRigidPoints() {
        int total = 0;
        for (int i = 0; i < this.rigids.size; ++i) {
            total += ((Rigid[])this.rigids.data)[i].points.length;
        }
        return total;
    }

    public boolean projectToPixel(int pointIdx, int viewIdx, @Nullable BundleCameraState cameraState, Se3_F64 world_to_view, Se3_F64 tmpSE, Point3D_F64 tmpX, Point2D_F64 pixel) {
        View view = (View)this.views.get(viewIdx);
        this.getWorldToView(view, world_to_view, tmpSE);
        SceneStructureCommon.Point p = (SceneStructureCommon.Point)this.points.get(pointIdx);
        double x = p.coordinate[0];
        double y = p.coordinate[1];
        double z = p.coordinate[2];
        double w = this.homogenous ? p.coordinate[3] : 1.0;
        BundleAdjustmentCamera camera = Objects.requireNonNull(this.getViewCamera((View)view).model);
        if (cameraState != null) {
            camera.setCameraState(cameraState);
        }
        SePointOps_F64.transformV((Se3_F64)world_to_view, (double)x, (double)y, (double)z, (double)w, (Point3D_F64)tmpX);
        camera.project(tmpX.x, tmpX.y, tmpX.z, pixel);
        return z * w > 0.0;
    }

    public SceneStructureCommon.Camera getViewCamera(View v) {
        return (SceneStructureCommon.Camera)this.cameras.get(v.camera);
    }

    public SceneStructureCommon.Camera getViewCamera(int viewIdx) {
        return (SceneStructureCommon.Camera)this.cameras.get(((View)this.views.get((int)viewIdx)).camera);
    }

    @Override
    public int getParameterCount() {
        return this.getUnknownMotionCount() * 6 + this.getUnknownRigidCount() * 6 + this.points.size * this.pointSize + this.getUnknownCameraParameterCount();
    }

    public Rigid getRigid(int rigidIdx) {
        return (Rigid)this.rigids.get(rigidIdx);
    }

    public boolean isIdentical(SceneStructureMetric m, double tol) {
        int i;
        if (this.isHomogenous() != m.isHomogenous()) {
            return false;
        }
        if (this.views.size != m.views.size) {
            return false;
        }
        if (this.motions.size != m.motions.size) {
            return false;
        }
        if (this.rigids.size != m.rigids.size) {
            return false;
        }
        if (this.cameras.size != m.cameras.size) {
            return false;
        }
        if (this.points.size != m.points.size) {
            return false;
        }
        for (i = 0; i < this.views.size; ++i) {
            if (((View)this.views.get(i)).isIdentical((View)m.views.get(i))) continue;
            return false;
        }
        for (i = 0; i < this.motions.size; ++i) {
            if (((Motion)this.motions.get(i)).isIdentical((Motion)m.motions.get(i), tol)) continue;
            return false;
        }
        for (i = 0; i < this.rigids.size; ++i) {
            if (((Rigid)this.rigids.get(i)).isIdentical((Rigid)m.rigids.get(i), tol)) continue;
            return false;
        }
        for (i = 0; i < this.cameras.size; ++i) {
            if (((SceneStructureCommon.Camera)this.cameras.get(i)).isIdentical((SceneStructureCommon.Camera)m.cameras.get(i), tol)) continue;
            return false;
        }
        for (i = 0; i < this.points.size; ++i) {
            if (!(((SceneStructureCommon.Point)this.points.get(i)).distance((SceneStructureCommon.Point)m.points.get(i)) > tol)) continue;
            return false;
        }
        return true;
    }

    public DogArray<View> getViews() {
        return this.views;
    }

    public DogArray<Motion> getMotions() {
        return this.motions;
    }

    public DogArray<Rigid> getRigids() {
        return this.rigids;
    }

    public static class Rigid {
        public boolean known;
        public final Se3_F64 object_to_world = new Se3_F64();
        public SceneStructureCommon.Point[] points = new SceneStructureCommon.Point[0];
        public int indexFirst;

        public void init(int numPoints, int dof) {
            this.known = false;
            this.object_to_world.reset();
            this.indexFirst = -1;
            if (this.points.length != numPoints) {
                this.points = new SceneStructureCommon.Point[numPoints];
            }
            if (this.points.length > 0 && (this.points[0] == null || this.points[0].coordinate.length != numPoints)) {
                for (int i = 0; i < numPoints; ++i) {
                    this.points[i] = new SceneStructureCommon.Point(dof);
                }
            }
        }

        public void connectPointToView(int pointIdx, int viewIdx) {
            if (this.points[pointIdx].views.contains(viewIdx)) {
                throw new IllegalArgumentException("Tried to add the same view twice. viewIndex=" + viewIdx);
            }
            this.points[pointIdx].views.add(viewIdx);
        }

        public void connectPointToView(int pointIdx, int viewIdx, float pixX, float pixY, SceneObservations sceneObs) {
            BoofMiscOps.checkTrue((this.indexFirst >= 0 ? 1 : 0) != 0, (String)"Please call scene.assignIDsToRigidPoints() first");
            sceneObs.getViewRigid(viewIdx).add(this.indexFirst + pointIdx, pixX, pixY);
            this.connectPointToView(pointIdx, viewIdx);
        }

        public void setPoint(int which, double x, double y, double z) {
            this.points[which].set(x, y, z);
        }

        public void setPoint(int which, double x, double y, double z, double w) {
            this.points[which].set(x, y, z, w);
        }

        public void getPoint(int which, Point3D_F64 p) {
            this.points[which].get(p);
        }

        public void getPoint(int which, Point4D_F64 p) {
            this.points[which].get(p);
        }

        public int getTotalPoints() {
            return this.points.length;
        }

        public boolean isIdentical(Rigid m, double tol) {
            if (this.known != m.known) {
                return false;
            }
            if (this.indexFirst != m.indexFirst) {
                return false;
            }
            if (this.points != null) {
                if (m.points == null) {
                    return false;
                }
                if (this.points.length != m.points.length) {
                    return false;
                }
                for (int i = 0; i < this.points.length; ++i) {
                    if (!(this.points[i].distance(m.points[i]) > tol)) continue;
                    return false;
                }
            } else {
                return m.points == null;
            }
            return true;
        }
    }

    public static class View {
        public int parent_to_view = -1;
        public int camera = -1;
        @Nullable
        public View parent;

        public void reset() {
            this.parent_to_view = -1;
            this.camera = -1;
            this.parent = null;
        }

        public boolean isIdentical(View m) {
            if (this.parent_to_view != m.parent_to_view) {
                return false;
            }
            if (this.camera != m.camera) {
                return false;
            }
            if (this.parent == null) {
                return m.parent == null;
            }
            return m.parent != null;
        }
    }

    public static class Motion {
        public boolean known;
        public final Se3_F64 parent_to_view = new Se3_F64();

        public void reset() {
            this.known = true;
            this.parent_to_view.reset();
        }

        public boolean isIdentical(Motion m, double tol) {
            if (this.known != m.known) {
                return false;
            }
            if (this.parent_to_view.T.distance((GeoTuple_F64)m.parent_to_view.T) > tol) {
                return false;
            }
            for (int i = 0; i < 9; ++i) {
                if (!(Math.abs(this.parent_to_view.R.data[i] - m.parent_to_view.R.data[i]) > tol)) continue;
                return false;
            }
            return true;
        }
    }
}

