/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.universal;

import boofcv.alg.distort.brown.RadialTangential_F64;
import boofcv.struct.calib.CameraUniversalOmni;
import boofcv.struct.distort.Point3Transform2_F64;
import georegression.struct.point.Point2D_F64;

public class UniOmniStoP_F64
implements Point3Transform2_F64 {
    double mirrorOffset;
    protected double cx;
    protected double cy;
    protected double fx;
    protected double fy;
    protected double skew;
    protected RadialTangential_F64 distortion = new RadialTangential_F64();

    public UniOmniStoP_F64(CameraUniversalOmni model) {
        this.setModel(model);
    }

    public UniOmniStoP_F64() {
    }

    public void setModel(CameraUniversalOmni model) {
        this.mirrorOffset = model.mirrorOffset;
        this.distortion.setTo(model.radial, model.t1, model.t2);
        this.cx = model.cx;
        this.cy = model.cy;
        this.fx = model.fx;
        this.fy = model.fy;
        this.skew = model.skew;
    }

    public void compute(double x, double y, double z, Point2D_F64 out) {
        double r2;
        double[] radial = this.distortion.radial;
        double t1 = this.distortion.t1;
        double t2 = this.distortion.t2;
        double ri2 = r2 = (x /= (z += this.mirrorOffset)) * x + (y /= z) * y;
        double sum = 0.0;
        for (int i = 0; i < radial.length; ++i) {
            sum += radial[i] * ri2;
            ri2 *= r2;
        }
        double dx = x * (1.0 + sum) + 2.0 * t1 * x * y + t2 * (r2 + 2.0 * x * x);
        double dy = y * (1.0 + sum) + t1 * (r2 + 2.0 * y * y) + 2.0 * t2 * x * y;
        out.x = this.fx * dx + this.skew * dy + this.cx;
        out.y = this.fy * dy + this.cy;
    }

    public Point3Transform2_F64 copyConcurrent() {
        UniOmniStoP_F64 c = new UniOmniStoP_F64();
        c.distortion = new RadialTangential_F64(this.distortion);
        c.mirrorOffset = this.mirrorOffset;
        c.cx = this.cx;
        c.cy = this.cy;
        c.fx = this.fx;
        c.fy = this.fy;
        c.skew = this.skew;
        return c;
    }
}

