/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.calibration;

import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public interface DetectMultiFiducialCalibration {
    public void process(GrayF32 var1);

    public int getDetectionCount();

    public int getTotalUniqueMarkers();

    public CalibrationObservation getDetectedPoints(int var1);

    public List<Point2D_F64> getLayout(int var1);

    default public List<List<Point2D_F64>> getLayouts() {
        ArrayList<List<Point2D_F64>> list = new ArrayList<List<Point2D_F64>>();
        for (int i = 0; i < this.getTotalUniqueMarkers(); ++i) {
            list.add(this.getLayout(i));
        }
        return list;
    }

    default public List<CalibrationObservation> getBestForEachTarget() {
        HashMap<Integer, CalibrationObservation> markerToObservations = new HashMap<Integer, CalibrationObservation>();
        for (int i = 0; i < this.getDetectionCount(); ++i) {
            CalibrationObservation o = this.getDetectedPoints(i);
            CalibrationObservation previousBest = (CalibrationObservation)markerToObservations.get(o.target);
            if (previousBest != null && previousBest.size() >= o.size()) continue;
            markerToObservations.put(o.target, o);
        }
        return new ArrayList<CalibrationObservation>(markerToObservations.values());
    }

    public void setLensDistortion(@Nullable LensDistortionNarrowFOV var1, int var2, int var3);
}

