/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle;

import boofcv.abst.geo.bundle.BundleAdjustmentSchur;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.geo.bundle.CodecSceneStructureMetric;
import boofcv.struct.geo.PointIndex2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.ddogleg.struct.DogArray;

public class BundleAdjustmentMetricResidualFunction
implements BundleAdjustmentSchur.FunctionResiduals<SceneStructureMetric> {
    private SceneStructureMetric structure;
    private SceneObservations observations;
    private final Point3D_F64 worldPt = new Point3D_F64();
    private final Point4D_F64 worldPt4 = new Point4D_F64();
    private int numParameters;
    private int numObservations;
    private final Point3D_F64 cameraPt = new Point3D_F64();
    private final Point2D_F64 predictedPixel = new Point2D_F64();
    private final PointIndex2D_F64 observedPixel = new PointIndex2D_F64();
    private final CodecSceneStructureMetric codec = new CodecSceneStructureMetric();
    private final DogArray<Se3_F64> storageSe3 = new DogArray(Se3_F64::new);
    private final Map<SceneStructureMetric.View, Se3_F64> mapWorldToView = new HashMap<SceneStructureMetric.View, Se3_F64>();
    private final Point3D_F64 p3 = new Point3D_F64();
    private final Point4D_F64 p4 = new Point4D_F64();

    @Override
    public void configure(SceneStructureMetric structure, SceneObservations observations) {
        this.structure = structure;
        this.observations = observations;
        this.numObservations = observations.getObservationCount();
        this.numParameters = structure.getParameterCount();
        structure.assignIDsToRigidPoints();
        this.mapWorldToView.clear();
        this.storageSe3.reset();
        for (int viewIdx = 0; viewIdx < structure.views.size; ++viewIdx) {
            SceneStructureMetric.View v = (SceneStructureMetric.View)structure.views.get(viewIdx);
            if (v.parent == null) continue;
            Se3_F64 world_to_view = (Se3_F64)this.storageSe3.grow();
            this.mapWorldToView.put(v, world_to_view);
        }
    }

    public int getNumOfInputsN() {
        return this.numParameters;
    }

    public int getNumOfOutputsM() {
        return this.numObservations * 2;
    }

    public void process(double[] input, double[] output) {
        this.codec.decode(input, this.structure);
        if (this.structure.isHomogenous()) {
            this.project4(output);
        } else {
            this.project3(output);
        }
    }

    public void process(double[] output) {
        if (this.structure.isHomogenous()) {
            this.project4(output);
        } else {
            this.project3(output);
        }
    }

    private void project3(double[] output) {
        int observationIndex = 0;
        for (int viewIndex = 0; viewIndex < this.structure.views.size; ++viewIndex) {
            int i;
            SceneStructureMetric.View view = (SceneStructureMetric.View)this.structure.views.get(viewIndex);
            SceneStructureCommon.Camera camera = (SceneStructureCommon.Camera)this.structure.cameras.get(view.camera);
            Se3_F64 world_to_view = this.lookupWorldToView(view);
            SceneObservations.View obsView = (SceneObservations.View)this.observations.views.get(viewIndex);
            if (obsView.cameraState != null) {
                camera.model.setCameraState(obsView.cameraState);
            }
            for (i = 0; i < obsView.size(); ++i) {
                obsView.getPixel(i, this.observedPixel);
                SceneStructureCommon.Point worldPt = ((SceneStructureCommon.Point[])this.structure.points.data)[this.observedPixel.index];
                worldPt.get(this.p3);
                SePointOps_F64.transform((Se3_F64)world_to_view, (Point3D_F64)this.p3, (Point3D_F64)this.cameraPt);
                camera.model.project(this.cameraPt.x, this.cameraPt.y, this.cameraPt.z, this.predictedPixel);
                int outputIndex = observationIndex * 2;
                output[outputIndex] = this.predictedPixel.x - ((Point2D_F64)this.observedPixel.p).x;
                output[outputIndex + 1] = this.predictedPixel.y - ((Point2D_F64)this.observedPixel.p).y;
                ++observationIndex;
            }
            if (!this.observations.hasRigid()) continue;
            obsView = (SceneObservations.View)this.observations.viewsRigid.get(viewIndex);
            if (obsView.cameraState != null) {
                camera.model.setCameraState(obsView.cameraState);
            }
            for (i = 0; i < obsView.size(); ++i) {
                obsView.getPixel(i, this.observedPixel);
                int rigidIndex = this.structure.lookupRigid[this.observedPixel.index];
                SceneStructureMetric.Rigid rigid = (SceneStructureMetric.Rigid)this.structure.rigids.get(rigidIndex);
                int pointIndex = this.observedPixel.index - rigid.indexFirst;
                SceneStructureCommon.Point objectPt = rigid.points[pointIndex];
                objectPt.get(this.p3);
                SePointOps_F64.transform((Se3_F64)rigid.object_to_world, (Point3D_F64)this.p3, (Point3D_F64)this.worldPt);
                SePointOps_F64.transform((Se3_F64)world_to_view, (Point3D_F64)this.worldPt, (Point3D_F64)this.cameraPt);
                camera.model.project(this.cameraPt.x, this.cameraPt.y, this.cameraPt.z, this.predictedPixel);
                int outputIndex = observationIndex * 2;
                output[outputIndex] = this.predictedPixel.x - ((Point2D_F64)this.observedPixel.p).x;
                output[outputIndex + 1] = this.predictedPixel.y - ((Point2D_F64)this.observedPixel.p).y;
                ++observationIndex;
            }
        }
    }

    private void project4(double[] output) {
        int observationIndex = 0;
        for (int viewIndex = 0; viewIndex < this.structure.views.size; ++viewIndex) {
            int i;
            SceneStructureMetric.View view = (SceneStructureMetric.View)this.structure.views.get(viewIndex);
            SceneStructureCommon.Camera camera = (SceneStructureCommon.Camera)this.structure.cameras.get(view.camera);
            Se3_F64 world_to_view = this.lookupWorldToView(view);
            SceneObservations.View obsView = (SceneObservations.View)this.observations.views.get(viewIndex);
            if (obsView.cameraState != null) {
                camera.model.setCameraState(obsView.cameraState);
            }
            for (i = 0; i < obsView.size(); ++i) {
                obsView.getPixel(i, this.observedPixel);
                SceneStructureCommon.Point worldPt = ((SceneStructureCommon.Point[])this.structure.points.data)[this.observedPixel.index];
                worldPt.get(this.p4);
                SePointOps_F64.transformV((Se3_F64)world_to_view, (Point4D_F64)this.p4, (Point3D_F64)this.cameraPt);
                camera.model.project(this.cameraPt.x, this.cameraPt.y, this.cameraPt.z, this.predictedPixel);
                int outputIndex = observationIndex * 2;
                output[outputIndex] = this.predictedPixel.x - ((Point2D_F64)this.observedPixel.p).x;
                output[outputIndex + 1] = this.predictedPixel.y - ((Point2D_F64)this.observedPixel.p).y;
                ++observationIndex;
            }
            if (!this.observations.hasRigid()) continue;
            obsView = (SceneObservations.View)this.observations.viewsRigid.get(viewIndex);
            if (obsView.cameraState != null) {
                camera.model.setCameraState(obsView.cameraState);
            }
            for (i = 0; i < obsView.size(); ++i) {
                obsView.getPixel(i, this.observedPixel);
                int rigidIndex = this.structure.lookupRigid[this.observedPixel.index];
                SceneStructureMetric.Rigid rigid = (SceneStructureMetric.Rigid)this.structure.rigids.get(rigidIndex);
                int pointIndex = this.observedPixel.index - rigid.indexFirst;
                SceneStructureCommon.Point objectPt = rigid.points[pointIndex];
                objectPt.get(this.p4);
                SePointOps_F64.transform((Se3_F64)rigid.object_to_world, (Point4D_F64)this.p4, (Point4D_F64)this.worldPt4);
                SePointOps_F64.transformV((Se3_F64)world_to_view, (Point4D_F64)this.worldPt4, (Point3D_F64)this.cameraPt);
                camera.model.project(this.cameraPt.x, this.cameraPt.y, this.cameraPt.z, this.predictedPixel);
                int outputIndex = observationIndex * 2;
                output[outputIndex] = this.predictedPixel.x - ((Point2D_F64)this.observedPixel.p).x;
                output[outputIndex + 1] = this.predictedPixel.y - ((Point2D_F64)this.observedPixel.p).y;
                ++observationIndex;
            }
        }
    }

    protected Se3_F64 lookupWorldToView(SceneStructureMetric.View v) {
        Se3_F64 parent_to_view = this.structure.getParentToView(v);
        if (v.parent == null) {
            return parent_to_view;
        }
        Se3_F64 world_to_view = Objects.requireNonNull(this.mapWorldToView.get(v));
        SceneStructureMetric.View parentView = v.parent;
        if (parentView.parent == null) {
            Se3_F64 world_to_parent = Objects.requireNonNull(this.structure.getParentToView(v.parent));
            world_to_parent.concat(parent_to_view, world_to_view);
        } else {
            Se3_F64 world_to_parent = Objects.requireNonNull(this.mapWorldToView.get(v.parent));
            world_to_parent.concat(parent_to_view, world_to_view);
        }
        return world_to_view;
    }
}

