/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.calibration;

import boofcv.abst.geo.bundle.MetricBundleAdjustmentUtils;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.abst.geo.calibration.CalibrateMonoPlanar;
import boofcv.abst.geo.calibration.CalibrationQuality;
import boofcv.abst.geo.calibration.ImageResults;
import boofcv.alg.geo.WorldToCameraToPixel;
import boofcv.alg.geo.bundle.BundleAdjustmentOps;
import boofcv.alg.geo.bundle.cameras.BundlePinholeBrown;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.geo.calibration.CalibrationObservationSet;
import boofcv.alg.geo.calibration.ScoreCalibrationFill;
import boofcv.alg.geo.calibration.SynchronizedCalObs;
import boofcv.factory.geo.ConfigBundleAdjustment;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.calib.MultiCameraCalibParams;
import boofcv.struct.geo.PointIndex2D_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.AverageRotationMatrix_F64;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ddogleg.optimization.ConfigLoss;
import org.ddogleg.optimization.ConfigNonLinearLeastSquares;
import org.ddogleg.stats.StatisticsDogArray;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F64;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastArray;
import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class CalibrateMultiPlanar {
    final CalibrateMonoPlanar calibratorMono = new CalibrateMonoPlanar();
    MetricBundleAdjustmentUtils bundleUtils = new MetricBundleAdjustmentUtils(null, false);
    MultiCameraCalibParams results = new MultiCameraCalibParams();
    DogArray<CameraStatistics> statistics = new DogArray(CameraStatistics::new, CameraStatistics::reset);
    final FastArray<List<Point2D_F64>> layouts = new FastArray(ArrayList.class);
    final DogArray<CameraPriors> cameras = new DogArray(CameraPriors::new);
    final List<SynchronizedCalObs> frameObs = new ArrayList<SynchronizedCalObs>();
    final DogArray<FrameState> frames = new DogArray(FrameState::new, FrameState::reset);
    protected double[] summaryThresholds = new double[]{0.25, 0.5, 1.0, 2.0, 3.0, 5.0, 7.5, 10.0, 20.0, 50.0};

    public void initialize(int numCameras, int numTargets) {
        this.statistics.reset().resize(numCameras);
        this.results.reset();
        this.layouts.resize(numTargets);
        this.cameras.reset().resize(numCameras);
        for (int i = 0; i < this.cameras.size; ++i) {
            ((CameraPriors)this.cameras.get((int)i)).index = i;
            this.results.camerasToSensor.add(new Se3_F64());
        }
        this.frameObs.clear();
        ConfigBundleAdjustment configSBA = new ConfigBundleAdjustment();
        configSBA.optimizer.type = ConfigNonLinearLeastSquares.Type.LEVENBERG_MARQUARDT;
        configSBA.optimizer.lm.hessianScaling = false;
        configSBA.optimizer.robustSolver = false;
        configSBA.loss.type = ConfigLoss.Type.HUBER;
        configSBA.loss.parameter = 10.0;
        this.bundleUtils.sba = FactoryMultiView.bundleSparseMetric(configSBA);
    }

    public void setCameraProperties(int which, int width, int height) {
        ((CameraPriors)this.cameras.get((int)which)).width = width;
        ((CameraPriors)this.cameras.get((int)which)).height = height;
    }

    public void setTargetLayout(int which, List<Point2D_F64> layout) {
        this.layouts.set(which, layout);
    }

    public void setTargetLayouts(List<List<Point2D_F64>> layouts) {
        this.layouts.clear();
        this.layouts.addAll(layouts);
    }

    public void addObservation(SynchronizedCalObs observations) {
        this.frameObs.add(observations);
    }

    public boolean process() {
        this.frames.reset().resize(this.frameObs.size());
        this.monocularCalibration();
        this.estimateCameraToSensor();
        this.estimateSensorToWorldInAllFrames();
        this.setupSbaScene();
        if (!this.bundleUtils.process()) {
            return false;
        }
        this.sbaToOutput();
        this.computeReprojectionErrors();
        return true;
    }

    void monocularCalibration() {
        ScoreCalibrationFill fillScore = new ScoreCalibrationFill();
        DogArray_I32 monoViewToInputFrame = new DogArray_I32();
        for (int cameraIdx = 0; cameraIdx < this.cameras.size; ++cameraIdx) {
            monoViewToInputFrame.reset();
            CameraPriors c = (CameraPriors)this.cameras.get(cameraIdx);
            this.calibratorMono.initialize(c.width, c.height, this.layouts.toList());
            block1: for (int frameIdx = 0; frameIdx < this.frameObs.size(); ++frameIdx) {
                SynchronizedCalObs synch = this.frameObs.get(frameIdx);
                for (int frameCamIdx = 0; frameCamIdx < synch.cameras.size; ++frameCamIdx) {
                    CalibrationObservationSet os = (CalibrationObservationSet)synch.cameras.get(frameCamIdx);
                    if (os.cameraID != c.index) continue;
                    for (int targetIdx = 0; targetIdx < os.targets.size; ++targetIdx) {
                        this.calibratorMono.addImage((CalibrationObservation)os.targets.get(targetIdx));
                        monoViewToInputFrame.add(frameIdx);
                    }
                    continue block1;
                }
            }
            this.results.getIntrinsics().add((CameraModel)this.calibratorMono.process());
            CalibrateMonoPlanar.computeQuality(this.calibratorMono.foundIntrinsic, fillScore, this.layouts.toList(), this.calibratorMono.observations, ((CameraStatistics)this.statistics.get((int)cameraIdx)).quality);
            for (int monoViewIdx = 0; monoViewIdx < monoViewToInputFrame.size(); ++monoViewIdx) {
                int frameID = monoViewToInputFrame.get(monoViewIdx);
                CalibrationObservationSet os = this.frameObs.get(frameID).findCamera(c.index);
                Objects.requireNonNull(os, "BUG!");
                FrameState frame = (FrameState)this.frames.get(frameID);
                FrameCamera cam = (FrameCamera)frame.cameras.get(cameraIdx);
                if (cam == null) {
                    cam = new FrameCamera();
                    frame.cameras.put(cameraIdx, (Object)cam);
                }
                CalibrationObservation calObs = this.calibratorMono.getObservations().get(monoViewIdx);
                TargetExtrinsics target = new TargetExtrinsics();
                target.targetID = calObs.target;
                target.targetToCamera.setTo(this.calibratorMono.getTargetToView(monoViewIdx));
                cam.observations.add(target);
            }
        }
    }

    void estimateCameraToSensor() {
        ArrayList<CameraPriors> known = new ArrayList<CameraPriors>();
        ArrayList<CameraPriors> unknown = new ArrayList<CameraPriors>();
        for (int i = 1; i < this.cameras.size; ++i) {
            unknown.add((CameraPriors)this.cameras.get(i));
        }
        known.add((CameraPriors)this.cameras.get(0));
        while (!unknown.isEmpty()) {
            boolean change = false;
            block2: for (int unknownIdx = unknown.size() - 1; unknownIdx >= 0; --unknownIdx) {
                CameraPriors unknownCam = (CameraPriors)unknown.get(unknownIdx);
                for (int frameIdx = 0; frameIdx < this.frames.size(); ++frameIdx) {
                    FrameState frame = (FrameState)this.frames.get(frameIdx);
                    for (int knownIdx = 0; knownIdx < known.size(); ++knownIdx) {
                        CameraPriors knownCam = (CameraPriors)known.get(knownIdx);
                        Se3_F64 camI_to_sensor = this.extrinsicFromKnownCamera(frame, knownCam.index, unknownCam.index);
                        if (camI_to_sensor == null) continue;
                        this.results.camerasToSensor.get(unknownCam.index).setTo(camI_to_sensor);
                        change = true;
                        unknown.remove(unknownIdx);
                        known.add(unknownCam);
                        continue block2;
                    }
                }
            }
            if (change) continue;
            break;
        }
        if (!unknown.isEmpty()) {
            throw new RuntimeException("Not all cameras have known extrinsics");
        }
    }

    Se3_F64 estimateWorldToTarget(int targetID) {
        DogArray listTargetToWorld = new DogArray(Se3_F64::new);
        Se3_F64 targetToSensor = new Se3_F64();
        for (int frameIdx = 0; frameIdx < this.frames.size(); ++frameIdx) {
            FrameState frame = (FrameState)this.frames.get(frameIdx);
            frame.cameras.forEachEntry((cameraID, frameCamera) -> {
                for (int obsIdx = 0; obsIdx < frameCamera.observations.size(); ++obsIdx) {
                    TargetExtrinsics t = frameCamera.observations.get(obsIdx);
                    if (t.targetID != targetID) continue;
                    t.targetToCamera.concat(this.results.camerasToSensor.get(cameraID), targetToSensor);
                    targetToSensor.concat(frame.sensorToWorld, (Se3_F64)listTargetToWorld.grow());
                }
                return true;
            });
        }
        return CalibrateMultiPlanar.computeAverageSe3(listTargetToWorld.toList());
    }

    static Se3_F64 computeAverageSe3(List<Se3_F64> listTargetToWorld) {
        if (listTargetToWorld.isEmpty()) {
            return new Se3_F64();
        }
        Se3_F64 average = new Se3_F64();
        for (int i = 0; i < listTargetToWorld.size(); ++i) {
            average.T.plusIP((GeoTuple3D_F64)listTargetToWorld.get((int)i).T);
        }
        average.T.divideIP((double)listTargetToWorld.size());
        ArrayList<DMatrixRMaj> listR = new ArrayList<DMatrixRMaj>();
        for (int i = 0; i < listTargetToWorld.size(); ++i) {
            listR.add(listTargetToWorld.get((int)i).R);
        }
        if (!new AverageRotationMatrix_F64().process(listR, average.R)) {
            throw new RuntimeException("Average rotation computation failed");
        }
        return average;
    }

    void estimateSensorToWorldInAllFrames() {
        for (int frameIdx = 0; frameIdx < this.frames.size(); ++frameIdx) {
            FrameState f = (FrameState)this.frames.get(frameIdx);
            boolean found = false;
            for (int camIdx = 0; camIdx < this.cameras.size; ++camIdx) {
                int obsIdx;
                FrameCamera fc = (FrameCamera)f.cameras.get(camIdx);
                if (fc == null || (obsIdx = 0) >= fc.observations.size()) continue;
                TargetExtrinsics te = fc.observations.get(obsIdx);
                Se3_F64 cameraToTarget = te.targetToCamera.invert(null);
                this.results.getCameraToSensor(camIdx).invertConcat(cameraToTarget, f.sensorToWorld);
                found = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException("This frame should be removed");
        }
    }

    void setupSbaScene() {
        int frameIdx;
        SceneStructureMetric structure = this.bundleUtils.getStructure();
        SceneObservations observations = this.bundleUtils.getObservations();
        int totalViews = this.frames.size() * this.cameras.size;
        int totalMotions = this.cameras.size;
        structure.initialize(this.cameras.size, totalViews, totalMotions, 0, this.layouts.size);
        for (int i = 0; i < this.cameras.size; ++i) {
            structure.setCamera(i, false, (CameraPinholeBrown)this.results.getIntrinsics().get(i));
        }
        for (int camIdx = 0; camIdx < this.cameras.size; ++camIdx) {
            structure.addMotion(camIdx == 0, this.results.getCameraToSensor(camIdx).invert(null));
        }
        for (int layoutID = 0; layoutID < this.layouts.size(); ++layoutID) {
            List layout = (List)this.layouts.get(layoutID);
            structure.setRigid(layoutID, false, this.estimateWorldToTarget(layoutID), layout.size());
            SceneStructureMetric.Rigid srigid = (SceneStructureMetric.Rigid)structure.rigids.get(layoutID);
            for (int i = 0; i < layout.size(); ++i) {
                srigid.setPoint(i, ((Point2D_F64)layout.get((int)i)).x, ((Point2D_F64)layout.get((int)i)).y, 0.0);
            }
        }
        structure.assignIDsToRigidPoints();
        int viewIdx = 0;
        for (frameIdx = 0; frameIdx < this.frames.size(); ++frameIdx) {
            int cameraZeroIdx = viewIdx;
            Se3_F64 worldToSensor = ((FrameState)this.frames.get((int)frameIdx)).sensorToWorld.invert(null);
            structure.setView(viewIdx++, 0, false, worldToSensor);
            for (int camIdx = 1; camIdx < this.cameras.size; ++camIdx) {
                structure.setView(viewIdx++, camIdx, camIdx, cameraZeroIdx);
            }
        }
        observations.initialize(totalViews, true);
        for (frameIdx = 0; frameIdx < this.frameObs.size(); ++frameIdx) {
            SynchronizedCalObs f = this.frameObs.get(frameIdx);
            for (int camIdx = 0; camIdx < f.cameras.size; ++camIdx) {
                CalibrationObservationSet c = (CalibrationObservationSet)f.cameras.get(camIdx);
                int sbaViewIndex = frameIdx * this.cameras.size + c.cameraID;
                for (int targetIdx = 0; targetIdx < c.targets.size; ++targetIdx) {
                    CalibrationObservation obs = (CalibrationObservation)c.targets.get(targetIdx);
                    SceneStructureMetric.Rigid srigid = (SceneStructureMetric.Rigid)structure.rigids.get(obs.target);
                    for (int featIdx = 0; featIdx < obs.size(); ++featIdx) {
                        PointIndex2D_F64 p = obs.get(featIdx);
                        srigid.connectPointToView(p.index, sbaViewIndex, (float)((Point2D_F64)p.p).x, (float)((Point2D_F64)p.p).y, observations);
                    }
                }
            }
        }
    }

    void sbaToOutput() {
        SceneStructureMetric structure = this.bundleUtils.getStructure();
        for (int camIdx = 0; camIdx < this.cameras.size; ++camIdx) {
            CameraPriors c = (CameraPriors)this.cameras.get(camIdx);
            BundlePinholeBrown bb = (BundlePinholeBrown)structure.getCameraModel(camIdx);
            BundleAdjustmentOps.convert(bb, c.width, c.height, (CameraPinholeBrown)this.results.intrinsics.get(camIdx));
            ((SceneStructureMetric.Motion)structure.motions.get((int)camIdx)).parent_to_view.invert(this.results.camerasToSensor.get(camIdx));
        }
    }

    void computeReprojectionErrors() {
        SceneStructureMetric structure = this.bundleUtils.getStructure();
        WorldToCameraToPixel w2p = new WorldToCameraToPixel();
        Point3D_F64 targetPt = new Point3D_F64();
        Point3D_F64 worldPt = new Point3D_F64();
        Point2D_F64 predictedPixel = new Point2D_F64();
        DogArray_F64 errors = new DogArray_F64();
        for (int camIdx = 0; camIdx < this.cameras.size; ++camIdx) {
            CameraPinholeBrown intrinsics = (CameraPinholeBrown)this.results.intrinsics.get(camIdx);
            Se3_F64 cameraToSensor = this.results.getCameraToSensor(camIdx);
            double overallMean = 0.0;
            double overallMax = 0.0;
            int totalFrames = 0;
            for (int frameIdx = 0; frameIdx < this.frameObs.size(); ++frameIdx) {
                CalibrationObservation camObs;
                CalibrationObservationSet camSet = this.frameObs.get(frameIdx).findCamera(camIdx);
                if (camSet == null || (camObs = camSet.findTarget(0)) == null) continue;
                ++totalFrames;
                Se3_F64 worldToSensor = ((SceneStructureMetric.Motion)structure.motions.get((int)(this.cameras.size + frameIdx))).parent_to_view;
                Se3_F64 worldToCamera = worldToSensor.concat(cameraToSensor.invert(null), null);
                w2p.configure(intrinsics, worldToCamera);
                Se3_F64 targetToWorld = structure.getRigid((int)camObs.target).object_to_world;
                List layout = (List)this.layouts.get(camObs.target);
                ImageResults imageStats = new ImageResults(camObs.points.size());
                ((CameraStatistics)this.statistics.get((int)camIdx)).residuals.add(imageStats);
                errors.reset();
                double sumX = 0.0;
                double sumY = 0.0;
                for (int obsIdx = 0; obsIdx < camObs.points.size(); ++obsIdx) {
                    double reprojectionError;
                    PointIndex2D_F64 o = camObs.points.get(obsIdx);
                    Point2D_F64 landmarkX = (Point2D_F64)layout.get(o.index);
                    targetPt.x = landmarkX.x;
                    targetPt.y = landmarkX.y;
                    targetToWorld.transform(targetPt, worldPt);
                    w2p.transform(worldPt, predictedPixel);
                    double dx = predictedPixel.x - ((Point2D_F64)o.p).x;
                    double dy = predictedPixel.y - ((Point2D_F64)o.p).y;
                    imageStats.pointError[obsIdx] = reprojectionError = Math.sqrt(dx * dx + dy * dy);
                    imageStats.residuals[obsIdx * 2] = dx;
                    imageStats.residuals[obsIdx * 2 + 1] = dy;
                    errors.add(reprojectionError);
                    sumX += dx;
                    sumY += dy;
                }
                errors.sort();
                imageStats.maxError = errors.getFraction(1.0);
                imageStats.meanError = StatisticsDogArray.mean((DogArray_F64)errors);
                imageStats.biasX += sumX / (double)camObs.points.size();
                imageStats.biasY += sumY / (double)camObs.points.size();
                overallMean += imageStats.meanError;
                overallMax = Math.max(overallMax, imageStats.maxError);
            }
            CameraStatistics stats = (CameraStatistics)this.statistics.get(camIdx);
            stats.overallMax = overallMax;
            stats.overallMean = overallMean / (double)totalFrames;
        }
    }

    @Nullable
    Se3_F64 extrinsicFromKnownCamera(FrameState frame, int camId0, int camId1) {
        FrameCamera state0 = (FrameCamera)frame.cameras.get(camId0);
        FrameCamera state1 = (FrameCamera)frame.cameras.get(camId1);
        if (state0 == null || state1 == null) {
            return null;
        }
        for (int obsIdx0 = 0; obsIdx0 < state0.observations.size(); ++obsIdx0) {
            TargetExtrinsics tgt0 = state0.observations.get(obsIdx0);
            TargetExtrinsics tgt1 = state1.findTarget(tgt0.targetID);
            if (tgt1 == null) continue;
            Se3_F64 cam0_to_cam1 = new Se3_F64();
            tgt0.targetToCamera.invertConcat(tgt1.targetToCamera, cam0_to_cam1);
            Se3_F64 cam0_to_sensor = this.results.getCameraToSensor(camId0);
            return cam0_to_cam1.invertConcat(cam0_to_sensor, null);
        }
        return null;
    }

    public String computeQualityText(boolean showImageStats) {
        CameraStatistics cam;
        int camId;
        StringBuilder builder = new StringBuilder();
        int[] counts = new int[this.summaryThresholds.length];
        int totalObservations = 0;
        for (camId = 0; camId < this.statistics.size; ++camId) {
            cam = (CameraStatistics)this.statistics.get(camId);
            for (int imageIdx = 0; imageIdx < cam.residuals.size(); ++imageIdx) {
                ImageResults r = cam.residuals.get(imageIdx);
                totalObservations += r.pointError.length;
                for (int obsIdx = 0; obsIdx < r.pointError.length; ++obsIdx) {
                    double e = r.pointError[obsIdx];
                    int iterThresh = this.summaryThresholds.length - 1;
                    while (iterThresh >= 0 && !(this.summaryThresholds[iterThresh] < e)) {
                        int n = iterThresh--;
                        counts[n] = counts[n] + 1;
                    }
                }
            }
        }
        builder.append("Overall Calibration Quality Metrics:\n");
        CalibrateMonoPlanar.generateReprojectionErrorHistogram(this.summaryThresholds, counts, totalObservations, builder);
        builder.append("Camera Calibration Quality Metrics:\n");
        for (camId = 0; camId < this.statistics.size; ++camId) {
            cam = (CameraStatistics)this.statistics.get(camId);
            builder.append(String.format("  camera[%d] fill_border=%5.3f fill_inner=%5.3f geometric=%5.3f\n", camId, cam.quality.borderFill, cam.quality.innerFill, cam.quality.geometric));
        }
        builder.append('\n');
        builder.append("Camera Summary Residual Metrics:\n");
        for (camId = 0; camId < this.statistics.size; ++camId) {
            cam = (CameraStatistics)this.statistics.get(camId);
            builder.append(String.format("  camera[%3d] mean=%6.2f max=%6.2f\n", camId, cam.overallMean, cam.overallMax));
        }
        builder.append('\n');
        if (!showImageStats) {
            return builder.toString();
        }
        for (camId = 0; camId < this.statistics.size; ++camId) {
            builder.append("Residual Errors: Camera ").append(camId).append("\n");
            cam = (CameraStatistics)this.statistics.get(camId);
            for (int frameIdx = 0; frameIdx < cam.residuals.size(); ++frameIdx) {
                ImageResults img = cam.residuals.get(frameIdx);
                builder.append(String.format("  img[%4d] mean=%6.2f max=%6.2f\n", frameIdx, img.meanError, img.maxError));
            }
            builder.append('\n');
        }
        return builder.toString();
    }

    public CalibrateMonoPlanar getCalibratorMono() {
        return this.calibratorMono;
    }

    public MetricBundleAdjustmentUtils getBundleUtils() {
        return this.bundleUtils;
    }

    public MultiCameraCalibParams getResults() {
        return this.results;
    }

    public DogArray<CameraStatistics> getStatistics() {
        return this.statistics;
    }

    public double[] getSummaryThresholds() {
        return this.summaryThresholds;
    }

    public void setSummaryThresholds(double[] summaryThresholds) {
        this.summaryThresholds = summaryThresholds;
    }

    public static class CameraPriors {
        int index;
        int width;
        int height;
    }

    public static class CameraStatistics {
        public CalibrationQuality quality = new CalibrationQuality();
        public List<ImageResults> residuals = new ArrayList<ImageResults>();
        public double overallMean = 0.0;
        public double overallMax = 0.0;

        public void reset() {
            this.quality.reset();
            this.residuals.clear();
            this.overallMax = 0.0;
            this.overallMean = 0.0;
        }
    }

    public static class FrameState {
        TIntObjectMap<FrameCamera> cameras = new TIntObjectHashMap();
        Se3_F64 sensorToWorld = new Se3_F64();

        public void reset() {
            this.cameras.clear();
            this.sensorToWorld.reset();
        }
    }

    public static class FrameCamera {
        public List<TargetExtrinsics> observations = new ArrayList<TargetExtrinsics>();

        @Nullable
        public TargetExtrinsics findTarget(int targetID) {
            for (int i = 0; i < this.observations.size(); ++i) {
                if (this.observations.get((int)i).targetID != targetID) continue;
                return this.observations.get(i);
            }
            return null;
        }
    }

    public static class TargetExtrinsics {
        public int targetID;
        public Se3_F64 targetToCamera = new Se3_F64();

        public TargetExtrinsics(int targetID) {
            this.targetID = targetID;
        }

        public TargetExtrinsics() {
        }
    }
}

