/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.structure;

import boofcv.alg.geo.LowLevelMultiViewOps;
import boofcv.alg.geo.NormalizationPoint2D;
import boofcv.misc.BoofLambdas;
import boofcv.struct.geo.PointIndex2D_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public class ProjectiveStructureFromHomographies {
    SingularValueDecomposition_F64<DMatrixRMaj> svd = DecompositionFactory_DDRM.svd((boolean)false, (boolean)true, (boolean)true);
    List<List<PointIndex2D_F64>> filtered = new ArrayList<List<PointIndex2D_F64>>();
    List<DMatrixRMaj> homographies;
    DMatrixRMaj A = new DMatrixRMaj(1, 1);
    DMatrixRMaj B = new DMatrixRMaj(1, 1);
    Point3D_F64 tmp = new Point3D_F64();
    NormalizationPoint2D N = new NormalizationPoint2D();
    double infinityThreshold = UtilEjml.EPS;
    int numViews;
    int numEquations;
    int numUnknown;
    int totalFeatures;
    BoofLambdas.ConvertOut<PointIndex2D_F64, Point2D_F64> convert = pi -> (Point2D_F64)pi.p;

    public boolean proccess(List<DMatrixRMaj> homographies_view0_to_viewI, List<List<PointIndex2D_F64>> observations, int totalFeatures) {
        if (homographies_view0_to_viewI.size() != observations.size()) {
            throw new IllegalArgumentException("Number of homographies and observations do not match");
        }
        LowLevelMultiViewOps.computeNormalizationLL(observations, this.convert, this.N);
        this.homographies = homographies_view0_to_viewI;
        this.filterPointsOnPlaneAtInfinity(this.homographies, observations, totalFeatures);
        this.computeConstants(homographies_view0_to_viewI, this.filtered, totalFeatures);
        this.constructLinearSystem(this.homographies, this.filtered);
        if (!this.svd.decompose((Matrix)this.A)) {
            return false;
        }
        SingularOps_DDRM.nullVector(this.svd, (boolean)true, (DMatrixRMaj)this.B);
        return true;
    }

    void computeConstants(List<DMatrixRMaj> homographies_view0_to_viewI, List<List<PointIndex2D_F64>> observations, int totalFeatures) {
        int totalObservations = 0;
        for (int i = 0; i < observations.size(); ++i) {
            totalObservations += observations.get(i).size();
        }
        this.totalFeatures = totalFeatures;
        this.numViews = homographies_view0_to_viewI.size();
        this.numEquations = 2 * totalObservations;
        this.numUnknown = 3 * totalFeatures + 3 * this.numViews;
    }

    void constructLinearSystem(List<DMatrixRMaj> homographies, List<List<PointIndex2D_F64>> observations) {
        int startView = this.totalFeatures * 3;
        this.A.reshape(this.numEquations, this.numUnknown);
        DMatrixRMaj H = new DMatrixRMaj(3, 3);
        Point2D_F64 p = new Point2D_F64();
        int row = 0;
        for (int viewIdx = 0; viewIdx < homographies.size(); ++viewIdx) {
            this.N.apply(homographies.get(viewIdx), H);
            int colView = startView + viewIdx * 3;
            List<PointIndex2D_F64> obs = observations.get(viewIdx);
            for (int i = 0; i < obs.size(); ++i) {
                PointIndex2D_F64 p_pixel = obs.get(i);
                this.N.apply((Point2D_F64)p_pixel.p, p);
                int col = p_pixel.index * 3;
                this.A.data[row * this.A.numCols + col] = p.x * H.get(2, 0) - H.get(0, 0);
                this.A.data[row * this.A.numCols + col + 1] = p.x * H.get(2, 1) - H.get(0, 1);
                this.A.data[row * this.A.numCols + col + 2] = p.x * H.get(2, 2) - H.get(0, 2);
                this.A.data[row * this.A.numCols + colView] = -1.0;
                this.A.data[row * this.A.numCols + colView + 1] = 0.0;
                this.A.data[row * this.A.numCols + colView + 2] = p.x;
                this.A.data[++row * this.A.numCols + col] = p.y * H.get(2, 0) - H.get(1, 0);
                this.A.data[row * this.A.numCols + col + 1] = p.y * H.get(2, 1) - H.get(1, 1);
                this.A.data[row * this.A.numCols + col + 2] = p.y * H.get(2, 2) - H.get(1, 2);
                this.A.data[row * this.A.numCols + colView] = 0.0;
                this.A.data[row * this.A.numCols + colView + 1] = -1.0;
                this.A.data[row * this.A.numCols + colView + 2] = p.y;
                ++row;
            }
        }
    }

    void filterPointsOnPlaneAtInfinity(List<DMatrixRMaj> homographies_view1_to_view0, List<List<PointIndex2D_F64>> observations, int totalFeatures) {
        this.filtered.clear();
        for (int viewIdx = 0; viewIdx < homographies_view1_to_view0.size(); ++viewIdx) {
            ArrayList<PointIndex2D_F64> filter = new ArrayList<PointIndex2D_F64>();
            this.filtered.add(filter);
            DMatrixRMaj H = homographies_view1_to_view0.get(viewIdx);
            List<PointIndex2D_F64> obs = observations.get(viewIdx);
            for (int i = 0; i < obs.size(); ++i) {
                PointIndex2D_F64 p = obs.get(i);
                if (p.index < 0 || p.index >= totalFeatures) {
                    throw new IllegalArgumentException("Feature index outside of bounds. Must be from 0 to " + (totalFeatures - 1));
                }
                GeometryMath_F64.mult((DMatrixRMaj)H, (GeoTuple2D_F64)((GeoTuple2D_F64)p.p), (GeoTuple3D_F64)this.tmp);
                double m = Math.max(Math.abs(this.tmp.x), Math.abs(this.tmp.y));
                if (m == 0.0) {
                    m = 1.0;
                }
                this.tmp.z /= m;
                if (!(Math.abs(this.tmp.z) > this.infinityThreshold)) continue;
                filter.add(p);
            }
        }
    }

    public void getCameraMatrix(int viewIdx, DMatrixRMaj P) {
        DMatrixRMaj H = this.homographies.get(viewIdx);
        int row = this.totalFeatures * 3 + viewIdx * 3;
        this.tmp.x = this.B.unsafe_get(row, 0);
        this.tmp.y = this.B.unsafe_get(row + 1, 0);
        this.tmp.z = this.B.unsafe_get(row + 2, 0);
        this.N.remove(this.tmp, this.tmp);
        CommonOps_DDRM.insert((DMatrix)H, (DMatrix)P, (int)0, (int)0);
        P.set(0, 3, this.tmp.x);
        P.set(1, 3, this.tmp.y);
        P.set(2, 3, this.tmp.z);
    }

    public void getFeature3D(int featureIdx, Point3D_F64 X) {
        int row = featureIdx * 3;
        X.x = this.B.unsafe_get(row, 0);
        X.y = this.B.unsafe_get(row + 1, 0);
        X.z = this.B.unsafe_get(row + 2, 0);
    }

    public double getInfinityThreshold() {
        return this.infinityThreshold;
    }

    public void setInfinityThreshold(double infinityThreshold) {
        this.infinityThreshold = infinityThreshold;
    }
}

