/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.trifocal;

import boofcv.abst.geo.Triangulate2ViewsMetricH;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.geo.AssociatedTriple;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import java.util.List;
import org.ddogleg.sorting.QuickSelect;
import org.ddogleg.struct.DogArray_F64;

public class ResolveThreeViewScaleAmbiguity {
    protected Triangulate2ViewsMetricH triangulate;
    protected DogArray_F64 scales = new DogArray_F64();
    protected Point4D_F64 X2 = new Point4D_F64();
    protected Point4D_F64 X3 = new Point4D_F64();

    public ResolveThreeViewScaleAmbiguity(Triangulate2ViewsMetricH triangulate) {
        this.triangulate = triangulate;
    }

    public ResolveThreeViewScaleAmbiguity() {
        this(FactoryMultiView.triangulate2ViewMetricH(null));
    }

    public boolean process(List<AssociatedTriple> triple, Se3_F64 world_to_view2, Se3_F64 world_to_view3) {
        this.scales.resize(triple.size());
        this.scales.reset();
        for (int i = 0; i < triple.size(); ++i) {
            AssociatedTriple a = triple.get(i);
            if (!this.triangulate.triangulate(a.p1, a.p2, world_to_view2, this.X2) || this.X2.w == 0.0 || !this.triangulate.triangulate(a.p1, a.p3, world_to_view3, this.X3) || this.X3.w == 0.0) continue;
            double scale = this.X2.z * this.X3.w / (this.X2.w * this.X3.z);
            this.scales.add(scale);
        }
        if (this.scales.size == 0) {
            return false;
        }
        double scale3_to_2 = QuickSelect.select((double[])this.scales.data, (int)(this.scales.size / 2), (int)this.scales.size);
        if (scale3_to_2 == 0.0) {
            return false;
        }
        world_to_view3.T.scale(scale3_to_2);
        double normA = world_to_view2.T.norm();
        double normB = world_to_view3.T.norm();
        double norm = Math.max(normA, normB);
        world_to_view2.T.divide(norm);
        world_to_view3.T.divide(norm);
        return true;
    }
}

