/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.division;

import boofcv.struct.distort.Point2Transform2_F32;
import georegression.struct.point.Point2D_F32;

public class AddDivisionNtoN_F32
implements Point2Transform2_F32 {
    public float radial;
    public float tol = 1.0E-8f;
    public int maxIterations = 500;

    public AddDivisionNtoN_F32 setRadial(float radial) {
        this.radial = radial;
        return this;
    }

    public void compute(float x, float y, Point2D_F32 out) {
        float origX = x;
        float origY = y;
        float prevR2 = 0.0f;
        for (int iter = 0; iter < this.maxIterations; ++iter) {
            float r2 = x * x + y * y;
            x = origX * (1.0f + this.radial * r2);
            y = origY * (1.0f + this.radial * r2);
            if (Math.abs(r2 - prevR2) <= this.tol) break;
            prevR2 = r2;
        }
        out.setTo(x, y);
    }

    public AddDivisionNtoN_F32 copyConcurrent() {
        AddDivisionNtoN_F32 ret = new AddDivisionNtoN_F32();
        ret.radial = this.radial;
        return ret;
    }
}

