/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.robust;

import boofcv.alg.geo.DistanceFromModelMultiView;
import boofcv.alg.geo.robust.ModelMatcherMultiview;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinhole;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelMatcherPost;
import org.ddogleg.fitting.modelset.ransac.Ransac;
import org.ddogleg.struct.Factory;

public class RansacCalibrated<Model, Point>
implements ModelMatcherMultiview<Model, Point>,
ModelMatcherPost<Model, Point> {
    Ransac<Model, Point> fitter;
    final List<CameraPinhole> listIntrinsics = new ArrayList<CameraPinhole>();

    public RansacCalibrated(Ransac<Model, Point> fitter) {
        this.fitter = fitter;
        fitter.setInitializeModels((generator, distance) -> {
            DistanceFromModelMultiView dist = (DistanceFromModelMultiView)distance;
            BoofMiscOps.checkEq((int)dist.getNumberOfViews(), (int)this.listIntrinsics.size(), (String)"Must first call setModel()");
            for (int viewIdx = 0; viewIdx < this.listIntrinsics.size(); ++viewIdx) {
                CameraPinhole intrinscs = Objects.requireNonNull(this.listIntrinsics.get(viewIdx), "Must first specify intrinsics for each camera");
                dist.setIntrinsic(viewIdx, intrinscs);
            }
        });
    }

    @Override
    public void setIntrinsic(int view, CameraPinhole intrinsic) {
        if (this.listIntrinsics.size() == 0) {
            throw new IllegalArgumentException("You must call setModel() first");
        }
        this.listIntrinsics.set(view, intrinsic);
    }

    @Override
    public int getNumberOfViews() {
        return this.listIntrinsics.size();
    }

    public boolean process(List<Point> dataSet) {
        return this.fitter.process(dataSet);
    }

    public Model getModelParameters() {
        return (Model)this.fitter.getModelParameters();
    }

    public List<Point> getMatchSet() {
        return this.fitter.getMatchSet();
    }

    public int getInputIndex(int matchIndex) {
        return this.fitter.getInputIndex(matchIndex);
    }

    public double getFitQuality() {
        return this.fitter.getFitQuality();
    }

    public int getMinimumSize() {
        return this.fitter.getMinimumSize();
    }

    public void reset() {
        this.fitter.reset();
    }

    public Class<Point> getPointType() {
        return this.fitter.getPointType();
    }

    public Class<Model> getModelType() {
        return this.fitter.getModelType();
    }

    public void setSampleSize(int sampleSize) {
        this.fitter.setSampleSize(sampleSize);
    }

    public void setThresholdFit(double thresholdFit) {
        this.fitter.setThresholdFit(thresholdFit);
    }

    public void setModel(Factory<ModelGenerator<Model, Point>> factoryGenerator, Factory<DistanceFromModel<Model, Point>> factoryDistance) {
        int numViews = ((DistanceFromModelMultiView)factoryDistance.newInstance()).getNumberOfViews();
        this.listIntrinsics.clear();
        for (int i = 0; i < numViews; ++i) {
            this.listIntrinsics.add(null);
        }
        this.fitter.setModel(factoryGenerator, factoryDistance);
    }

    public Ransac<Model, Point> getFitter() {
        return this.fitter;
    }
}

