/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle;

import boofcv.abst.geo.bundle.BundleAdjustmentSchur;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.geo.bundle.jacobians.JacobianSo3;
import boofcv.alg.geo.bundle.jacobians.JacobianSo3Rodrigues;
import boofcv.misc.BoofMiscOps;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrixD1;

public class CodecSceneStructureMetric
implements BundleAdjustmentSchur.Codec<SceneStructureMetric> {
    public JacobianSo3 rotation = new JacobianSo3Rodrigues();

    public CodecSceneStructureMetric() {
    }

    public CodecSceneStructureMetric(JacobianSo3 rotation) {
        this.rotation = rotation;
    }

    @Override
    public void decode(double[] input, SceneStructureMetric structure) {
        int i;
        int index = 0;
        for (i = 0; i < structure.points.size; ++i) {
            SceneStructureCommon.Point p = ((SceneStructureCommon.Point[])structure.points.data)[i];
            p.coordinate[0] = input[index++];
            p.coordinate[1] = input[index++];
            p.coordinate[2] = input[index++];
            if (!structure.isHomogeneous()) continue;
            p.coordinate[3] = input[index++];
        }
        for (int rigidIndex = 0; rigidIndex < structure.rigids.size; ++rigidIndex) {
            SceneStructureMetric.Rigid rigid = ((SceneStructureMetric.Rigid[])structure.rigids.data)[rigidIndex];
            if (rigid.known) continue;
            this.rotation.setParameters(input, index);
            rigid.object_to_world.R.setTo((DMatrixD1)this.rotation.getRotationMatrix());
            index += this.rotation.getParameterLength();
            rigid.object_to_world.T.x = input[index++];
            rigid.object_to_world.T.y = input[index++];
            rigid.object_to_world.T.z = input[index++];
        }
        for (int motionIndex = 0; motionIndex < structure.motions.size; ++motionIndex) {
            SceneStructureMetric.Motion motion = ((SceneStructureMetric.Motion[])structure.motions.data)[motionIndex];
            if (motion.known) continue;
            this.rotation.setParameters(input, index);
            motion.parent_to_view.R.setTo((DMatrixD1)this.rotation.getRotationMatrix());
            index += this.rotation.getParameterLength();
            motion.parent_to_view.T.x = input[index++];
            motion.parent_to_view.T.y = input[index++];
            motion.parent_to_view.T.z = input[index++];
        }
        for (i = 0; i < structure.cameras.size; ++i) {
            SceneStructureCommon.Camera camera = ((SceneStructureCommon.Camera[])structure.cameras.data)[i];
            if (camera.known) continue;
            camera.model.setIntrinsic(input, index);
            index += camera.model.getIntrinsicCount();
        }
    }

    @Override
    public void encode(SceneStructureMetric structure, double[] output) {
        int checkIdx;
        int indexBefore;
        int i;
        int index = 0;
        for (i = 0; i < structure.points.size; ++i) {
            SceneStructureCommon.Point p = ((SceneStructureCommon.Point[])structure.points.data)[i];
            output[index++] = p.coordinate[0];
            output[index++] = p.coordinate[1];
            output[index++] = p.coordinate[2];
            if (structure.isHomogeneous()) {
                output[index++] = p.coordinate[3];
            }
            for (int checkIdx2 = index - p.coordinate.length; checkIdx2 < index; ++checkIdx2) {
                BoofMiscOps.checkTrue((!UtilEjml.isUncountable((double)output[checkIdx2]) ? 1 : 0) != 0, (String)"Bad point");
            }
        }
        for (int rigidIndex = 0; rigidIndex < structure.rigids.size; ++rigidIndex) {
            SceneStructureMetric.Rigid rigid = ((SceneStructureMetric.Rigid[])structure.rigids.data)[rigidIndex];
            if (rigid.known) continue;
            indexBefore = index;
            this.rotation.getParameters(rigid.object_to_world.R, output, index);
            index += this.rotation.getParameterLength();
            output[index++] = rigid.object_to_world.T.x;
            output[index++] = rigid.object_to_world.T.y;
            output[index++] = rigid.object_to_world.T.z;
            for (checkIdx = indexBefore; checkIdx < index; ++checkIdx) {
                BoofMiscOps.checkTrue((!UtilEjml.isUncountable((double)output[checkIdx]) ? 1 : 0) != 0, (String)"Bad rigid");
            }
        }
        for (int motionIndex = 0; motionIndex < structure.motions.size; ++motionIndex) {
            SceneStructureMetric.Motion motion = ((SceneStructureMetric.Motion[])structure.motions.data)[motionIndex];
            if (motion.known) continue;
            indexBefore = index;
            this.rotation.getParameters(motion.parent_to_view.R, output, index);
            index += this.rotation.getParameterLength();
            output[index++] = motion.parent_to_view.T.x;
            output[index++] = motion.parent_to_view.T.y;
            output[index++] = motion.parent_to_view.T.z;
            for (checkIdx = indexBefore; checkIdx < index; ++checkIdx) {
                BoofMiscOps.checkTrue((!UtilEjml.isUncountable((double)output[checkIdx]) ? 1 : 0) != 0, (String)"Bad rotation");
            }
        }
        for (i = 0; i < structure.cameras.size; ++i) {
            SceneStructureCommon.Camera camera = ((SceneStructureCommon.Camera[])structure.cameras.data)[i];
            if (camera.known) continue;
            indexBefore = index;
            camera.model.getIntrinsic(output, index);
            index += camera.model.getIntrinsicCount();
            for (checkIdx = indexBefore; checkIdx < index; ++checkIdx) {
                BoofMiscOps.checkTrue((!UtilEjml.isUncountable((double)output[checkIdx]) ? 1 : 0) != 0, (String)"Bad camera");
            }
        }
    }
}

