/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle;

import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.geo.bundle.BundleAdjustmentMetricResidualFunction;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class EvaluateBundleScene {
    protected BundleAdjustmentMetricResidualFunction functionResiduals = new BundleAdjustmentMetricResidualFunction();
    protected List<InlierBucket> inlierStats = new ArrayList<InlierBucket>();

    public void addInliers(double ... thresholds) {
        this.inlierStats.clear();
        for (int i = 0; i < thresholds.length; ++i) {
            this.inlierStats.add(new InlierBucket(thresholds[i]));
        }
    }

    public void evaluate(SceneStructureMetric scene, SceneObservations observations) {
        for (int i = 0; i < this.inlierStats.size(); ++i) {
            this.inlierStats.get(i).clearCounts();
        }
        this.functionResiduals.configure(scene, observations);
        double[] residuals = new double[this.functionResiduals.getNumOfOutputsM()];
        this.functionResiduals.process(residuals);
        for (int i = 0; i < residuals.length; i += 2) {
            double rx = residuals[i];
            double ry = residuals[i + 1];
            double errorSq = rx * rx + ry * ry;
            for (int inlierIdx = 0; inlierIdx < this.inlierStats.size(); ++inlierIdx) {
                InlierBucket bucket = this.inlierStats.get(inlierIdx);
                if (!bucket.isMember(errorSq)) continue;
                ++bucket.count;
            }
        }
    }

    public void printSummary(PrintStream out) {
        InlierBucket bucket;
        int inlierIdx;
        double N = (double)this.functionResiduals.getNumOfOutputsM() / 2.0;
        out.println("      Inlier Thresholds");
        out.print("       ");
        for (inlierIdx = 0; inlierIdx < this.inlierStats.size(); ++inlierIdx) {
            bucket = this.inlierStats.get(inlierIdx);
            out.printf(" | %6.1f", bucket.threshold);
        }
        out.println();
        out.print("percent");
        for (inlierIdx = 0; inlierIdx < this.inlierStats.size(); ++inlierIdx) {
            bucket = this.inlierStats.get(inlierIdx);
            out.printf(" | %5.1f%%", 100.0 * (double)bucket.count / N);
        }
        out.println();
    }

    public List<InlierBucket> getInlierStats() {
        return this.inlierStats;
    }

    public static class InlierBucket {
        public double threshold;
        public int count;

        public InlierBucket(double threshold) {
            this.threshold = threshold;
        }

        public boolean isMember(double errorSq) {
            return errorSq <= this.threshold * this.threshold;
        }

        public void clearCounts() {
            this.count = 0;
        }
    }
}

