/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.selfcalib;

import boofcv.abst.geo.selfcalib.ProjectiveToMetricCameras;
import boofcv.alg.geo.GeometricResult;
import boofcv.alg.geo.MetricCameras;
import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.selfcalib.RefineDualQuadraticAlgebraicError;
import boofcv.alg.geo.selfcalib.ResolveSignAmbiguityPositiveDepth;
import boofcv.alg.geo.selfcalib.SelfCalibrationLinearDualQuadratic;
import boofcv.alg.geo.structure.DecomposeAbsoluteDualQuadratic;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.ElevateViewInfo;
import boofcv.struct.geo.AssociatedTuple;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.se.Se3_F64;
import java.io.PrintStream;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.VerbosePrint;
import org.ddogleg.util.VerboseUtils;
import org.ejml.data.DMatrix3;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.jetbrains.annotations.Nullable;

public class ProjectiveToMetricCameraDualQuadratic
implements ProjectiveToMetricCameras,
VerbosePrint {
    final SelfCalibrationLinearDualQuadratic selfCalib;
    final RefineDualQuadraticAlgebraicError refiner = new RefineDualQuadraticAlgebraicError();
    public double invalidFractionAccept = 0.15;
    final DecomposeAbsoluteDualQuadratic decomposeDualQuad = new DecomposeAbsoluteDualQuadratic();
    final DMatrixRMaj P1 = CommonOps_DDRM.identity((int)3, (int)4);
    final DMatrixRMaj H = new DMatrixRMaj(4, 4);
    final DMatrixRMaj K = new DMatrixRMaj(3, 3);
    final ResolveSignAmbiguityPositiveDepth resolveSign = new ResolveSignAmbiguityPositiveDepth();
    @Nullable
    PrintStream verbose;
    DogArray<CameraPinhole> workCameras = new DogArray(CameraPinhole::new, CameraPinhole::reset);
    DogArray_I32 cameraCounts = new DogArray_I32();

    public ProjectiveToMetricCameraDualQuadratic(SelfCalibrationLinearDualQuadratic selfCalib) {
        this.selfCalib = selfCalib;
    }

    @Override
    public boolean process(List<ElevateViewInfo> views, List<DMatrixRMaj> cameraMatrices, List<AssociatedTuple> observations, MetricCameras metricViews) {
        BoofMiscOps.checkEq((int)(cameraMatrices.size() + 1), (int)views.size(), (String)"View[0] is implicitly identity and not included");
        metricViews.reset();
        if (!this.solveThenDecompose(cameraMatrices)) {
            return false;
        }
        FastAccess<SelfCalibrationLinearDualQuadratic.Intrinsic> solutions = this.selfCalib.getIntrinsics();
        if (solutions.size != views.size()) {
            if (this.verbose != null) {
                this.verbose.println("FAILED solution.size miss match");
            }
            return false;
        }
        int numCameras = 0;
        for (int i = 0; i < views.size(); ++i) {
            numCameras = Math.max(numCameras, views.get((int)i).cameraID);
        }
        this.averageCommonCameras(views, solutions, ++numCameras);
        this.refineCamerasAlgebraic(views, cameraMatrices, numCameras);
        if (!this.reformatResults(views, cameraMatrices, metricViews)) {
            return false;
        }
        this.resolveSign.process(observations, metricViews);
        if (this.checkBehindCamera(cameraMatrices.size(), observations.size())) {
            return true;
        }
        if (this.verbose != null) {
            this.printFoundMetric(views, metricViews);
        }
        return false;
    }

    boolean solveThenDecompose(List<DMatrixRMaj> views) {
        this.selfCalib.reset();
        this.selfCalib.addCameraMatrix(this.P1);
        for (int i = 0; i < views.size(); ++i) {
            this.selfCalib.addCameraMatrix(views.get(i));
        }
        GeometricResult results = this.selfCalib.solve();
        if (results != GeometricResult.SUCCESS) {
            if (this.verbose != null) {
                this.verbose.println("FAILED geometric");
            }
            return false;
        }
        if (!this.decomposeDualQuad.decompose(this.selfCalib.getQ())) {
            if (this.verbose != null) {
                this.verbose.println("FAILED decompose Dual Quad");
            }
            return false;
        }
        if (!this.decomposeDualQuad.computeRectifyingHomography(this.H)) {
            if (this.verbose != null) {
                this.verbose.println("FAILED rectify homography");
            }
            return false;
        }
        return true;
    }

    void refineCamerasAlgebraic(List<ElevateViewInfo> views, List<DMatrixRMaj> cameraMatrices, int numCameras) {
        int i;
        if (!this.selfCalib.zeroSkew) {
            if (this.verbose != null) {
                this.verbose.println("Skipping refine since skew is not zero");
            }
            return;
        }
        if (this.refiner.converge.maxIterations <= 0) {
            return;
        }
        BoofMiscOps.checkEq((int)views.size(), (int)(cameraMatrices.size() + 1));
        this.refiner.knownAspect = this.selfCalib.isKnownAspect();
        this.refiner.knownPrinciplePoint = true;
        this.refiner.initialize(numCameras, views.size());
        DMatrix3 planeAtInfinity = this.selfCalib.getPlaneAtInfinity();
        this.refiner.setPlaneAtInfinity(planeAtInfinity.a1, planeAtInfinity.a2, planeAtInfinity.a3);
        for (int cameraIdx = 0; cameraIdx < numCameras; ++cameraIdx) {
            CameraPinhole merged = (CameraPinhole)this.workCameras.get(cameraIdx);
            this.refiner.setCamera(cameraIdx, merged.fx, merged.cx, merged.cy, merged.fy / merged.fx);
        }
        for (int viewIdx = 0; viewIdx < views.size(); ++viewIdx) {
            if (viewIdx == 0) {
                this.refiner.setProjective(0, this.P1);
            } else {
                this.refiner.setProjective(viewIdx, cameraMatrices.get(viewIdx - 1));
            }
            this.refiner.setViewToCamera(viewIdx, views.get((int)viewIdx).cameraID);
        }
        if (!this.refiner.refine()) {
            if (this.verbose != null) {
                this.verbose.println("Refine failed! Ignoring results");
            }
            return;
        }
        if (this.verbose != null) {
            for (i = 0; i < numCameras; ++i) {
                RefineDualQuadraticAlgebraicError.CameraState refined = (RefineDualQuadraticAlgebraicError.CameraState)this.refiner.getCameras().get(i);
                this.verbose.printf("refined[%d] fx=%.1f fy=%.1f\n", i, refined.fx, refined.fx * refined.aspectRatio);
            }
        }
        for (i = 0; i < views.size(); ++i) {
            ElevateViewInfo info = views.get(i);
            RefineDualQuadraticAlgebraicError.CameraState refined = (RefineDualQuadraticAlgebraicError.CameraState)this.refiner.getCameras().get(info.cameraID);
            CameraPinhole estimated = (CameraPinhole)this.workCameras.get(info.cameraID);
            estimated.fx = refined.fx;
            estimated.fy = refined.aspectRatio * refined.fx;
        }
        PerspectiveOps.pinholeToMatrix((CameraPinhole)this.workCameras.get(views.get((int)0).cameraID), this.K);
        MultiViewOps.canonicalRectifyingHomographyFromKPinf(this.K, this.refiner.planeAtInfinity, this.H);
    }

    void averageCommonCameras(List<ElevateViewInfo> views, FastAccess<SelfCalibrationLinearDualQuadratic.Intrinsic> solutions, int numCameras) {
        int i;
        this.cameraCounts.reset().resize(numCameras, 0);
        this.workCameras.reset().resize(numCameras);
        for (i = 0; i < views.size(); ++i) {
            ElevateViewInfo info = views.get(i);
            CameraPinhole merged = (CameraPinhole)this.workCameras.get(info.cameraID);
            SelfCalibrationLinearDualQuadratic.Intrinsic estimated = (SelfCalibrationLinearDualQuadratic.Intrinsic)solutions.get(i);
            merged.fx += estimated.fx;
            merged.fy += estimated.fy;
            merged.skew += estimated.skew;
            int n = info.cameraID;
            this.cameraCounts.data[n] = this.cameraCounts.data[n] + 1;
            if (this.verbose == null) continue;
            this.verbose.printf("view[%d] fx=%.1f fy=%.1f skew=%.2f\n", i, estimated.fx, estimated.fy, estimated.skew);
        }
        for (i = 0; i < numCameras; ++i) {
            CameraPinhole merged = (CameraPinhole)this.workCameras.get(i);
            int divisor = this.cameraCounts.get(i);
            if (divisor == 1) continue;
            merged.fx /= (double)divisor;
            merged.fy /= (double)divisor;
            merged.skew /= (double)divisor;
            merged.cx = 0.0;
            merged.cy = 0.0;
        }
        if (this.verbose != null) {
            for (i = 0; i < numCameras; ++i) {
                CameraPinhole cam = (CameraPinhole)this.workCameras.get(i);
                this.verbose.printf("camera[%d] fx=%.1f fy=%.1f skew=%.2f, count=%d\n", i, cam.fx, cam.fy, cam.skew, this.cameraCounts.get(i));
            }
        }
    }

    boolean reformatResults(List<ElevateViewInfo> views, List<DMatrixRMaj> cameraMatrices, MetricCameras metricViews) {
        int i;
        for (int i2 = 0; i2 < views.size(); ++i2) {
            ((CameraPinhole)metricViews.intrinsics.grow()).setTo((CameraPinhole)this.workCameras.get(views.get((int)i2).cameraID));
        }
        double largestT = 0.0;
        for (i = 0; i < cameraMatrices.size(); ++i) {
            DMatrixRMaj P = cameraMatrices.get(i);
            PerspectiveOps.pinholeToMatrix((CameraPinhole)metricViews.intrinsics.get(i + 1), this.K);
            if (!MultiViewOps.projectiveToMetricKnownK(P, this.H, this.K, (Se3_F64)metricViews.motion_1_to_k.grow())) {
                if (this.verbose != null) {
                    this.verbose.println("FAILED projectiveToMetricKnownK");
                }
                return false;
            }
            largestT = Math.max(largestT, ((Se3_F64)metricViews.motion_1_to_k.getTail()).T.norm());
        }
        for (i = 0; i < metricViews.motion_1_to_k.size; ++i) {
            ((Se3_F64)metricViews.motion_1_to_k.get((int)i)).T.divide(largestT);
        }
        return true;
    }

    boolean checkBehindCamera(int numViews, int numObservations) {
        double fractionInvalid = (double)this.resolveSign.bestInvalid / (double)numViews / (double)numObservations;
        if (fractionInvalid <= this.invalidFractionAccept) {
            return true;
        }
        if (this.verbose != null) {
            this.verbose.printf("FAILED: Features behind camera. fraction=%.3f threshold=%.3f\n", fractionInvalid, this.invalidFractionAccept);
        }
        return false;
    }

    private void printFoundMetric(List<ElevateViewInfo> views, MetricCameras metricViews) {
        PrintStream verbose = Objects.requireNonNull(this.verbose);
        for (int i = 0; i < views.size(); ++i) {
            CameraPinhole cam = (CameraPinhole)metricViews.intrinsics.get(i);
            verbose.printf("metric[%d] fx=%.1f fy=%.1f", i, cam.fx, cam.fy);
            if (i == 0) {
                verbose.println();
                continue;
            }
            Se3_F64 m = (Se3_F64)metricViews.motion_1_to_k.get(i - 1);
            double theta = ConvertRotation3D_F64.matrixToRodrigues((DMatrixRMaj)m.R, null).theta;
            verbose.printf(" T=(%.2f %.2f %.2f) R=%.4f\n", m.T.x, m.T.y, m.T.z, theta);
        }
    }

    @Override
    public int getMinimumViews() {
        return this.selfCalib.getMinimumProjectives();
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = VerboseUtils.addPrefix((VerbosePrint)this, (PrintStream)out);
        VerboseUtils.verboseChildren((PrintStream)this.verbose, configuration, (VerbosePrint[])new VerbosePrint[]{this.resolveSign, this.refiner});
    }

    public SelfCalibrationLinearDualQuadratic getSelfCalib() {
        return this.selfCalib;
    }

    public RefineDualQuadraticAlgebraicError getRefiner() {
        return this.refiner;
    }
}

