/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import boofcv.abst.geo.Triangulate2PointingMetricH;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.FactoryMultiView;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;

public class PositiveDepthConstraintCheckHPointing {
    Triangulate2PointingMetricH triangulate;
    Point4D_F64 p = new Point4D_F64();

    public PositiveDepthConstraintCheckHPointing(Triangulate2PointingMetricH triangulate) {
        this.triangulate = triangulate;
    }

    public PositiveDepthConstraintCheckHPointing() {
        this(FactoryMultiView.triangulate2PointingMetricH(new ConfigTriangulation(ConfigTriangulation.Type.GEOMETRIC)));
    }

    public boolean checkConstraint(Point3D_F64 viewA, Point3D_F64 viewB, Se3_F64 fromAtoB) {
        if (!this.triangulate.triangulate(viewA, viewB, fromAtoB, this.p)) {
            throw new RuntimeException("Triangulate failed. p1=" + String.valueOf(viewA) + " p2=" + String.valueOf(viewB));
        }
        if (PerspectiveOps.isBehindCamera(this.p)) {
            return false;
        }
        SePointOps_F64.transform((Se3_F64)fromAtoB, (Point4D_F64)this.p, (Point4D_F64)this.p);
        return !PerspectiveOps.isBehindCamera(this.p);
    }
}

