/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle;

import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.abst.geo.bundle.BundleCameraState;
import boofcv.alg.geo.bundle.cameras.BundleKannalaBrandt;
import boofcv.alg.geo.bundle.cameras.BundlePinhole;
import boofcv.alg.geo.bundle.cameras.BundlePinholeBrown;
import boofcv.alg.geo.bundle.cameras.BundlePinholeSimplified;
import boofcv.struct.calib.CameraKannalaBrandt;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class BundleAdjustmentOps {
    public static ConvertToBrown convertOp = (src, state, width, height, dst) -> {
        if (src instanceof BundlePinhole) {
            dst.fsetRadial(new double[0]).fsetTangential(0.0, 0.0);
            BundleAdjustmentOps.convert((BundlePinhole)src, width, height, (CameraPinhole)dst);
        } else if (src instanceof BundlePinholeBrown) {
            BundleAdjustmentOps.convert((BundlePinholeBrown)src, width, height, dst);
        } else if (src instanceof BundlePinholeSimplified) {
            BundleAdjustmentOps.convert((BundlePinholeSimplified)src, width, height, dst);
        } else {
            throw new RuntimeException("Unknown src type. " + String.valueOf(src) + " See BundleAdjustmentOps.convertOp for a way to support more cameras.");
        }
    };

    public static CameraPinholeBrown convert(BundleAdjustmentCamera src, @Nullable BundleCameraState state, int width, int height, @Nullable CameraPinholeBrown dst) {
        if (dst == null) {
            dst = new CameraPinholeBrown();
        }
        convertOp.convert(src, state, width, height, dst);
        return dst;
    }

    public static CameraPinhole convert(BundlePinhole src, int width, int height, @Nullable CameraPinhole dst) {
        if (dst == null) {
            dst = new CameraPinhole();
        }
        dst.fx = src.fx;
        dst.fy = src.fy;
        dst.cx = src.cx;
        dst.cy = src.cy;
        dst.skew = src.zeroSkew ? 0.0 : src.skew;
        dst.fsetShape(width, height);
        return dst;
    }

    public static CameraPinholeBrown convert(BundlePinholeBrown src, int width, int height, @Nullable CameraPinholeBrown dst) {
        if (dst == null) {
            dst = new CameraPinholeBrown();
        }
        dst.fx = src.fx;
        dst.fy = src.fy;
        dst.cx = src.cx;
        dst.cy = src.cy;
        dst.skew = src.zeroSkew ? 0.0 : src.skew;
        dst.radial = (double[])src.radial.clone();
        if (src.tangential) {
            dst.t1 = src.t1;
            dst.t2 = src.t2;
        } else {
            dst.t2 = 0.0;
            dst.t1 = 0.0;
        }
        dst.fsetShape(width, height);
        return dst;
    }

    public static CameraPinholeBrown convert(BundlePinholeSimplified src, int width, int height, @Nullable CameraPinholeBrown dst) {
        if (dst == null) {
            dst = new CameraPinholeBrown();
        }
        dst.fsetRadial(src.k1, src.k2).fsetTangential(0.0, 0.0);
        dst.fsetK(src.f, src.f, 0.0, width / 2, height / 2, 0, 0);
        dst.fsetShape(width, height);
        return dst;
    }

    public static CameraKannalaBrandt convert(BundleKannalaBrandt src, int width, int height, @Nullable CameraKannalaBrandt dst) {
        if (dst == null) {
            dst = new CameraKannalaBrandt();
        }
        dst.setTo(src.getModel());
        if (src.zeroSkew) {
            dst.skew = 0.0;
        }
        dst.fsetShape(width, height);
        return dst;
    }

    public static CameraPinhole convert(BundlePinholeSimplified src, int width, int height, @Nullable CameraPinhole dst) {
        if (dst == null) {
            dst = new CameraPinhole();
        }
        dst.fsetK(src.f, src.f, 0.0, width / 2, height / 2, 0, 0);
        dst.fsetShape(width, height);
        return dst;
    }

    public static BundlePinhole convert(CameraPinholeBrown src, @Nullable BundlePinhole dst) {
        if (dst == null) {
            dst = new BundlePinhole();
        }
        dst.zeroSkew = src.skew == 0.0;
        dst.fx = src.fx;
        dst.fy = src.fy;
        dst.cx = src.cx;
        dst.cy = src.cy;
        dst.skew = src.skew;
        return dst;
    }

    public static BundlePinholeBrown convert(CameraPinholeBrown src, @Nullable BundlePinholeBrown dst) {
        if (dst == null) {
            dst = new BundlePinholeBrown();
        }
        dst.radial = src.radial == null ? new double[0] : (double[])src.radial.clone();
        dst.zeroSkew = src.skew == 0.0;
        dst.fx = src.fx;
        dst.fy = src.fy;
        dst.cx = src.cx;
        dst.cy = src.cy;
        if (src.t1 != 0.0 || src.t2 != 0.0) {
            dst.t1 = src.t1;
            dst.t2 = src.t2;
            dst.tangential = true;
        } else {
            dst.t1 = 0.0;
            dst.t2 = 0.0;
            dst.tangential = false;
        }
        dst.skew = src.skew;
        return dst;
    }

    public static BundlePinholeSimplified convert(CameraPinhole src, @Nullable BundlePinholeSimplified dst) {
        if (dst == null) {
            dst = new BundlePinholeSimplified();
        }
        dst.f = (src.fx + src.fy) / 2.0;
        dst.k1 = 0.0;
        dst.k2 = 0.0;
        return dst;
    }

    public static BundlePinhole convert(CameraPinhole src, @Nullable BundlePinhole dst) {
        if (dst == null) {
            dst = new BundlePinhole();
        }
        dst.setK(src.fx, src.fy, src.skew, src.cx, src.cy);
        return dst;
    }

    public static BundlePinholeSimplified convert(DMatrixRMaj src, @Nullable BundlePinholeSimplified dst) {
        if (dst == null) {
            dst = new BundlePinholeSimplified();
        }
        dst.f = (src.get(0, 0) + src.get(1, 1)) / 2.0;
        dst.k1 = 0.0;
        dst.k2 = 0.0;
        return dst;
    }

    public static DMatrixRMaj convert(BundlePinholeSimplified src, @Nullable DMatrixRMaj dst) {
        if (dst == null) {
            dst = new DMatrixRMaj(3, 3);
        }
        dst.reshape(3, 3);
        dst.zero();
        dst.unsafe_set(0, 0, src.f);
        dst.unsafe_set(1, 1, src.f);
        dst.unsafe_set(2, 2, 1.0);
        return dst;
    }

    @FunctionalInterface
    public static interface ConvertToBrown {
        public void convert(BundleAdjustmentCamera var1, @Nullable BundleCameraState var2, int var3, int var4, CameraPinholeBrown var5);
    }
}

