/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.h;

import boofcv.misc.BoofMiscOps;
import boofcv.struct.geo.AssociatedPair;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.VerbosePrint;
import org.ddogleg.util.VerboseUtils;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;
import org.ejml.interfaces.linsol.LinearSolver;
import org.jetbrains.annotations.Nullable;

public class HomographyRadial6Pts
implements VerbosePrint {
    double crossSingularRatio;
    DMatrixRMaj A = new DMatrixRMaj(6, 8);
    DMatrixRMaj Y = new DMatrixRMaj(6, 1);
    DMatrixRMaj X = new DMatrixRMaj(4, 1);
    DMatrixRMaj null1 = new DMatrixRMaj(8, 1);
    DMatrixRMaj null2 = new DMatrixRMaj(8, 1);
    DMatrixRMaj V = new DMatrixRMaj(1, 1);
    DMatrixRMaj W = new DMatrixRMaj(1, 1);
    SingularValueDecomposition_F64<DMatrixRMaj> svd = DecompositionFactory_DDRM.svd((int)6, (int)8, (boolean)false, (boolean)true, (boolean)false);
    LinearSolver<DMatrixRMaj, DMatrixRMaj> solver = LinearSolverFactory_DDRM.qr((int)6, (int)6);
    DogArray<Hypothesis> hypotheses = new DogArray(Hypothesis::new);
    boolean minimalPoints;
    private final double[] quadraticSolutions = new double[2];
    final DogArray<Result> found = new DogArray(Result::new);
    @Nullable
    PrintStream verbose;

    public boolean process(List<AssociatedPair> points) {
        if (points.size() < 6) {
            throw new IllegalArgumentException("A minimum of 6 points is required");
        }
        this.found.reset();
        if (!this.linearCrossConstraint(points)) {
            if (this.verbose != null) {
                this.verbose.println("Failed at linear cross constraint");
            }
            return false;
        }
        if (this.minimalPoints) {
            if (!this.solveQuadraticRelationship()) {
                if (this.verbose != null) {
                    this.verbose.println("Failed at quadratic relationship");
                }
                return false;
            }
        } else {
            this.easyNullSpace();
        }
        for (int i = 0; i < this.hypotheses.size; ++i) {
            if (this.solveForRemaining(points, (Hypothesis)this.hypotheses.get(i), (Result)this.found.grow())) continue;
            if (this.verbose != null) {
                this.verbose.println("Failed at linear solver for 4 remaining parameters. A");
            }
            this.found.removeTail();
        }
        return !this.found.isEmpty();
    }

    public static double computeResidualError(List<AssociatedPair> points, Result result) {
        double error = 0.0;
        AssociatedPair undistorted = new AssociatedPair();
        Point2D_F64 found = new Point2D_F64();
        for (int i = 0; i < points.size(); ++i) {
            AssociatedPair a = points.get(i);
            undistorted.setTo(a);
            undistorted.p1.scale(1.0 / (1.0 + result.radial1 * a.p1.normSq()));
            undistorted.p2.scale(1.0 / (1.0 + result.radial2 * a.p2.normSq()));
            GeometryMath_F64.mult((DMatrixRMaj)result.H, (GeoTuple2D_F64)undistorted.p1, (GeoTuple2D_F64)found);
            error += found.distance2((GeoTuple2D_F64)undistorted.p2);
        }
        return Math.sqrt(error) / (double)points.size();
    }

    boolean linearCrossConstraint(List<AssociatedPair> points) {
        this.constructCrossConstraints(points);
        if (!this.svd.decompose((Matrix)this.A)) {
            return false;
        }
        this.svd.getV((Matrix)this.V, false);
        this.svd.getW((Matrix)this.W);
        SingularOps_DDRM.descendingOrder(null, (boolean)false, (DMatrixRMaj)this.W, (DMatrixRMaj)this.V, (boolean)false);
        this.minimalPoints = points.size() == 6;
        int fsv = this.minimalPoints ? 6 : 7;
        double sv1 = this.W.unsafe_get(fsv - 1, fsv - 1);
        double sv2 = this.W.numRows > fsv ? this.W.unsafe_get(fsv, fsv) : 0.0;
        this.crossSingularRatio = sv1 / (UtilEjml.EPS + sv2);
        if (this.minimalPoints) {
            CommonOps_DDRM.extract((DMatrix)this.V, (int)0, (int)8, (int)6, (int)7, (DMatrix)this.null1);
        }
        CommonOps_DDRM.extract((DMatrix)this.V, (int)0, (int)8, (int)7, (int)8, (DMatrix)this.null2);
        return true;
    }

    void constructCrossConstraints(List<AssociatedPair> points) {
        this.A.reshape(points.size(), 8);
        for (int row = 0; row < points.size(); ++row) {
            AssociatedPair p = points.get(row);
            int index = row * this.A.numCols;
            double r1 = p.p1.normSq();
            this.A.data[index++] = -p.p2.y * p.p1.x;
            this.A.data[index++] = -p.p2.y * p.p1.y;
            this.A.data[index++] = -p.p2.y;
            this.A.data[index++] = p.p2.x * p.p1.x;
            this.A.data[index++] = p.p2.x * p.p1.y;
            this.A.data[index++] = p.p2.x;
            this.A.data[index++] = -p.p2.y * r1;
            this.A.data[index] = p.p2.x * r1;
        }
    }

    boolean solveQuadraticRelationship() {
        int i;
        this.hypotheses.reset();
        double n13 = this.null1.data[2];
        double n16 = this.null1.data[5];
        double n23 = this.null2.data[2];
        double n26 = this.null2.data[5];
        double n17 = this.null1.data[6];
        double n18 = this.null1.data[7];
        double n27 = this.null2.data[6];
        double n28 = this.null2.data[7];
        double a = n16 * n17 - n13 * n18;
        double b = n16 * n27 + n17 * n26 - n13 * n28 - n18 * n23;
        double c = n26 * n27 - n23 * n28;
        int numSolutions = BoofMiscOps.quadraticSolver((double)a, (double)b, (double)c, (double[])this.quadraticSolutions);
        if (numSolutions == 0) {
            return false;
        }
        for (i = 0; i < numSolutions; ++i) {
            ((Hypothesis)this.hypotheses.grow()).gamma = this.quadraticSolutions[i];
        }
        for (i = 0; i < this.hypotheses.size; ++i) {
            Hypothesis hypo = (Hypothesis)this.hypotheses.get(i);
            hypo.lambda = this.solveForLambdaGivenGamma(n13, n23, n17, n27, n16, n26, n18, n28, hypo.gamma);
        }
        return true;
    }

    void easyNullSpace() {
        this.hypotheses.reset();
        Hypothesis hypo = (Hypothesis)this.hypotheses.grow();
        hypo.gamma = 0.0;
        double a = this.null2.data[6] / this.null2.data[2];
        double b = this.null2.data[7] / this.null2.data[5];
        hypo.lambda = (a + b) / 2.0;
    }

    boolean solveForRemaining(List<AssociatedPair> points, Hypothesis hypo, Result solution) {
        this.A.reshape(points.size(), 4);
        this.Y.reshape(points.size(), 1);
        double h11 = hypo.gamma * this.null1.data[0] + this.null2.data[0];
        double h12 = hypo.gamma * this.null1.data[1] + this.null2.data[1];
        double h13 = hypo.gamma * this.null1.data[2] + this.null2.data[2];
        for (int row = 0; row < points.size(); ++row) {
            AssociatedPair p = points.get(row);
            double r1 = p.p1.normSq();
            double w1 = 1.0 + hypo.lambda * r1;
            double r2 = p.p2.normSq();
            int index = row * this.A.numCols;
            this.A.data[index++] = p.p2.x * p.p1.x;
            this.A.data[index++] = p.p2.x * p.p1.y;
            this.A.data[index++] = p.p2.x * w1;
            this.A.data[index] = -r2 * (h11 * p.p1.x + h12 * p.p1.y + h13 * w1);
            this.Y.data[row] = h11 * p.p1.x + h12 * p.p1.y + h13 * w1;
        }
        if (!this.solver.setA((Matrix)this.A)) {
            return false;
        }
        this.solver.solve((Matrix)this.Y, (Matrix)this.X);
        solution.radial1 = hypo.lambda;
        solution.radial2 = this.X.data[3];
        solution.H.data[0] = h11;
        solution.H.data[1] = h12;
        solution.H.data[2] = h13;
        solution.H.data[3] = hypo.gamma * this.null1.data[3] + this.null2.data[3];
        solution.H.data[4] = hypo.gamma * this.null1.data[4] + this.null2.data[4];
        solution.H.data[5] = hypo.gamma * this.null1.data[5] + this.null2.data[5];
        solution.H.data[6] = this.X.data[0];
        solution.H.data[7] = this.X.data[1];
        solution.H.data[8] = this.X.data[2];
        return true;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = VerboseUtils.addPrefix((VerbosePrint)this, (PrintStream)out);
    }

    private double solveForLambdaGivenGamma(double n13, double n23, double n17, double n27, double n16, double n26, double n18, double n28, double gamma) {
        double solA = (gamma * n17 + n27) / (gamma * n13 + n23);
        double solB = (gamma * n18 + n28) / (gamma * n16 + n26);
        return (solA + solB) / 2.0;
    }

    public double getCrossSingularRatio() {
        return this.crossSingularRatio;
    }

    public void setSvd(SingularValueDecomposition_F64<DMatrixRMaj> svd) {
        this.svd = svd;
    }

    public void setSolver(LinearSolver<DMatrixRMaj, DMatrixRMaj> solver) {
        this.solver = solver;
    }

    public DogArray<Result> getFound() {
        return this.found;
    }

    static class Hypothesis {
        public double gamma;
        public double lambda;

        Hypothesis() {
        }
    }

    public static class Result {
        public final DMatrixRMaj H = new DMatrixRMaj(3, 3);
        public double radial1;
        public double radial2;
    }
}

