/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.robust;

import boofcv.abst.geo.Triangulate2ViewsMetricH;
import boofcv.alg.geo.DistanceFromModelMultiView;
import boofcv.alg.geo.NormalizedToPinholePixelError;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.geo.AssociatedPair;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.List;

public class DistanceSe3SymmetricSq
implements DistanceFromModelMultiView<Se3_F64, AssociatedPair> {
    private Se3_F64 keyToCurr;
    private Triangulate2ViewsMetricH triangulator;
    private Point4D_F64 p = new Point4D_F64();
    private NormalizedToPinholePixelError errorCam1 = new NormalizedToPinholePixelError();
    private NormalizedToPinholePixelError errorCam2 = new NormalizedToPinholePixelError();

    public DistanceSe3SymmetricSq(Triangulate2ViewsMetricH triangulator) {
        this.triangulator = triangulator;
    }

    public void setModel(Se3_F64 keyToCurr) {
        this.keyToCurr = keyToCurr;
    }

    public double distance(AssociatedPair obs) {
        if (!this.triangulator.triangulate(obs.p1, obs.p2, this.keyToCurr, this.p)) {
            throw new RuntimeException("Triangulate failed. p1=" + String.valueOf(obs.p1) + " p2=" + String.valueOf(obs.p2));
        }
        if (PerspectiveOps.isBehindCamera(this.p)) {
            return Double.MAX_VALUE;
        }
        double error = this.errorCam1.errorSq(obs.p1.x, obs.p1.y, this.p.x / this.p.z, this.p.y / this.p.z);
        SePointOps_F64.transform((Se3_F64)this.keyToCurr, (Point4D_F64)this.p, (Point4D_F64)this.p);
        if (PerspectiveOps.isBehindCamera(this.p)) {
            return Double.MAX_VALUE;
        }
        return error += this.errorCam2.errorSq(obs.p2.x, obs.p2.y, this.p.x / this.p.z, this.p.y / this.p.z);
    }

    public void distances(List<AssociatedPair> associatedPairs, double[] distance) {
        for (int i = 0; i < associatedPairs.size(); ++i) {
            AssociatedPair obs = associatedPairs.get(i);
            distance[i] = this.distance(obs);
        }
    }

    public Class<AssociatedPair> getPointType() {
        return AssociatedPair.class;
    }

    public Class<Se3_F64> getModelType() {
        return Se3_F64.class;
    }

    @Override
    public void setIntrinsic(int view, CameraPinhole intrinsic) {
        if (view == 0) {
            this.errorCam1.setTo(intrinsic.fx, intrinsic.fy, intrinsic.skew);
        } else if (view == 1) {
            this.errorCam2.setTo(intrinsic.fx, intrinsic.fy, intrinsic.skew);
        } else {
            throw new IllegalArgumentException("View must be 0 or 1");
        }
    }

    @Override
    public int getNumberOfViews() {
        return 2;
    }
}

