/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.calibration;

import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.abst.geo.calibration.CalibrationQuality;
import boofcv.abst.geo.calibration.DetectSingleFiducialCalibration;
import boofcv.abst.geo.calibration.ImageResults;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.geo.calibration.CalibrationPlanarGridZhang99;
import boofcv.alg.geo.calibration.ScoreCalibrationFill;
import boofcv.alg.geo.calibration.ScoreCalibrationGeometricDiversity;
import boofcv.alg.geo.calibration.cameras.Zhang99Camera;
import boofcv.alg.geo.calibration.cameras.Zhang99CameraBrown;
import boofcv.alg.geo.calibration.cameras.Zhang99CameraKannalaBrandt;
import boofcv.alg.geo.calibration.cameras.Zhang99CameraUniversalOmni;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraModel;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se3_F64;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class CalibrateMonoPlanar
implements VerbosePrint {
    protected DetectSingleFiducialCalibration detector;
    protected List<List<Point2D_F64>> layouts;
    protected CalibrationPlanarGridZhang99 zhang99;
    protected SceneStructureMetric structure;
    protected CameraModel foundIntrinsic;
    protected List<CalibrationObservation> observations = new ArrayList<CalibrationObservation>();
    protected List<ImageResults> errors = new ArrayList<ImageResults>();
    @Nullable
    public PrintStream verbose = null;
    private int imageWidth;
    private int imageHeight;

    public void initialize(int width, int height, List<List<Point2D_F64>> layouts) {
        this.observations = new ArrayList<CalibrationObservation>();
        this.errors = new ArrayList<ImageResults>();
        this.imageWidth = width;
        this.imageHeight = height;
        this.layouts = layouts;
    }

    public void configure(boolean assumeZeroSkew, Zhang99Camera camera) {
        this.zhang99 = new CalibrationPlanarGridZhang99(camera);
        this.zhang99.setZeroSkew(assumeZeroSkew);
    }

    public void configurePinhole(boolean assumeZeroSkew, int numRadialParam, boolean includeTangential) {
        Zhang99CameraBrown camera = new Zhang99CameraBrown(assumeZeroSkew, includeTangential, numRadialParam);
        this.zhang99 = new CalibrationPlanarGridZhang99(camera);
        this.zhang99.setZeroSkew(assumeZeroSkew);
    }

    public void configureUniversalOmni(boolean assumeZeroSkew, int numRadialParam, boolean includeTangential) {
        this.zhang99 = new CalibrationPlanarGridZhang99(new Zhang99CameraUniversalOmni(assumeZeroSkew, includeTangential, numRadialParam));
        this.zhang99.setZeroSkew(assumeZeroSkew);
    }

    public void configureKannalaBrandt(boolean assumeZeroSkew, int numSymmetric, int numAsymmetric) {
        this.zhang99 = new CalibrationPlanarGridZhang99(new Zhang99CameraKannalaBrandt(assumeZeroSkew, numSymmetric, numAsymmetric));
        this.zhang99.setZeroSkew(assumeZeroSkew);
    }

    public void configureUniversalOmni(boolean assumeZeroSkew, int numRadialParam, boolean includeTangential, double mirrorOffset) {
        this.zhang99 = new CalibrationPlanarGridZhang99(new Zhang99CameraUniversalOmni(assumeZeroSkew, includeTangential, numRadialParam, mirrorOffset));
        this.zhang99.setZeroSkew(assumeZeroSkew);
    }

    public boolean isExpectedShape(int width, int height) {
        return width == this.imageWidth && height == this.imageHeight;
    }

    public void addImage(CalibrationObservation observation) {
        this.observations.add(observation);
    }

    public void removeLatestImage() {
        this.observations.remove(this.observations.size() - 1);
    }

    public <T extends CameraModel> T process() {
        if (this.imageWidth == 0) {
            throw new RuntimeException("Must call initialize() first");
        }
        if (this.zhang99 == null) {
            throw new IllegalArgumentException("Please call configure first.");
        }
        this.zhang99.setLayouts(this.layouts);
        this.zhang99.setVerbose(this.verbose, null);
        if (!this.zhang99.process(this.observations)) {
            throw new RuntimeException("Zhang99 algorithm failed!");
        }
        this.structure = this.zhang99.getStructure();
        this.errors = this.zhang99.computeErrors();
        this.foundIntrinsic = this.zhang99.getCameraModel();
        this.foundIntrinsic.width = this.imageWidth;
        this.foundIntrinsic.height = this.imageHeight;
        return (T)this.foundIntrinsic;
    }

    public Se3_F64 getTargetToView(int viewIdx) {
        return this.structure.getParentToView(viewIdx);
    }

    public String computeQualityText(List<String> imageNames) {
        ScoreCalibrationFill fillScore = new ScoreCalibrationFill();
        CalibrationQuality quality = new CalibrationQuality();
        CalibrateMonoPlanar.computeQuality(this.foundIntrinsic, fillScore, this.layouts, this.observations, quality);
        return CalibrateMonoPlanar.computeQualityText(this.errors, imageNames, quality);
    }

    public static String computeQualityText(List<ImageResults> errors, List<String> imageNames, CalibrationQuality quality) {
        BoofMiscOps.checkEq((int)errors.size(), (int)imageNames.size());
        double[] summaryThresholds = new double[]{0.25, 0.5, 1.0, 2.0, 3.0, 5.0, 10.0, 20.0};
        int[] counts = new int[summaryThresholds.length];
        int totalObservations = 0;
        for (int i = 0; i < imageNames.size(); ++i) {
            ImageResults r = errors.get(i);
            totalObservations += r.pointError.length;
            for (int j = 0; j < r.pointError.length; ++j) {
                double e = r.pointError[j];
                int iterThresh = summaryThresholds.length - 1;
                while (iterThresh >= 0 && !(summaryThresholds[iterThresh] < e)) {
                    int n = iterThresh--;
                    counts[n] = counts[n] + 1;
                }
            }
        }
        double averageError = 0.0;
        double maxError = 0.0;
        for (int i = 0; i < imageNames.size(); ++i) {
            ImageResults r = errors.get(i);
            averageError += r.meanError;
            maxError = Math.max(maxError, r.maxError);
        }
        averageError /= (double)imageNames.size();
        Object text = "";
        text = (String)text + String.format("quality.fill_border  %5.1f%%\n", 100.0 * quality.borderFill);
        text = (String)text + String.format("quality.fill_inner   %5.1f%%\n", 100.0 * quality.innerFill);
        text = (String)text + String.format("quality.geometric    %5.1f%%\n", 100.0 * quality.geometric);
        text = (String)text + "\n";
        text = (String)text + String.format("Reprojection Errors (px):\nmean=%.3f max=%.3f\n\n", averageError, maxError);
        StringBuilder builder = new StringBuilder();
        CalibrateMonoPlanar.generateReprojectionErrorHistogram(summaryThresholds, counts, totalObservations, builder);
        text = (String)text + builder.toString();
        text = (String)text + String.format("%-10s | %8s\n", "image", "max (px)");
        for (int i = 0; i < imageNames.size(); ++i) {
            String image = imageNames.get(i);
            ImageResults r = errors.get(i);
            text = (String)text + String.format("%-12s %8.3f\n", new File(image).getName(), r.maxError);
        }
        return text;
    }

    public static void generateReprojectionErrorHistogram(double[] thresholds, int[] counts, int totalObservations, StringBuilder builder) {
        int i;
        builder.append("Percent Reprojection Errors Less than X pixels. N=").append(totalObservations).append("\n");
        for (i = 0; i < thresholds.length; ++i) {
            builder.append(String.format(" %6.2f |", thresholds[i]));
        }
        builder.append("\n");
        for (i = 0; i < counts.length; ++i) {
            builder.append(String.format(" %5.1f%% |", 100.0 * (double)counts[i] / (double)totalObservations));
        }
        builder.append("\n\n");
    }

    public static void computeQuality(CameraModel intrinsic, ScoreCalibrationFill fillScorer, List<List<Point2D_F64>> targetLayouts, List<CalibrationObservation> observations, CalibrationQuality quality) {
        fillScorer.initialize(intrinsic.width, intrinsic.height);
        ScoreCalibrationGeometricDiversity geoScorer = new ScoreCalibrationGeometricDiversity(true);
        for (int i = 0; i < observations.size(); ++i) {
            CalibrationObservation obs = observations.get(i);
            fillScorer.addObservation(obs.points);
            geoScorer.addObservation(obs.points, targetLayouts.get(obs.target));
        }
        geoScorer.computeScore();
        quality.borderFill = fillScorer.getScoreBorder();
        quality.innerFill = fillScorer.getScoreInner();
        quality.geometric = geoScorer.getScore();
    }

    public static void printErrors(List<ImageResults> results, PrintStream out) {
        double totalError = 0.0;
        for (int i = 0; i < results.size(); ++i) {
            ImageResults r = results.get(i);
            totalError += r.meanError;
            out.printf("image %3d errors (px) mean=%7.1e max=%7.1e, bias: %8.1e %8.1e\n", i, r.meanError, r.maxError, r.biasX, r.biasY);
        }
        out.println("Average Mean Error = " + totalError / (double)results.size());
    }

    public <T extends CameraModel> T getIntrinsic() {
        return (T)this.foundIntrinsic;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = out;
    }

    public CalibrationPlanarGridZhang99 getZhang99() {
        return this.zhang99;
    }

    public SceneStructureMetric getStructure() {
        return this.structure;
    }

    public List<CalibrationObservation> getObservations() {
        return this.observations;
    }

    public List<ImageResults> getErrors() {
        return this.errors;
    }
}

