/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.calibration;

import boofcv.abst.geo.calibration.DetectMultiFiducialCalibration;
import boofcv.abst.geo.calibration.DetectSingleFiducialCalibration;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MultiToSingleFiducialCalibration
implements DetectSingleFiducialCalibration {
    DetectMultiFiducialCalibration multi;
    int targetMarker = 0;
    private int detectedIndex;
    int width;
    int height;

    public MultiToSingleFiducialCalibration(DetectMultiFiducialCalibration alg) {
        this.multi = alg;
    }

    public MultiToSingleFiducialCalibration(int target, DetectMultiFiducialCalibration alg) {
        this.targetMarker = target;
        this.multi = alg;
    }

    @Override
    public boolean process(GrayF32 input) {
        this.multi.process(input);
        this.width = input.width;
        this.height = input.height;
        this.detectedIndex = -1;
        for (int i = 0; i < this.multi.getDetectionCount(); ++i) {
            CalibrationObservation o = this.multi.getDetectedPoints(i);
            if (o.target != this.targetMarker) continue;
            this.detectedIndex = i;
            break;
        }
        return this.detectedIndex != -1;
    }

    @Override
    public CalibrationObservation getDetectedPoints() {
        if (this.detectedIndex == -1) {
            return new CalibrationObservation();
        }
        return this.multi.getDetectedPoints(this.detectedIndex);
    }

    @Override
    public List<Point2D_F64> getLayout() {
        return this.multi.getLayout(this.targetMarker);
    }

    @Override
    public void setLensDistortion(@Nullable LensDistortionNarrowFOV distortion, int width, int height) {
        this.multi.setLensDistortion(distortion, width, height);
    }

    public DetectMultiFiducialCalibration getMulti() {
        return this.multi;
    }

    public int getTargetMarker() {
        return this.targetMarker;
    }

    public void setTargetMarker(int targetMarker) {
        this.targetMarker = targetMarker;
    }
}

