/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.brown;

import boofcv.alg.distort.brown.RadialTangential_F32;
import boofcv.alg.distort.brown.RemoveBrownNtoN_F32;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.distort.Point2Transform2_F32;
import georegression.misc.GrlConstants;
import georegression.struct.point.Point2D_F32;
import org.jetbrains.annotations.Nullable;

public class RemoveBrownPtoN_F32
implements Point2Transform2_F32 {
    public float cx;
    public float cy;
    public float fx;
    public float fy;
    public float skew;
    public RadialTangential_F32 params;
    private float a11;
    private float a12;
    private float a13;
    private float a22;
    private float a23;
    private float tol = GrlConstants.FCONV_TOL_A;

    public RemoveBrownPtoN_F32() {
    }

    public RemoveBrownPtoN_F32(float tol) {
        this.tol = tol;
    }

    public void setTolerance(float tol) {
        this.tol = tol;
    }

    public RemoveBrownPtoN_F32 setK(double fx, double fy, double skew, double cx, double cy) {
        this.fx = (float)fx;
        this.fy = (float)fy;
        this.skew = (float)skew;
        this.cx = (float)cx;
        this.cy = (float)cy;
        this.a11 = (float)(1.0 / fx);
        this.a12 = (float)(-skew / (fx * fy));
        this.a13 = (float)((skew * cy - cx * fy) / (fx * fy));
        this.a22 = (float)(1.0 / fy);
        this.a23 = (float)(-cy / fy);
        return this;
    }

    public RemoveBrownPtoN_F32 setDistortion(@Nullable double[] radial, double t1, double t2) {
        if (this.params != null && radial != null && this.params.radial.length == radial.length) {
            System.arraycopy(radial, 0, this.params.radial, 0, radial.length);
            return this;
        }
        this.params = new RadialTangential_F32(radial, t1, t2);
        return this;
    }

    public RemoveBrownPtoN_F32 setDistortion(double radial1, double radial2) {
        if (this.params != null && this.params.radial.length == 2) {
            this.params.radial[0] = (float)radial1;
            this.params.radial[1] = (float)radial2;
            return this;
        }
        this.params = new RadialTangential_F32(new double[]{radial1, radial2}, 0.0, 0.0);
        return this;
    }

    public RemoveBrownPtoN_F32 setParameters(CameraPinholeBrown p) {
        return this.setK(p.fx, p.fy, p.skew, p.cx, p.cy).setDistortion(p.radial, p.t1, p.t2);
    }

    public void compute(float x, float y, Point2D_F32 out) {
        out.x = this.a11 * x + this.a12 * y + this.a13;
        out.y = this.a22 * y + this.a23;
        RemoveBrownNtoN_F32.removeRadial(out.x, out.y, this.params.radial, this.params.t1, this.params.t2, out, this.tol);
    }

    public RemoveBrownPtoN_F32 copyConcurrent() {
        RemoveBrownPtoN_F32 ret = new RemoveBrownPtoN_F32(this.tol);
        ret.fx = this.fx;
        ret.fy = this.fy;
        ret.skew = this.skew;
        ret.cx = this.cx;
        ret.cy = this.cy;
        ret.a11 = this.a11;
        ret.a12 = this.a12;
        ret.a13 = this.a13;
        ret.a22 = this.a22;
        ret.a23 = this.a23;
        ret.params = new RadialTangential_F32(this.params);
        return ret;
    }

    public void reset() {
        this.fy = 0.0f;
        this.fx = 0.0f;
        this.skew = 0.0f;
        this.cy = 0.0f;
        this.cx = 0.0f;
        this.a23 = 0.0f;
        this.a22 = 0.0f;
        this.a13 = 0.0f;
        this.a12 = 0.0f;
        this.a11 = 0.0f;
    }
}

