/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.kanbra;

import boofcv.alg.distort.kanbra.KannalaBrandtUtils_F64;
import boofcv.alg.distort.pinhole.PinholePtoN_F32;
import boofcv.misc.BoofMiscOps;
import boofcv.misc.ConfigConverge;
import boofcv.struct.calib.CameraKannalaBrandt;
import boofcv.struct.distort.Point2Transform3_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point3D_F32;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.ddogleg.solver.Polynomial;
import org.ddogleg.solver.PolynomialOps;
import org.ddogleg.solver.PolynomialRoots;
import org.ddogleg.solver.RootFinderType;
import org.ddogleg.struct.VerbosePrint;
import org.ddogleg.util.VerboseUtils;
import org.ejml.UtilEjml;
import org.ejml.data.Complex_F64;
import org.ejml.data.FMatrix2x2;
import org.ejml.dense.fixed.CommonOps_FDF2;
import org.ejml.dense.fixed.MatrixFeatures_FDF2;
import org.jetbrains.annotations.Nullable;

public class KannalaBrandtPtoS_F32
implements Point2Transform3_F32,
VerbosePrint {
    public float realNumberTol = UtilEjml.TEST_F32;
    public final ConfigConverge converge = new ConfigConverge(1.0E-6, 1.0E-6, 20);
    protected final CameraKannalaBrandt model;
    PinholePtoN_F32 pinholePtoN = new PinholePtoN_F32();
    Point2D_F32 norm = new Point2D_F32();
    public PolynomialRoots rootFinder;
    private final Polynomial polynomial = new Polynomial(5);
    float updatedTheta;
    float updatedphi;
    FMatrix2x2 jacobian = new FMatrix2x2();
    FMatrix2x2 jacobianInv = new FMatrix2x2();
    @Nullable
    PrintStream verbose;

    public KannalaBrandtPtoS_F32(CameraKannalaBrandt model) {
        BoofMiscOps.checkTrue((model.radialTrig.length == 0 || model.radialTrig.length == 4 ? 1 : 0) != 0);
        this.model = new CameraKannalaBrandt(model);
        this.pinholePtoN.setK(model);
        int numCoef = 1 + model.symmetric.length * 2;
        this.rootFinder = PolynomialOps.createRootFinder((int)numCoef, (RootFinderType)RootFinderType.EVD);
        this.polynomial.resize(numCoef);
    }

    public void compute(float x, float y, Point3D_F32 out) {
        this.pinholePtoN.compute(x, y, this.norm);
        float r = this.norm.norm();
        float phi = (float)Math.atan2(this.norm.y, this.norm.x);
        float theta = this.computeTheta(r);
        if (this.model.isAsymmetricModel()) {
            this.newtonsMethodUpdateThetaphi(theta, phi, r);
            phi = this.updatedphi;
            theta = this.updatedTheta;
        }
        if (theta == Float.MAX_VALUE) {
            out.setTo(0.0f, 0.0f, 0.0f);
            return;
        }
        float sintheta = (float)Math.sin(theta);
        out.x = sintheta * (float)Math.cos(phi);
        out.y = sintheta * (float)Math.sin(phi);
        out.z = (float)Math.cos(theta);
    }

    float computeTheta(float r) {
        Arrays.fill(this.polynomial.c, 0.0);
        this.polynomial.c[0] = -r;
        for (int i = 0; i < this.model.symmetric.length; ++i) {
            this.polynomial.c[i * 2 + 1] = this.model.symmetric[i];
        }
        if (!this.rootFinder.process(this.polynomial)) {
            return Float.MAX_VALUE;
        }
        float theta = Float.MAX_VALUE;
        List roots = this.rootFinder.getRoots();
        for (int i = 0; i < roots.size(); ++i) {
            Complex_F64 root = (Complex_F64)roots.get(i);
            if (!(Math.abs(root.imaginary) <= (double)this.realNumberTol) || !((double)theta > root.real) || !(root.real > (double)(-this.realNumberTol))) continue;
            theta = (float)root.real;
        }
        return Math.max(0.0f, theta);
    }

    protected void newtonsMethodUpdateThetaphi(float theta, float phi, float r) {
        float previousError = Float.MAX_VALUE;
        this.updatedTheta = theta;
        this.updatedphi = phi;
        float updatedR = r;
        for (int iteration = 0; iteration < this.converge.maxIterations; ++iteration) {
            float cosphi = (float)Math.cos(this.updatedphi);
            float sinphi = (float)Math.sin(this.updatedphi);
            float disRad = (float)(KannalaBrandtUtils_F64.polynomial(this.model.radial, this.updatedTheta) * KannalaBrandtUtils_F64.polytrig(this.model.radialTrig, cosphi, sinphi));
            float disTan = (float)(KannalaBrandtUtils_F64.polynomial(this.model.tangent, this.updatedTheta) * KannalaBrandtUtils_F64.polytrig(this.model.tangentTrig, cosphi, sinphi));
            float dx = (updatedR + disRad) * cosphi - disTan * sinphi;
            float dy = (updatedR + disRad) * sinphi + disTan * cosphi;
            float error = this.norm.distance(dx, dy);
            if (this.verbose != null) {
                this.verbose.printf("[%3d] error=%.2e theta=%.4f phi=%.4f\n", iteration, Float.valueOf(error), Float.valueOf(this.updatedTheta), Float.valueOf(this.updatedphi));
            }
            if (error > previousError) {
                if (this.verbose == null) break;
                this.verbose.println("converged: error > previousError");
                break;
            }
            if ((double)Math.abs(error) <= this.converge.ftol) {
                if (this.verbose == null) break;
                this.verbose.println("converged: ftol");
                break;
            }
            if ((double)(Math.abs(error - previousError) / Math.max(error, previousError)) <= this.converge.gtol) {
                if (this.verbose == null) break;
                this.verbose.println("converged: gtol");
                break;
            }
            previousError = error;
            theta = this.updatedTheta;
            phi = this.updatedphi;
            this.jacobianOfDistorted(theta, cosphi, sinphi, this.jacobian);
            if (!CommonOps_FDF2.invert((FMatrix2x2)this.jacobian, (FMatrix2x2)this.jacobianInv) || MatrixFeatures_FDF2.hasUncountable((FMatrix2x2)this.jacobianInv)) {
                if (this.verbose == null) break;
                this.verbose.println("Bad matrix inverse");
                break;
            }
            dx = this.norm.x - dx;
            dy = this.norm.y - dy;
            float deltaTheta = this.jacobianInv.a11 * dx + this.jacobianInv.a12 * dy;
            float deltaphi = this.jacobianInv.a21 * dx + this.jacobianInv.a22 * dy;
            this.updatedTheta = theta + deltaTheta;
            this.updatedphi = phi + deltaphi;
            updatedR = (float)KannalaBrandtUtils_F64.polynomial(this.model.symmetric, this.updatedTheta);
        }
    }

    protected void jacobianOfDistorted(float theta, float cosphi, float sinphi, FMatrix2x2 gradient) {
        float sym = (float)KannalaBrandtUtils_F64.polynomial(this.model.symmetric, theta);
        float sym_dtheta = (float)KannalaBrandtUtils_F64.polynomialDerivative(this.model.symmetric, theta);
        float deltaR = (float)(KannalaBrandtUtils_F64.polynomial(this.model.radial, theta) * KannalaBrandtUtils_F64.polytrig(this.model.radialTrig, cosphi, sinphi));
        float deltaR_dtheta = (float)(KannalaBrandtUtils_F64.polynomialDerivative(this.model.radial, theta) * KannalaBrandtUtils_F64.polytrig(this.model.radialTrig, cosphi, sinphi));
        float deltaR_dphi = (float)(KannalaBrandtUtils_F64.polynomial(this.model.radial, theta) * KannalaBrandtUtils_F64.polytrigDerivative(this.model.radialTrig, cosphi, sinphi));
        float deltaT = (float)(KannalaBrandtUtils_F64.polynomial(this.model.tangent, theta) * KannalaBrandtUtils_F64.polytrig(this.model.tangentTrig, cosphi, sinphi));
        float deltaT_dtheta = (float)(KannalaBrandtUtils_F64.polynomialDerivative(this.model.tangent, theta) * KannalaBrandtUtils_F64.polytrig(this.model.tangentTrig, cosphi, sinphi));
        float deltaT_dphi = (float)(KannalaBrandtUtils_F64.polynomial(this.model.tangent, theta) * KannalaBrandtUtils_F64.polytrigDerivative(this.model.tangentTrig, cosphi, sinphi));
        gradient.a11 = (sym_dtheta + deltaR_dtheta) * cosphi - deltaT_dtheta * sinphi;
        gradient.a12 = -sym * sinphi + deltaR_dphi * cosphi - deltaR * sinphi - deltaT_dphi * sinphi - deltaT * cosphi;
        gradient.a21 = (sym_dtheta + deltaR_dtheta) * sinphi + deltaT_dtheta * cosphi;
        gradient.a22 = sym * cosphi + deltaR_dphi * sinphi + deltaR * cosphi + deltaT_dphi * cosphi - deltaT * sinphi;
    }

    public Point2Transform3_F32 copyConcurrent() {
        return new KannalaBrandtPtoS_F32(this.model);
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = VerboseUtils.addPrefix((VerbosePrint)this, (PrintStream)out);
    }
}

