/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.pinhole;

import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.distort.Point2Transform2_F32;
import georegression.struct.point.Point2D_F32;

public class PinholePtoN_F32
implements Point2Transform2_F32 {
    public float a11;
    public float a12;
    public float a13;
    public float a22;
    public float a23;

    public PinholePtoN_F32(PinholePtoN_F32 original) {
        this.a11 = original.a11;
        this.a12 = original.a12;
        this.a13 = original.a13;
        this.a22 = original.a22;
        this.a23 = original.a23;
    }

    public PinholePtoN_F32() {
    }

    public PinholePtoN_F32 setK(CameraPinhole pinhole) {
        return this.setK(pinhole.fx, pinhole.fy, pinhole.skew, pinhole.cx, pinhole.cy);
    }

    public PinholePtoN_F32 setK(double fx, double fy, double skew, double cx, double cy) {
        this.a11 = (float)(1.0 / fx);
        this.a12 = (float)(-skew / (fx * fy));
        this.a13 = (float)((skew * cy - cx * fy) / (fx * fy));
        this.a22 = (float)(1.0 / fy);
        this.a23 = (float)(-cy / fy);
        return this;
    }

    public void compute(float x, float y, Point2D_F32 out) {
        out.x = this.a11 * x + this.a12 * y + this.a13;
        out.y = this.a22 * y + this.a23;
    }

    public PinholePtoN_F32 copyConcurrent() {
        return new PinholePtoN_F32(this);
    }
}

