/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import georegression.struct.point.Point3D_F64;

public class PointingToPinholePixelError {
    private double fx;
    private double fy;
    private double skew;

    public PointingToPinholePixelError(double fx, double fy, double skew) {
        this.setTo(fx, fy, skew);
    }

    public PointingToPinholePixelError() {
    }

    public void setTo(double fx, double fy, double skew) {
        this.fx = fx;
        this.fy = fy;
        this.skew = skew;
    }

    public double errorSq(Point3D_F64 a, Point3D_F64 b) {
        return this.errorSq(a.x, a.y, a.z, b.x, b.y, b.z);
    }

    public double errorSq(double a_x, double a_y, double a_z, double b_x, double b_y, double b_z) {
        if (a_z != 0.0) {
            a_x /= a_z;
            a_y /= a_z;
        }
        if (b_z != 0.0) {
            b_x /= b_z;
            b_y /= b_z;
        }
        double dy = b_y - a_y;
        double dx = (b_x - a_x) * this.fx + dy * this.skew;
        return dx * dx + (dy *= this.fy) * dy;
    }
}

