/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle;

import boofcv.abst.geo.bundle.BundleAdjustmentSchur;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureProjective;

public class CodecSceneStructureProjective
implements BundleAdjustmentSchur.Codec<SceneStructureProjective> {
    @Override
    public void decode(double[] input, SceneStructureProjective structure) {
        int i;
        int index = 0;
        for (i = 0; i < structure.points.size; ++i) {
            SceneStructureCommon.Point p = ((SceneStructureCommon.Point[])structure.points.data)[i];
            p.coordinate[0] = input[index++];
            p.coordinate[1] = input[index++];
            p.coordinate[2] = input[index++];
            if (!structure.isHomogeneous()) continue;
            p.coordinate[3] = input[index++];
        }
        for (int viewIndex = 0; viewIndex < structure.views.size; ++viewIndex) {
            SceneStructureProjective.View view = ((SceneStructureProjective.View[])structure.views.data)[viewIndex];
            if (view.known) continue;
            for (int i2 = 0; i2 < 12; ++i2) {
                view.worldToView.data[i2] = input[index++];
            }
        }
        for (i = 0; i < structure.cameras.size; ++i) {
            SceneStructureCommon.Camera camera = ((SceneStructureCommon.Camera[])structure.cameras.data)[i];
            if (camera.known) continue;
            camera.model.setIntrinsic(input, index);
            index += camera.model.getIntrinsicCount();
        }
    }

    @Override
    public void encode(SceneStructureProjective structure, double[] output) {
        int i;
        int index = 0;
        for (i = 0; i < structure.points.size; ++i) {
            SceneStructureCommon.Point p = ((SceneStructureCommon.Point[])structure.points.data)[i];
            output[index++] = p.coordinate[0];
            output[index++] = p.coordinate[1];
            output[index++] = p.coordinate[2];
            if (!structure.isHomogeneous()) continue;
            output[index++] = p.coordinate[3];
        }
        for (int viewIndex = 0; viewIndex < structure.views.size; ++viewIndex) {
            SceneStructureProjective.View view = ((SceneStructureProjective.View[])structure.views.data)[viewIndex];
            if (view.known) continue;
            for (int i2 = 0; i2 < 12; ++i2) {
                output[index++] = view.worldToView.data[i2];
            }
        }
        for (i = 0; i < structure.cameras.size; ++i) {
            SceneStructureCommon.Camera camera = ((SceneStructureCommon.Camera[])structure.cameras.data)[i];
            if (camera.known) continue;
            camera.model.getIntrinsic(output, index);
            index += camera.model.getIntrinsicCount();
        }
    }
}

