/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import boofcv.alg.geo.calibration.Zhang99CalibrationMatrixFromHomographies;
import boofcv.alg.geo.calibration.Zhang99ComputeTargetHomography;
import boofcv.struct.geo.PointIndex2D_F64;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ejml.data.DMatrixRMaj;

public class ScoreCalibrationGeometricDiversity {
    Zhang99ComputeTargetHomography computeHomography;
    Zhang99CalibrationMatrixFromHomographies computeCalib;
    List<DMatrixRMaj> homographies = new ArrayList<DMatrixRMaj>();
    double score = 0.0;

    public ScoreCalibrationGeometricDiversity(boolean assumeZeroSkew) {
        this.computeCalib = new Zhang99CalibrationMatrixFromHomographies(assumeZeroSkew);
        this.computeHomography = new Zhang99ComputeTargetHomography();
    }

    public void addObservation(List<PointIndex2D_F64> observation, List<Point2D_F64> layout) {
        if (observation.size() <= 4) {
            return;
        }
        this.computeHomography.setTargetLayout(layout);
        if (!this.computeHomography.computeHomography(observation)) {
            System.err.println("Failed to compute homography");
            return;
        }
        this.homographies.add(this.computeHomography.getCopyOfHomography());
    }

    public void computeScore() {
        try {
            this.computeCalib.process(this.homographies);
            double[] values = this.computeCalib.getSolverNull().getSingularValues();
            Arrays.sort(values, 0, 3);
            this.score = Math.min(1.0, values[1] / values[2] / 0.2);
        }
        catch (RuntimeException e) {
            this.score = 0.0;
        }
    }

    public double getScore() {
        return this.score;
    }
}

