/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration.cameras;

import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.alg.geo.bundle.BundleAdjustmentOps;
import boofcv.alg.geo.bundle.cameras.BundlePinholeBrown;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.geo.calibration.RadialDistortionEstimateLinear;
import boofcv.alg.geo.calibration.cameras.Zhang99Camera;
import boofcv.struct.calib.CameraModel;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ejml.data.DMatrixRMaj;

public class Zhang99CameraBrown
implements Zhang99Camera {
    boolean assumeZeroSkew;
    boolean includeTangential;
    private final RadialDistortionEstimateLinear computeRadial;

    public Zhang99CameraBrown(boolean assumeZeroSkew, boolean includeTangential, int numRadial) {
        this.assumeZeroSkew = assumeZeroSkew;
        this.includeTangential = includeTangential;
        this.computeRadial = new RadialDistortionEstimateLinear(numRadial);
    }

    @Override
    public void setLayouts(List<List<Point2D_F64>> layouts) {
        this.computeRadial.setLayouts(layouts);
    }

    @Override
    public BundleAdjustmentCamera initializeCamera(DMatrixRMaj K, List<DMatrixRMaj> homographies, List<CalibrationObservation> observations) {
        this.computeRadial.process(K, homographies, observations);
        BundlePinholeBrown cam = new BundlePinholeBrown(this.assumeZeroSkew, this.includeTangential);
        cam.radial = (double[])this.computeRadial.getParameters().clone();
        cam.setK(K);
        return cam;
    }

    @Override
    public CameraModel getCameraModel(BundleAdjustmentCamera bundleCam) {
        BundlePinholeBrown cam = (BundlePinholeBrown)bundleCam;
        return BundleAdjustmentOps.convert(cam, 0, 0, null);
    }
}

