/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.h;

import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.PairLineNorm;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.GeoTuple3D_F64;
import java.util.Arrays;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.decomposition.svd.SafeSvd_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public class AdjustHomographyMatrix {
    protected SingularValueDecomposition_F64<DMatrixRMaj> svd = new SafeSvd_DDRM(DecompositionFactory_DDRM.svd((int)0, (int)0, (boolean)true, (boolean)true, (boolean)false));
    DMatrixRMaj H_t = new DMatrixRMaj(3, 3);

    public boolean adjust(DMatrixRMaj H, AssociatedPair p) {
        if (!this.findScaleH(H)) {
            return false;
        }
        this.adjustHomographSign(p, H);
        return true;
    }

    public boolean adjust(DMatrixRMaj H, PairLineNorm p) {
        if (!this.findScaleH(H)) {
            return false;
        }
        this.adjustHomographSign(p, H);
        return true;
    }

    protected boolean findScaleH(DMatrixRMaj H) {
        if (!this.svd.decompose((Matrix)H)) {
            return false;
        }
        Arrays.sort(this.svd.getSingularValues(), 0, 3);
        double scale = this.svd.getSingularValues()[1];
        CommonOps_DDRM.divide((DMatrixD1)H, (double)scale);
        return true;
    }

    protected void adjustHomographSign(AssociatedPair p, DMatrixRMaj H) {
        double val = GeometryMath_F64.innerProd((GeoTuple2D_F64)p.p2, (DMatrixRMaj)H, (GeoTuple2D_F64)p.p1);
        if (val < 0.0) {
            CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)H);
        }
    }

    protected void adjustHomographSign(PairLineNorm p, DMatrixRMaj H) {
        CommonOps_DDRM.transpose((DMatrixRMaj)H, (DMatrixRMaj)this.H_t);
        double val = GeometryMath_F64.innerProd((GeoTuple3D_F64)p.l1, (DMatrixRMaj)this.H_t, (GeoTuple3D_F64)p.l2);
        if (val < 0.0) {
            CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)H);
        }
    }
}

